/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ExecutionStatusCalculator;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ScenarioModel {
    private String className;
    private String testMethodName;
    private String description;
    private Set<String> tagIds = Sets.newLinkedHashSet();
    private boolean pending;
    private List<String> explicitParameters = Lists.newArrayList();
    private List<String> derivedParameters = Lists.newArrayList();
    private boolean casesAsTable;
    private final List<ScenarioCaseModel> scenarioCases = Lists.newArrayList();
    private long durationInNanos;
    private ExecutionStatus executionStatus;

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        for (ScenarioCaseModel scenarioCase : this.getScenarioCases()) {
            scenarioCase.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    public synchronized void addCase(ScenarioCaseModel scenarioCase) {
        scenarioCase.setCaseNr(this.scenarioCases.size() + 1);
        this.scenarioCases.add(scenarioCase);
        this.executionStatus = null;
    }

    public ExecutionStatus getExecutionStatus() {
        if (this.executionStatus == null) {
            ExecutionStatusCalculator executionStatusCalculator = new ExecutionStatusCalculator();
            this.accept(executionStatusCalculator);
            this.executionStatus = executionStatusCalculator.executionStatus();
        }
        return this.executionStatus;
    }

    public ScenarioCaseModel getCase(int i) {
        return this.scenarioCases.get(i);
    }

    public synchronized void addTag(Tag tag) {
        this.tagIds.add(tag.toIdString());
    }

    public void addTags(List<Tag> tags) {
        for (Tag tag : tags) {
            this.addTag(tag);
        }
    }

    public synchronized void addParameterNames(String ... params) {
        this.explicitParameters.addAll(Arrays.asList(params));
    }

    public synchronized void setExplicitParameters(List<String> params) {
        this.explicitParameters.clear();
        this.explicitParameters.addAll(params);
    }

    public List<String> getExplicitParameters() {
        return Collections.unmodifiableList(this.explicitParameters);
    }

    public List<ScenarioCaseModel> getScenarioCases() {
        return this.scenarioCases;
    }

    public List<String> getTagIds() {
        return Lists.newArrayList(this.tagIds);
    }

    public boolean isCasesAsTable() {
        return this.casesAsTable;
    }

    public void setCasesAsTable(boolean casesAsTable) {
        this.casesAsTable = casesAsTable;
    }

    public void clearCases() {
        this.scenarioCases.clear();
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public void setDurationInNanos(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }

    public void addDurationInNanos(long durationInNanosDelta) {
        this.durationInNanos += durationInNanosDelta;
    }

    public void addDerivedParameter(String parameterName) {
        this.derivedParameters.add(parameterName);
    }

    public List<String> getDerivedParameters() {
        return Collections.unmodifiableList(this.derivedParameters);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTestMethodName() {
        return this.testMethodName;
    }

    public void setTestMethodName(String testMethodName) {
        this.testMethodName = testMethodName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }
}

