/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.AnnotationFormat;
import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.Description;
import com.tngtech.jgiven.annotation.ExtendedDescription;
import com.tngtech.jgiven.annotation.Format;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.IntroWord;
import com.tngtech.jgiven.annotation.IsTag;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.config.AbstractJGivenConfiguraton;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.config.TagConfiguration;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.TableFormatter;
import com.tngtech.jgiven.impl.intercept.InvocationMode;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepFormatter;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioModelBuilder
implements ScenarioListener {
    private static final Logger log = LoggerFactory.getLogger(ScenarioModelBuilder.class);
    private static final StepFormatter.Formatting<?> DEFAULT_FORMATTING = new StepFormatter.Formatting(new DefaultFormatter(), new String[0]);
    private ScenarioModel scenarioModel;
    private ScenarioCaseModel scenarioCaseModel;
    private StepModel currentStep;
    private Word introWord;
    private long scenarioStartedNanos;
    private AbstractJGivenConfiguraton configuration = new DefaultConfiguration();
    private ReportModel reportModel;

    public void setReportModel(ReportModel reportModel) {
        this.reportModel = reportModel;
    }

    @Override
    public void scenarioStarted(String description) {
        this.scenarioStartedNanos = System.nanoTime();
        String readableDescription = description;
        if (description.contains("_")) {
            readableDescription = description.replace('_', ' ');
        } else if (!description.contains(" ")) {
            readableDescription = this.camelCaseToReadableText(description);
        }
        this.scenarioCaseModel = new ScenarioCaseModel();
        this.scenarioModel = new ScenarioModel();
        this.scenarioModel.addCase(this.scenarioCaseModel);
        this.scenarioModel.setDescription(readableDescription);
    }

    private String camelCaseToReadableText(String camelCase) {
        String scenarioDescription = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelCase).replace('_', ' ');
        return WordUtil.capitalize(scenarioDescription);
    }

    public void addStepMethod(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        StepModel stepModel;
        this.currentStep = stepModel = this.createStepModel(paramMethod, arguments, mode);
        this.writeStep(stepModel);
    }

    StepModel createStepModel(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        StepModel stepModel = new StepModel();
        stepModel.name = this.getDescription(paramMethod);
        ExtendedDescription extendedDescriptionAnnotation = paramMethod.getAnnotation(ExtendedDescription.class);
        if (extendedDescriptionAnnotation != null) {
            stepModel.setExtendedDescription(extendedDescriptionAnnotation.value());
        }
        List<NamedArgument> nonHiddenArguments = this.filterHiddenArguments(arguments, paramMethod.getParameterAnnotations());
        List<StepFormatter.Formatting<?>> formatters = this.getFormatters(paramMethod.getParameterAnnotations());
        stepModel.words = new StepFormatter(stepModel.name, nonHiddenArguments, formatters).buildFormattedWords();
        if (this.introWord != null) {
            stepModel.words.add(0, this.introWord);
            this.introWord = null;
        }
        stepModel.setStatus(mode.toStepStatus());
        return stepModel;
    }

    private List<NamedArgument> filterHiddenArguments(List<NamedArgument> arguments, Annotation[][] parameterAnnotations) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (this.isHidden(parameterAnnotations[i])) continue;
            result.add(arguments.get(i));
        }
        return result;
    }

    @Override
    public void introWordAdded(String value) {
        this.introWord = new Word();
        this.introWord.setIntroWord(true);
        this.introWord.setValue(value);
    }

    private List<StepFormatter.Formatting<?>> getFormatters(Annotation[][] parameterAnnotations) {
        ArrayList res = Lists.newArrayList();
        for (Annotation[] annotations : parameterAnnotations) {
            if (this.isHidden(annotations)) continue;
            res.add(this.getFormatting(annotations));
        }
        return res;
    }

    private boolean isHidden(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Hidden)) continue;
            return true;
        }
        return false;
    }

    private StepFormatter.Formatting<?> getFormatting(Annotation[] annotations) {
        return this.getFormatting(annotations, Sets.newHashSet(), null);
    }

    private StepFormatter.Formatting<?> getFormatting(Annotation[] annotations, Set<Class<?>> visitedTypes, Annotation originalAnnotation) {
        for (Annotation annotation : annotations) {
            try {
                Annotation arg;
                if (annotation instanceof Format) {
                    arg = (Format)annotation;
                    return new StepFormatter.Formatting(arg.value().newInstance(), arg.args());
                }
                if (annotation instanceof Table) {
                    Table tableAnnotation = (Table)annotation;
                    return new StepFormatter.Formatting<Object>(new TableFormatter(tableAnnotation), new String[0]);
                }
                if (annotation instanceof AnnotationFormat) {
                    arg = (AnnotationFormat)annotation;
                    return new StepFormatter.Formatting(new StepFormatter.AnnotationBasedFormatter(arg.value().newInstance(), originalAnnotation), new String[0]);
                }
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (visitedTypes.contains(annotationType)) continue;
                visitedTypes.add(annotationType);
                StepFormatter.Formatting<?> formatting = this.getFormatting(annotationType.getAnnotations(), visitedTypes, annotation);
                if (formatting == null) continue;
                return formatting;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public void writeStep(StepModel stepModel) {
        this.getCurrentScenarioCase().addStep(stepModel);
    }

    private ScenarioCaseModel getCurrentScenarioCase() {
        if (this.scenarioCaseModel == null) {
            this.scenarioStarted("A Scenario");
        }
        return this.scenarioCaseModel;
    }

    @Override
    public void stepMethodInvoked(Method method, List<NamedArgument> arguments, InvocationMode mode) {
        if (method.isAnnotationPresent(IntroWord.class)) {
            this.introWordAdded(this.getDescription(method));
        } else {
            this.addStepMethod(method, arguments, mode);
        }
    }

    public void setMethodName(String methodName) {
        this.scenarioModel.setTestMethodName(methodName);
    }

    public void setArguments(List<String> arguments) {
        this.scenarioCaseModel.setExplicitArguments(arguments);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.scenarioModel.setExplicitParameters(parameterNames);
    }

    private String getDescription(Method paramMethod) {
        if (paramMethod.isAnnotationPresent(Hidden.class)) {
            return "";
        }
        Description description = paramMethod.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        As as = paramMethod.getAnnotation(As.class);
        if (as != null) {
            return as.value();
        }
        return ScenarioModelBuilder.nameWithoutUnderlines(paramMethod);
    }

    public void setSuccess(boolean success) {
        this.scenarioCaseModel.success = success;
    }

    public void setErrorMessage(String message) {
        this.scenarioCaseModel.errorMessage = message;
    }

    private static String nameWithoutUnderlines(Method paramMethod) {
        return paramMethod.getName().replace('_', ' ');
    }

    @Override
    public void stepMethodFailed(Throwable t) {
        if (!this.scenarioCaseModel.getSteps().isEmpty()) {
            this.scenarioCaseModel.getStep(this.scenarioCaseModel.getSteps().size() - 1).setStatus(StepStatus.FAILED);
        }
    }

    @Override
    public void stepMethodFinished(long durationInNanos) {
        if (!this.scenarioCaseModel.getSteps().isEmpty()) {
            this.scenarioCaseModel.getSteps().get(this.scenarioCaseModel.getSteps().size() - 1).setDurationInNanos(durationInNanos);
        }
    }

    @Override
    public void scenarioFailed(Throwable e) {
        this.setSuccess(false);
        this.setErrorMessage(e.getMessage());
    }

    @Override
    public void scenarioStarted(Method method, List<NamedArgument> namedArguments) {
        this.readConfiguration(method.getDeclaringClass());
        this.readAnnotations(method);
        this.setParameterNames(this.getNames(namedArguments));
        this.setMethodName(method.getName());
        List<StepFormatter.Formatting<?>> formatters = this.getFormatters(method.getParameterAnnotations());
        this.setArguments(this.toStringList(formatters, this.getValues(namedArguments)));
    }

    private List<Object> getValues(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.value);
        }
        return result;
    }

    private List<String> getNames(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.name);
        }
        return result;
    }

    private void readConfiguration(Class<?> testClass) {
        this.configuration = ConfigurationUtil.getConfiguration(testClass);
    }

    private List<String> toStringList(List<StepFormatter.Formatting<?>> formatters, List<?> arguments) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < arguments.size(); ++i) {
            StepFormatter.Formatting<?> formatting = DEFAULT_FORMATTING;
            if (i < formatters.size() && formatters.get(i) != null) {
                formatting = formatters.get(i);
            }
            result.add(this.formatUsingFormatterOrDefault(formatting, arguments.get(i)));
        }
        return result;
    }

    private <T> String formatUsingFormatterOrDefault(StepFormatter.Formatting<T> formatting, Object o) {
        return formatting.format(o);
    }

    private void readAnnotations(Method method) {
        String scenarioDescription = method.getName();
        if (method.isAnnotationPresent(Description.class)) {
            scenarioDescription = method.getAnnotation(Description.class).value();
        } else if (method.isAnnotationPresent(As.class)) {
            scenarioDescription = method.getAnnotation(As.class).value();
        }
        this.scenarioStarted(scenarioDescription);
        if (method.isAnnotationPresent(NotImplementedYet.class) || method.isAnnotationPresent(Pending.class)) {
            this.scenarioModel.setPending(true);
        }
        if (this.scenarioCaseModel.getCaseNr() == 1) {
            this.addTags(method.getDeclaringClass().getAnnotations());
            this.addTags(method.getAnnotations());
        }
    }

    public void addTags(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            List<Tag> tags = this.toTags(annotation);
            this.reportModel.addTags(tags);
            this.scenarioModel.addTags(tags);
        }
    }

    public List<Tag> toTags(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IsTag isTag = annotationType.getAnnotation(IsTag.class);
        TagConfiguration tagConfig = isTag != null ? this.fromIsTag(isTag, annotation) : this.configuration.getTagConfiguration(annotationType);
        if (tagConfig == null) {
            return Collections.emptyList();
        }
        Tag tag = new Tag(tagConfig.getAnnotationType());
        if (!Strings.isNullOrEmpty((String)tagConfig.getName())) {
            tag.setName(tagConfig.getName());
        }
        if (tagConfig.isPrependType()) {
            tag.setPrependType(true);
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getCssClass())) {
            tag.setCssClass(tagConfig.getCssClass());
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getColor())) {
            tag.setColor(tagConfig.getColor());
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getStyle())) {
            tag.setStyle(tagConfig.getStyle());
        }
        Object value = tagConfig.getDefaultValue();
        if (!Strings.isNullOrEmpty((String)tagConfig.getDefaultValue())) {
            tag.setValue(tagConfig.getDefaultValue());
        }
        if (tagConfig.isIgnoreValue()) {
            tag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, value));
            return Arrays.asList(tag);
        }
        tag.setTags(tagConfig.getTags());
        try {
            Method method = annotationType.getMethod("value", new Class[0]);
            value = method.invoke((Object)annotation, new Object[0]);
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] objectArray = (Object[])value;
                    if (tagConfig.isExplodeArray()) {
                        List<Tag> explodedTags = this.getExplodedTags(tag, objectArray, annotation, tagConfig);
                        return explodedTags;
                    }
                    tag.setValue(this.toStringList(objectArray));
                } else {
                    tag.setValue(String.valueOf(value));
                }
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            log.error("Error while getting 'value' method of annotation " + annotation, (Throwable)e);
        }
        tag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, value));
        return Arrays.asList(tag);
    }

    public TagConfiguration fromIsTag(IsTag isTag, Annotation annotation) {
        String name = Strings.isNullOrEmpty((String)isTag.name()) ? isTag.type() : isTag.name();
        return TagConfiguration.builder(annotation.annotationType()).defaultValue(isTag.value()).description(isTag.description()).explodeArray(isTag.explodeArray()).ignoreValue(isTag.ignoreValue()).prependType(isTag.prependType()).name(name).descriptionGenerator(isTag.descriptionGenerator()).cssClass(isTag.cssClass()).color(isTag.color()).style(isTag.style()).tags(this.getTagNames(isTag, annotation)).build();
    }

    private List<String> getTagNames(IsTag isTag, Annotation annotation) {
        List<Tag> tags = this.getTags(isTag, annotation);
        this.reportModel.addTags(tags);
        ArrayList tagNames = Lists.newArrayList();
        for (Tag tag : tags) {
            tagNames.add(tag.toIdString());
        }
        return tagNames;
    }

    private List<Tag> getTags(IsTag isTag, Annotation annotation) {
        ArrayList allTags = Lists.newArrayList();
        for (Annotation a : annotation.annotationType().getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(IsTag.class)) continue;
            List<Tag> tags = this.toTags(a);
            for (Tag tag : tags) {
                allTags.add(tag);
            }
        }
        return allTags;
    }

    private List<String> toStringList(Object[] value) {
        Object[] array = value;
        ArrayList values = Lists.newArrayList();
        for (Object v : array) {
            values.add(String.valueOf(v));
        }
        return values;
    }

    private String getDescriptionFromGenerator(TagConfiguration tagConfiguration, Annotation annotation, Object value) {
        try {
            return tagConfiguration.getDescriptionGenerator().newInstance().generateDescription(tagConfiguration, annotation, value);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Error while trying to generate the description for annotation " + annotation + " using DescriptionGenerator class " + tagConfiguration.getDescriptionGenerator() + ": " + e.getMessage(), e);
        }
    }

    private List<Tag> getExplodedTags(Tag originalTag, Object[] values, Annotation annotation, TagConfiguration tagConfig) {
        ArrayList result = Lists.newArrayList();
        for (Object singleValue : values) {
            Tag newTag = originalTag.copy();
            newTag.setValue(String.valueOf(singleValue));
            newTag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, singleValue));
            result.add(newTag);
        }
        return result;
    }

    @Override
    public void scenarioFinished() {
        AssertionUtil.assertTrue(this.scenarioStartedNanos > 0L, "Scenario has no start time");
        long durationInNanos = System.nanoTime() - this.scenarioStartedNanos;
        this.scenarioCaseModel.setDurationInNanos(durationInNanos);
        this.scenarioModel.addDurationInNanos(durationInNanos);
        this.reportModel.addScenarioModelOrMergeWithExistingOne(this.scenarioModel);
    }

    @Override
    public void attachmentAdded(Attachment attachment) {
        this.currentStep.setAttachment(attachment);
    }

    @Override
    public void extendedDescriptionUpdated(String extendedDescription) {
        this.currentStep.setExtendedDescription(extendedDescription);
    }

    public ReportModel getReportModel() {
        return this.reportModel;
    }

    public ScenarioModel getScenarioModel() {
        return this.scenarioModel;
    }

    public ScenarioCaseModel getScenarioCaseModel() {
        return this.scenarioCaseModel;
    }
}

