/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.AnnotationArgumentFormatter;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.TableFormatter;
import com.tngtech.jgiven.impl.util.ApiUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StepFormatter {
    public static final String DEFAULT_NUMBERED_HEADER = "#";
    private final String stepDescription;
    private final List<NamedArgument> arguments;
    private final List<Formatting<?>> formatters;

    public StepFormatter(String stepDescription, List<NamedArgument> arguments, List<Formatting<?>> formatters) {
        this.stepDescription = stepDescription;
        this.arguments = arguments;
        this.formatters = formatters;
    }

    public List<Word> buildFormattedWords() {
        int i;
        ArrayList formattedWords = Lists.newArrayList();
        int argCount = 0;
        List words = Splitter.on((char)' ').splitToList((CharSequence)this.stepDescription);
        for (i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            if (word.equals("$$")) {
                formattedWords.add(new Word("$"));
                continue;
            }
            if (word.startsWith("$")) {
                int argEnd = this.findArgumentEnd(i, words);
                this.formatArgument(formattedWords, argCount, word);
                if (argEnd != -1) {
                    i = argEnd;
                }
                ++argCount;
                continue;
            }
            if (!formattedWords.isEmpty()) {
                Word previousWord = (Word)formattedWords.get(formattedWords.size() - 1);
                if (!previousWord.isArg()) {
                    previousWord.append(word);
                    continue;
                }
                formattedWords.add(new Word(word));
                continue;
            }
            formattedWords.add(new Word(word));
        }
        for (i = argCount; i < this.arguments.size(); ++i) {
            Object value = this.arguments.get((int)i).value;
            String formattedValue = this.formatUsingFormatterOrNull(this.formatters.get(i), value);
            if (formattedValue == null && this.formatters.get(i) != null && ((Formatting)this.formatters.get(i)).formatter instanceof TableFormatter) {
                Table tableAnnotation = ((TableFormatter)((Formatting)this.formatters.get((int)i)).formatter).tableAnnotation;
                formattedWords.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), StepFormatter.toTableValue(value, tableAnnotation)));
                continue;
            }
            formattedWords.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), formattedValue));
        }
        return formattedWords;
    }

    public static DataTable toTableValue(Object tableValue, Table tableAnnotation) {
        DataTable dataTable = StepFormatter.toDataTable(tableValue, tableAnnotation);
        StepFormatter.addNumberedRows(tableAnnotation, dataTable);
        StepFormatter.addNumberedColumns(tableAnnotation, dataTable);
        return dataTable;
    }

    private static void addNumberedRows(Table tableAnnotation, DataTable dataTable) {
        boolean hasCustomerHeader;
        String customHeader = tableAnnotation.numberedRowsHeader();
        boolean bl = hasCustomerHeader = !customHeader.equals("MARKER FOR ABSENT VALUES IN ANNOTATIONS - JGIVEN INTERNAL DO NOT USE!");
        if (tableAnnotation.numberedRows() || hasCustomerHeader) {
            ApiUtil.isTrue(!hasCustomerHeader || dataTable.hasHorizontalHeader(), "Using numberedRowsHeader in @Table without having a horizontal header.");
            int rowCount = dataTable.getRowCount();
            ArrayList column = Lists.newArrayListWithExpectedSize((int)rowCount);
            StepFormatter.addHeader(customHeader, column, dataTable.hasHorizontalHeader());
            StepFormatter.addNumbers(rowCount, column);
            dataTable.addColumn(0, column);
        }
    }

    private static void addNumberedColumns(Table tableAnnotation, DataTable dataTable) {
        boolean hasCustomerHeader;
        String customHeader = tableAnnotation.numberedColumnsHeader();
        boolean bl = hasCustomerHeader = !customHeader.equals("MARKER FOR ABSENT VALUES IN ANNOTATIONS - JGIVEN INTERNAL DO NOT USE!");
        if (tableAnnotation.numberedColumns() || hasCustomerHeader) {
            ApiUtil.isTrue(!hasCustomerHeader || dataTable.hasVerticalHeader(), "Using numberedColumnsHeader in @Table without having a vertical header.");
            int columnCount = dataTable.getColumnCount();
            ArrayList row = Lists.newArrayListWithExpectedSize((int)columnCount);
            StepFormatter.addHeader(customHeader, row, dataTable.hasVerticalHeader());
            StepFormatter.addNumbers(columnCount, row);
            dataTable.addRow(0, row);
        }
    }

    private static void addHeader(String customHeader, List<String> column, boolean hasHeader) {
        boolean hasCustomerHeader;
        boolean bl = hasCustomerHeader = !customHeader.equals("MARKER FOR ABSENT VALUES IN ANNOTATIONS - JGIVEN INTERNAL DO NOT USE!");
        if (hasHeader) {
            String header = DEFAULT_NUMBERED_HEADER;
            if (hasCustomerHeader) {
                header = customHeader;
            }
            column.add(header);
        }
    }

    private static void addNumbers(int count, List<String> column) {
        int counter = 1;
        while (column.size() < count) {
            column.add(Integer.toString(counter));
            ++counter;
        }
    }

    public static DataTable toDataTable(Object tableValue, Table tableAnnotation) {
        ArrayList result = Lists.newArrayList();
        ImmutableList rows = StepFormatter.toIterable(tableValue);
        if (rows == null) {
            rows = ImmutableList.of((Object)tableValue);
        }
        boolean first = true;
        int ncols = 0;
        for (Object row : rows) {
            if (first && StepFormatter.toIterable(row) == null) {
                return StepFormatter.pojosToTableValue(rows, tableAnnotation);
            }
            List<String> values = StepFormatter.toStringList(row);
            if (!first && ncols != values.size()) {
                throw new JGivenWrongUsageException("Number of columns in @Table annotated parameter is not equal for all rows. Expected " + ncols + " got " + values.size());
            }
            ncols = values.size();
            result.add(values);
            first = false;
        }
        if (tableAnnotation.columnTitles().length > 0) {
            result.add(0, Arrays.asList(tableAnnotation.columnTitles()));
        }
        result = tableAnnotation.transpose() ? StepFormatter.transpose(result) : result;
        return new DataTable(tableAnnotation.header(), result);
    }

    static DataTable pojosToTableValue(Iterable<?> objects, Table tableAnnotation) {
        List<Object> list = Lists.newArrayList();
        Object first = objects.iterator().next();
        Iterable<Field> fields = StepFormatter.getFields(tableAnnotation, first);
        if (tableAnnotation.columnTitles().length > 0) {
            list.add(Arrays.asList(tableAnnotation.columnTitles()));
        } else {
            list.add(StepFormatter.getFieldNames(fields));
        }
        boolean[] nonNullColumns = new boolean[((List)list.get(0)).size()];
        for (Object o : objects) {
            List<Object> allFieldValues = ReflectionUtil.getAllFieldValues(o, fields, "");
            for (int i = 0; i < allFieldValues.size(); ++i) {
                if (allFieldValues.get(i) == null) continue;
                nonNullColumns[i] = true;
            }
            list.add(StepFormatter.toStringList(allFieldValues));
        }
        if (!tableAnnotation.includeNullColumns()) {
            list = StepFormatter.removeNullColumns((List<List<String>>)list, nonNullColumns);
        }
        list = tableAnnotation.transpose() || tableAnnotation.header().isVertical() ? StepFormatter.transpose((List<List<String>>)list) : list;
        return new DataTable(tableAnnotation.header(), (List<List<String>>)list);
    }

    private static List<List<String>> removeNullColumns(List<List<String>> list, boolean[] nonNullColumns) {
        ArrayList newList = Lists.newArrayListWithCapacity((int)list.size());
        for (List<String> row : list) {
            ArrayList newRow = Lists.newArrayList();
            newList.add(newRow);
            for (int i = 0; i < nonNullColumns.length; ++i) {
                if (!nonNullColumns[i]) continue;
                newRow.add(row.get(i));
            }
        }
        return newList;
    }

    private static Iterable<Field> getFields(Table tableAnnotation, Object first) {
        final HashSet includeFields = Sets.newHashSet((Object[])tableAnnotation.includeFields());
        final HashSet excludeFields = Sets.newHashSet((Object[])tableAnnotation.excludeFields());
        return FluentIterable.from(ReflectionUtil.getAllNonStaticFields(first.getClass())).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                String name = input.getName();
                if (!includeFields.isEmpty()) {
                    return includeFields.contains(name);
                }
                return !excludeFields.contains(name);
            }
        });
    }

    static List<List<String>> transpose(List<List<String>> list) {
        ArrayList transposed = Lists.newArrayList();
        for (int rowIdx = 0; rowIdx < list.size(); ++rowIdx) {
            List<String> row = list.get(rowIdx);
            for (int colIdx = 0; colIdx < row.size(); ++colIdx) {
                if (rowIdx == 0) {
                    transposed.add(Lists.newArrayList());
                }
                ((List)transposed.get(colIdx)).add(row.get(colIdx));
            }
        }
        return transposed;
    }

    private static List<String> getFieldNames(Iterable<Field> fields) {
        return FluentIterable.from(ReflectionUtil.getAllFieldNames(fields)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.replace('_', ' ');
            }
        }).toList();
    }

    private static List<String> toStringList(Object row) {
        ArrayList list = Lists.newArrayList();
        Iterable<?> objects = StepFormatter.toIterable(row);
        if (objects == null) {
            throw new JGivenWrongUsageException("@Table annotated argument cannot be converted to a data table.");
        }
        for (Object o : objects) {
            list.add(StepFormatter.toDefaultStringFormat(o));
        }
        return list;
    }

    private static Iterable<?> toIterable(Object value) {
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            return Arrays.asList(array);
        }
        return null;
    }

    private int findArgumentEnd(int i, List<String> words) {
        for (int j = i; j < words.size(); ++j) {
            String word = words.get(j);
            if (!word.endsWith("$") || word.length() <= 1) continue;
            return j;
        }
        return -1;
    }

    private void formatArgument(List<Word> formattedWords, int argCount, String word) {
        Pattern pattern = Pattern.compile("\\$(\\d+)");
        Matcher matcher = pattern.matcher(word);
        int index = argCount;
        if (matcher.matches()) {
            int argIndex = Integer.parseInt(matcher.group(1));
            index = argIndex - 1;
        }
        Object value = this.arguments.get((int)index).value;
        String defaultFormattedValue = StepFormatter.toDefaultStringFormat(value);
        Formatting<?> formatter = this.formatters.get(index);
        if (formatter != null && ((Formatting)formatter).formatter instanceof TableFormatter) {
            throw new JGivenWrongUsageException("Parameters annotated with @Table must be the last ones. They cannot be used for $ substitution");
        }
        String formattedValue = this.formatUsingFormatterOrNull(formatter, value);
        String argumentName = this.arguments.get((int)index).name;
        if (defaultFormattedValue != null && !defaultFormattedValue.isEmpty()) {
            formattedWords.add(Word.argWord(argumentName, defaultFormattedValue, formattedValue));
        }
    }

    private <T> String formatUsingFormatterOrNull(Formatting<T> argumentFormatter, Object value) {
        if (argumentFormatter == null) {
            return null;
        }
        return argumentFormatter.format(value);
    }

    private static String toDefaultStringFormat(Object value) {
        return new DefaultFormatter<Object>().format(value, new String[0]);
    }

    public static class AnnotationBasedFormatter
    implements ArgumentFormatter {
        private final AnnotationArgumentFormatter formatter;
        private final Annotation annotation;

        public AnnotationBasedFormatter(AnnotationArgumentFormatter formatter, Annotation annotation) {
            this.formatter = formatter;
            this.annotation = annotation;
        }

        public String format(Object argumentToFormat, String ... formatterArguments) {
            return this.formatter.format(argumentToFormat, this.annotation);
        }
    }

    public static class Formatting<T> {
        private final ArgumentFormatter<T> formatter;
        private final String[] args;

        public Formatting(ArgumentFormatter<T> formatter, String ... args) {
            this.formatter = formatter;
            this.args = args;
        }

        public String format(T o) {
            return this.formatter.format(o, this.args);
        }
    }
}

