/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Tag {
    private final String type;
    private String name;
    private Object value;
    private String description;
    private Boolean prependType;
    private String color;
    private String cssClass;
    private String style;
    private List<String> tags;

    public Tag(String type) {
        this.type = type;
    }

    public Tag(String type, Object value) {
        this(type);
        this.value = value;
    }

    public Tag(String type, String name, Object value) {
        this(type, value);
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return this.type;
        }
        return this.name;
    }

    public boolean isPrependType() {
        return this.prependType != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getCssClassOrDefault() {
        return this.cssClass == null ? "tag-" + this.getName() : this.cssClass;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public List<String> getValues() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.value instanceof String) {
            return Lists.newArrayList((Object[])new String[]{(String)this.value});
        }
        return (List)this.value;
    }

    public void setValue(List<String> values) {
        this.value = values;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Tag setPrependType(boolean prependType) {
        this.prependType = prependType ? Boolean.valueOf(true) : null;
        return this;
    }

    public String toString() {
        if (this.value != null) {
            String valueString = this.getValueString();
            if (this.isPrependType()) {
                return this.getName() + "-" + valueString;
            }
            return valueString;
        }
        return this.getName();
    }

    public String getValueString() {
        if (this.value == null) {
            return null;
        }
        return Joiner.on((String)", ").join(this.getValues());
    }

    public String toIdString() {
        if (this.value != null) {
            return this.type + "-" + this.getValueString();
        }
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getType(), this.getName(), this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equal((Object)this.getType(), (Object)other.getType()) && Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public String toEscapedString() {
        ArrayList parts = Lists.newArrayList((Object[])new String[]{this.getName()});
        parts.addAll(this.getValues());
        String escapedString = Tag.escape(Joiner.on((char)'-').join((Iterable)parts));
        return escapedString.substring(0, Math.min(escapedString.length(), 255));
    }

    static String escape(String string) {
        return string.replaceAll("[^\\p{Alnum}-]", "_");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags;
    }

    public void setTags(List<String> tags) {
        if (tags != null && !tags.isEmpty()) {
            this.tags = tags;
        }
    }

    public Tag copy() {
        Tag tag = new Tag(this.type, this.name, this.value);
        tag.cssClass = this.cssClass;
        tag.color = this.color;
        tag.style = this.style;
        tag.description = this.description;
        tag.prependType = this.prependType;
        tag.tags = this.tags;
        return tag;
    }
}

