/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.report.model.AttachmentModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Word;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StepModel {
    private String name;
    private List<Word> words = Lists.newArrayList();
    private List<StepModel> nestedSteps;
    private StepStatus status = StepStatus.PASSED;
    private long durationInNanos;
    private String extendedDescription;
    private List<AttachmentModel> attachments;
    private Boolean isSectionTitle;
    private String comment;

    public StepModel() {
    }

    public StepModel(String name, List<Word> words) {
        this.setName(name);
        this.setWords(Lists.newArrayList(words));
    }

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
    }

    public String getCompleteSentence() {
        return Joiner.on((char)' ').join(this.words);
    }

    public StepModel addWords(Word ... words) {
        this.words.addAll(Arrays.asList(words));
        return this;
    }

    public boolean isPending() {
        return this.getStatus() == StepStatus.PENDING;
    }

    public boolean isFailed() {
        return this.getStatus() == StepStatus.FAILED;
    }

    public boolean isSkipped() {
        return this.getStatus() == StepStatus.SKIPPED;
    }

    public StepStatus getStatus() {
        return this.status;
    }

    public void setStatus(StepStatus status) {
        this.status = status;
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public void setDurationInNanos(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }

    public Word getWord(int i) {
        return this.words.get(i);
    }

    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public boolean hasExtendedDescription() {
        return this.extendedDescription != null || Iterables.size(this.nestedSteps) > 0;
    }

    public void setExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Word> getWords() {
        return Collections.unmodifiableList(this.words);
    }

    public Word getLastWord() {
        return this.words.get(this.words.size() - 1);
    }

    public void addAttachment(Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = Lists.newArrayList();
        }
        AttachmentModel attachmentModel = new AttachmentModel();
        attachmentModel.setTitle(attachment.getTitle());
        attachmentModel.setValue(attachment.getContent());
        attachmentModel.setFileName(attachment.getFileName());
        attachmentModel.setMediaType(attachment.getMediaType().asString());
        attachmentModel.setIsBinary(attachment.getMediaType().isBinary());
        attachmentModel.setShowDirectly(attachment.getShowDirectly());
        this.attachments.add(attachmentModel);
    }

    public List<AttachmentModel> getAttachments() {
        if (this.attachments != null) {
            return this.attachments;
        }
        return Collections.emptyList();
    }

    public void addNestedStep(StepModel stepModel) {
        if (this.nestedSteps == null) {
            this.nestedSteps = Lists.newArrayList();
        }
        this.nestedSteps.add(stepModel);
    }

    public List<StepModel> getNestedSteps() {
        if (this.nestedSteps != null) {
            return this.nestedSteps;
        }
        return Collections.emptyList();
    }

    public void setNestedSteps(List<StepModel> nestedSteps) {
        this.nestedSteps = nestedSteps;
    }

    public Boolean isSectionTitle() {
        return this.isSectionTitle == null ? false : this.isSectionTitle;
    }

    public void setIsSectionTitle(boolean isSectionTitle) {
        this.isSectionTitle = isSectionTitle ? Boolean.valueOf(true) : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWords(List<Word> words) {
        this.words = Lists.newArrayList(words);
    }

    public void addIntroWord(Word introWord) {
        this.words.add(0, introWord);
    }

    public boolean hasInlineAttachment() {
        if (this.attachments == null) {
            return false;
        }
        for (AttachmentModel model : this.attachments) {
            if (!model.isShowDirectly()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttachment() {
        return !this.getAttachments().isEmpty();
    }
}

