/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.tngtech.jgiven.annotation.AfterScenario;
import com.tngtech.jgiven.annotation.AfterStage;
import com.tngtech.jgiven.annotation.BeforeScenario;
import com.tngtech.jgiven.annotation.BeforeStage;
import com.tngtech.jgiven.exception.JGivenUserException;
import com.tngtech.jgiven.impl.intercept.StepInterceptorImpl;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StageLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(StageLifecycleManager.class);
    private final Object instance;
    private final StepInterceptorImpl methodInterceptor;
    private final LifecycyleMethodManager<AfterStage> afterStageRegister;
    private final LifecycyleMethodManager<BeforeStage> beforeStageRegister;
    private final LifecycyleMethodManager<BeforeScenario> beforeScenarioRegister;
    private final LifecycyleMethodManager<AfterScenario> afterScenarioRegister;

    StageLifecycleManager(Object instance, StepInterceptorImpl methodInterceptor) {
        this.methodInterceptor = methodInterceptor;
        this.instance = instance;
        this.afterStageRegister = new LifecycyleMethodManager(AfterStage.class, AfterStage::repeatable);
        this.beforeStageRegister = new LifecycyleMethodManager(BeforeStage.class, BeforeStage::repeatable);
        this.beforeScenarioRegister = new LifecycyleMethodManager(BeforeScenario.class, it -> false);
        this.afterScenarioRegister = new LifecycyleMethodManager(AfterScenario.class, it -> false);
    }

    boolean allAfterStageMethodsHaveBeenExecuted() {
        return this.afterStageRegister.allMethodsHaveBeenExecuted();
    }

    void executeAfterStageMethods(boolean fakeExecution) throws Throwable {
        this.executeLifecycleMethods(this.afterStageRegister, fakeExecution);
    }

    void executeBeforeStageMethods(boolean fakeExecution) throws Throwable {
        this.executeLifecycleMethods(this.beforeStageRegister, fakeExecution);
    }

    void executeAfterScenarioMethods(boolean fakeExecution) throws Throwable {
        this.executeLifecycleMethods(this.afterScenarioRegister, fakeExecution);
    }

    void executeBeforeScenarioMethods(boolean fakeExecution) throws Throwable {
        this.executeLifecycleMethods(this.beforeScenarioRegister, fakeExecution);
    }

    private void executeLifecycleMethods(LifecycyleMethodManager<?> register, boolean fakeExecution) throws Throwable {
        if (fakeExecution) {
            register.fakeExecution();
        } else {
            register.executeMethods();
        }
    }

    private class LifecycyleMethodManager<T extends Annotation> {
        private final Class<T> targetAnnotation;
        private final Map<Method, StepExecutionState> register = new HashMap<Method, StepExecutionState>();
        private final Predicate<T> predicateFromT;

        private LifecycyleMethodManager(Class<T> targetAnnotation, Predicate<T> predicateFromAnnotation) {
            this.targetAnnotation = targetAnnotation;
            this.predicateFromT = predicateFromAnnotation;
            this.fillStageRegister(StageLifecycleManager.this.instance);
        }

        private void fillStageRegister(Object instance) {
            ReflectionUtil.forEachMethod(instance, instance.getClass(), this.targetAnnotation, (object, method) -> Arrays.stream(method.getDeclaredAnnotations()).filter(annotation -> this.targetAnnotation.isAssignableFrom(annotation.getClass())).map(annotation -> annotation).findFirst().map(it -> this.predicateFromT.test((Annotation)it) ? StepExecutionState.REPEATABLE : StepExecutionState.NOT_EXECUTED).ifPresent(it -> this.register.put(method, (StepExecutionState)((Object)((Object)it)))));
            log.debug("Added methods '{}' as '{}' methods to the register", this.register.keySet(), (Object)this.targetAnnotation.getSimpleName());
        }

        boolean methodMarkedForExecution(Method method) {
            return Optional.ofNullable(this.register.get(method)).map(StepExecutionState::toBoolean).orElse(true) == false;
        }

        boolean allMethodsHaveBeenExecuted() {
            return this.register.values().stream().allMatch(StepExecutionState::toBoolean);
        }

        void fakeExecution() throws Throwable {
            this.prepareMethods();
            this.doExecutionOn(Stream.of(new Method[0]));
        }

        void executeMethods() throws Throwable {
            Stream<Method> methodsToExecute = this.prepareMethods();
            this.doExecutionOn(methodsToExecute);
        }

        private Stream<Method> prepareMethods() {
            return this.register.keySet().stream().filter(this::methodMarkedForExecution).peek(this::markStageAsExecuted);
        }

        private void markStageAsExecuted(Method method) {
            StepExecutionState stepState = this.register.get(method);
            if (stepState == StepExecutionState.NOT_EXECUTED) {
                this.register.put(method, StepExecutionState.EXECUTED);
            }
        }

        private void doExecutionOn(Stream<Method> methodsToExecute) throws Throwable {
            log.debug("Executing methods annotated with @{}", (Object)this.targetAnnotation.getName());
            boolean previousMethodExecution = StageLifecycleManager.this.methodInterceptor.enableMethodExecution(true);
            try {
                StageLifecycleManager.this.methodInterceptor.enableMethodInterception(false);
                methodsToExecute.forEach(method -> ReflectionUtil.invokeMethod(StageLifecycleManager.this.instance, method, " with annotation @" + this.targetAnnotation.getName()));
                StageLifecycleManager.this.methodInterceptor.enableMethodInterception(true);
            }
            catch (JGivenUserException e) {
                throw e.getCause();
            }
            finally {
                StageLifecycleManager.this.methodInterceptor.enableMethodExecution(previousMethodExecution);
            }
        }
    }

    private static enum StepExecutionState {
        EXECUTED(true),
        REPEATABLE(false),
        NOT_EXECUTED(false);

        private final boolean hasBeenExecuted;

        private StepExecutionState(boolean hasBeenExecuted) {
            this.hasBeenExecuted = hasBeenExecuted;
        }

        public boolean toBoolean() {
            return this.hasBeenExecuted;
        }
    }
}

