/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.intercept;

import com.tngtech.jgiven.annotation.DoNotIntercept;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.NestedSteps;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.impl.ScenarioExecutor;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StageTransitionHandler;
import com.tngtech.jgiven.impl.intercept.StepInterceptor;
import com.tngtech.jgiven.impl.util.ParameterNameUtil;
import com.tngtech.jgiven.impl.util.ThrowableUtil;
import com.tngtech.jgiven.report.model.InvocationMode;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptorImpl
implements StepInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StepInterceptorImpl.class);
    private static final int INITIAL_MAX_STEP_DEPTH = 1;
    private ScenarioExecutor scenarioExecutor;
    private StageTransitionHandler stageTransitionHandler;
    private ScenarioListener listener;
    protected final Stack<Object> stageStack = new Stack();
    private int maxStepDepth = 1;
    private InvocationMode defaultInvocationMode = InvocationMode.NORMAL;
    private boolean interceptingEnabled;
    private boolean methodExecutionEnabled = true;
    private boolean suppressExceptions = true;

    public StepInterceptorImpl(ScenarioExecutor scenarioExecutor, ScenarioListener listener, StageTransitionHandler stageTransitionHandler) {
        this.scenarioExecutor = scenarioExecutor;
        this.listener = listener;
        this.stageTransitionHandler = stageTransitionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object intercept(Object receiver, Method method, Object[] parameters, StepInterceptor.Invoker invoker) throws Throwable {
        if (!this.shouldInterceptMethod(method)) {
            return invoker.proceed();
        }
        int currentStackDepth = this.stageStack.size();
        Object parentStage = null;
        if (!this.stageStack.isEmpty()) {
            parentStage = this.stageStack.peek();
        }
        this.stageStack.push(receiver);
        try {
            this.stageTransitionHandler.enterStage(parentStage, receiver);
            Object object = this.doIntercept(receiver, method, parameters, invoker, currentStackDepth);
            return object;
        }
        finally {
            this.stageStack.pop();
            this.stageTransitionHandler.leaveStage(parentStage, receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doIntercept(Object receiver, Method method, Object[] parameters, StepInterceptor.Invoker invoker, int currentStackDepth) throws Throwable {
        long started = System.nanoTime();
        InvocationMode mode = this.getInvocationMode(receiver, method);
        boolean hasNestedSteps = method.isAnnotationPresent(NestedSteps.class);
        boolean handleMethod = this.shouldHandleMethod(method);
        if (handleMethod) {
            this.handleMethod(receiver, method, parameters, mode, hasNestedSteps);
        }
        if (mode == InvocationMode.SKIPPED || mode == InvocationMode.PENDING) {
            return this.returnReceiverOrNull(receiver, method);
        }
        if (hasNestedSteps) {
            ++this.maxStepDepth;
        }
        try {
            Object object = invoker.proceed();
            return object;
        }
        catch (Exception e) {
            Object object = this.handleThrowable(receiver, method, e, System.nanoTime() - started, handleMethod);
            return object;
        }
        catch (AssertionError e) {
            Object object = this.handleThrowable(receiver, method, (Throwable)((Object)e), System.nanoTime() - started, handleMethod);
            return object;
        }
        finally {
            if (hasNestedSteps) {
                --this.maxStepDepth;
            }
            if (handleMethod) {
                this.handleMethodFinished(System.nanoTime() - started, hasNestedSteps);
            }
        }
    }

    private boolean shouldHandleMethod(Method method) {
        if (method.isSynthetic() && !method.isBridge()) {
            return false;
        }
        if (method.isAnnotationPresent(Hidden.class)) {
            return false;
        }
        return this.stageStack.size() <= this.maxStepDepth;
    }

    private boolean shouldInterceptMethod(Method method) {
        return this.interceptingEnabled && method.getDeclaringClass() != Object.class && !method.isAnnotationPresent(DoNotIntercept.class);
    }

    protected Object handleThrowable(Object receiver, Method method, Throwable t, long durationInNanos, boolean handleMethod) throws Throwable {
        if (handleMethod) {
            this.handleThrowable(t);
            return this.returnReceiverOrNull(receiver, method);
        }
        throw t;
    }

    protected Object returnReceiverOrNull(Object receiver, Method method) {
        if (!method.getReturnType().isAssignableFrom(receiver.getClass())) {
            if (method.getReturnType() != Void.class) {
                log.warn("The step method " + method.getName() + " of class " + method.getDeclaringClass().getSimpleName() + " does not follow the fluent interface convention of returning the receiver object. Please change the return type to the SELF type parameter.");
            }
            return null;
        }
        return receiver;
    }

    protected InvocationMode getInvocationMode(Object receiver, Method method) {
        if (!this.methodExecutionEnabled) {
            return InvocationMode.SKIPPED;
        }
        if (method.isAnnotationPresent(Pending.class) || method.getDeclaringClass().isAnnotationPresent(Pending.class) || receiver.getClass().isAnnotationPresent(Pending.class)) {
            return InvocationMode.PENDING;
        }
        return this.defaultInvocationMode;
    }

    public void enableMethodInterception(boolean b) {
        this.interceptingEnabled = b;
    }

    public void disableMethodExecution() {
        this.methodExecutionEnabled = false;
    }

    public boolean enableMethodExecution(boolean b) {
        boolean previousMethodExecution = this.methodExecutionEnabled;
        this.methodExecutionEnabled = b;
        return previousMethodExecution;
    }

    public void setSuppressExceptions(boolean b) {
        this.suppressExceptions = b;
    }

    public void setDefaultInvocationMode(InvocationMode defaultInvocationMode) {
        this.defaultInvocationMode = defaultInvocationMode;
    }

    private void handleMethod(Object stageInstance, Method paramMethod, Object[] arguments, InvocationMode mode, boolean hasNestedSteps) throws Throwable {
        List<NamedArgument> namedArguments = ParameterNameUtil.mapArgumentsWithParameterNames(paramMethod, Arrays.asList(arguments));
        this.listener.stepMethodInvoked(paramMethod, namedArguments, mode, hasNestedSteps);
    }

    private void handleThrowable(Throwable t) throws Throwable {
        if (ThrowableUtil.isAssumptionException(t)) {
            throw t;
        }
        this.listener.stepMethodFailed(t);
        this.scenarioExecutor.failed(t);
        if (!this.suppressExceptions) {
            throw t;
        }
    }

    private void handleMethodFinished(long durationInNanos, boolean hasNestedSteps) {
        this.listener.stepMethodFinished(durationInNanos, hasNestedSteps);
    }

    public void setScenarioListener(ScenarioListener scenarioListener) {
        this.listener = scenarioListener;
    }
}

