/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.AnnotationArgumentFormatter;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.Formatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.format.table.TableFormatter;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StepFormatter {
    private final String stepDescription;
    private final List<NamedArgument> arguments;
    private final List<ObjectFormatter<?>> formatters;

    public StepFormatter(String stepDescription, List<NamedArgument> arguments, List<ObjectFormatter<?>> formatters) {
        this.stepDescription = stepDescription;
        this.arguments = arguments;
        this.formatters = formatters;
    }

    public List<Word> buildFormattedWords() {
        try {
            return this.buildFormattedWordsInternal();
        }
        catch (JGivenWrongUsageException e) {
            throw new JGivenWrongUsageException(e.getMessage() + ". Step definition: " + this.stepDescription);
        }
    }

    private List<Word> buildFormattedWordsInternal() {
        ArrayList formattedWords = Lists.newArrayList();
        HashSet usedArguments = Sets.newHashSet();
        int singlePlaceholderCounter = 0;
        boolean dropNextWhitespace = false;
        StringBuilder currentWords = new StringBuilder();
        for (int i = 0; i < this.stepDescription.length(); ++i) {
            boolean singleDollarCountIndexExists;
            boolean dollarMatch = this.stepDescription.charAt(i) == '$';
            boolean nextCharExists = i + 1 < this.stepDescription.length();
            boolean escapedDollarMatch = nextCharExists && this.stepDescription.charAt(i + 1) == '$';
            String argumentName = nextCharExists ? StepFormatter.nextName(this.stepDescription.substring(i + 1)) : "";
            boolean namedArgumentExists = argumentName.length() > 0;
            boolean namedArgumentMatch = namedArgumentExists && this.isArgument(argumentName);
            boolean enumArgumentMatch = nextCharExists && this.arguments.size() > StepFormatter.nextIndex(this.stepDescription.substring(i + 1), this.arguments.size());
            boolean bl = singleDollarCountIndexExists = singlePlaceholderCounter < this.arguments.size();
            if (dollarMatch) {
                int argumentIndex;
                if (escapedDollarMatch) {
                    formattedWords.add(new Word("$"));
                    ++i;
                } else if (namedArgumentMatch) {
                    argumentIndex = this.getArgumentIndexByName(argumentName, 0);
                    this.addArgumentByIndex(argumentIndex, currentWords, formattedWords, usedArguments);
                    i += argumentName.length();
                } else if (enumArgumentMatch) {
                    argumentIndex = StepFormatter.nextIndex(this.stepDescription.substring(i + 1), this.arguments.size());
                    this.addArgumentByIndex(argumentIndex, currentWords, formattedWords, usedArguments);
                    i += Integer.toString(argumentIndex).length();
                } else if (singleDollarCountIndexExists && namedArgumentExists) {
                    argumentIndex = singlePlaceholderCounter++;
                    this.addArgumentByIndex(argumentIndex, currentWords, formattedWords, usedArguments);
                    i += argumentName.length();
                } else if (singleDollarCountIndexExists) {
                    argumentIndex = singlePlaceholderCounter++;
                    this.addArgumentByIndex(argumentIndex, currentWords, formattedWords, usedArguments);
                } else {
                    formattedWords.add(new Word('$' + argumentName));
                    i += argumentName.length();
                }
                dropNextWhitespace = true;
                continue;
            }
            if (dropNextWhitespace && this.stepDescription.charAt(i) == ' ') {
                dropNextWhitespace = false;
                continue;
            }
            currentWords.append(this.stepDescription.charAt(i));
        }
        StepFormatter.flushCurrentWord(currentWords, formattedWords, false);
        formattedWords.addAll(this.getRemainingArguments(usedArguments));
        return formattedWords;
    }

    private static String nextName(String description) {
        char c;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < description.length() && Character.isJavaIdentifierPart(c = description.charAt(i)) && c != '$'; ++i) {
            result.append(c);
        }
        return result.toString();
    }

    private int getArgumentIndexByName(String argumentName, int defaultIndex) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!this.arguments.get((int)i).name.equals(argumentName)) continue;
            return i;
        }
        return defaultIndex;
    }

    private boolean isArgument(String argumentName) {
        for (NamedArgument arg : this.arguments) {
            if (!arg.name.equals(argumentName)) continue;
            return true;
        }
        return false;
    }

    private void addArgumentByIndex(int index, StringBuilder currentWords, List<Word> formattedWords, Set<String> usedArguments) {
        StepFormatter.flushCurrentWord(currentWords, formattedWords, true);
        Word argument = this.argumentIndexToWord(index);
        formattedWords.add(argument);
        usedArguments.add(argument.getArgumentInfo().getArgumentName());
    }

    private Word argumentIndexToWord(int index) {
        Object value = this.arguments.get((int)index).value;
        String defaultFormattedValue = StepFormatter.toDefaultStringFormat(value);
        ObjectFormatter<?> formatter = this.formatters.get(index);
        String formattedValue = this.formatUsingFormatterOrNull(formatter, value);
        String argumentName = WordUtil.fromSnakeCase(this.arguments.get((int)index).name);
        return Word.argWord(argumentName, defaultFormattedValue, formattedValue);
    }

    private static void flushCurrentWord(StringBuilder currentWords, List<Word> formattedWords, boolean cutWhitespace) {
        if (currentWords.length() > 0) {
            if (cutWhitespace && currentWords.charAt(currentWords.length() - 1) == ' ') {
                currentWords.setLength(currentWords.length() - 1);
            }
            formattedWords.add(new Word(currentWords.toString()));
            currentWords.setLength(0);
        }
    }

    private static int nextIndex(String description, int defaultIndex) {
        Pattern startsWithNumber = Pattern.compile("(\\d+).*");
        Matcher matcher = startsWithNumber.matcher(description);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1)) - 1;
        }
        return defaultIndex;
    }

    private List<Word> getRemainingArguments(Set<String> usedArguments) {
        ArrayList remainingArguments = Lists.newArrayList();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Object value = this.arguments.get((int)i).value;
            String formattedValue = this.formatUsingFormatterOrNull(this.formatters.get(i), value);
            if (usedArguments.contains(this.arguments.get((int)i).name)) continue;
            if (formattedValue == null && this.formatters.get(i) != null && this.formatters.get(i) instanceof TableFormatting) {
                DataTable dataTable = ((TableFormatting)this.formatters.get(i)).formatTable(value);
                remainingArguments.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), dataTable));
                continue;
            }
            remainingArguments.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), formattedValue));
        }
        return remainingArguments;
    }

    private <T> String formatUsingFormatterOrNull(ObjectFormatter<T> argumentFormatter, Object value) {
        if (argumentFormatter == null) {
            return null;
        }
        return argumentFormatter.format(value);
    }

    private static String toDefaultStringFormat(Object value) {
        return new DefaultFormatter<Object>().format(value);
    }

    public static class ChainedFormatting<T>
    extends Formatting<ObjectFormatter<T>, T> {
        private final List<Formatting<?, String>> formattings = Lists.newArrayList();

        public ChainedFormatting(ObjectFormatter<T> innerFormatting) {
            super(innerFormatting);
        }

        @Override
        public String format(T o) {
            String result = ((ObjectFormatter)this.getFormatter()).format(o);
            for (Formatting<?, String> formatting : this.formattings) {
                try {
                    result = formatting.format(result);
                }
                catch (ClassCastException e) {
                    throw new JGivenWrongUsageException("Could not apply the formatter. When using multiple formatters on an argument, all but the last need to apply to strings.", e);
                }
            }
            return result;
        }

        public ChainedFormatting<T> addFormatting(Formatting<?, String> formatting) {
            this.formattings.add(formatting);
            return this;
        }
    }

    public static class TableFormatting<F extends TableFormatter>
    extends Formatting<F, Object> {
        private final Table tableAnnotation;
        private final String parameterName;
        private final Annotation[] annotations;

        public TableFormatting(F formatter, Table tableAnnotation, String parameterName, Annotation ... annotations) {
            super(formatter);
            this.tableAnnotation = tableAnnotation;
            this.parameterName = parameterName;
            this.annotations = annotations;
        }

        @Override
        public String format(Object o) {
            return null;
        }

        public DataTable formatTable(Object o) {
            return ((TableFormatter)this.formatter).format(o, this.tableAnnotation, this.parameterName, this.annotations);
        }
    }

    public static class AnnotationBasedFormatter
    implements ArgumentFormatter {
        private final AnnotationArgumentFormatter formatter;
        private final Annotation annotation;

        public AnnotationBasedFormatter(AnnotationArgumentFormatter formatter, Annotation annotation) {
            this.formatter = formatter;
            this.annotation = annotation;
        }

        public String format(Object argumentToFormat, String ... formatterArguments) {
            return this.formatter.format(argumentToFormat, this.annotation);
        }
    }

    public static class ArgumentFormatting<F extends ArgumentFormatter<T>, T>
    extends Formatting<F, T> {
        private final String[] args;

        public ArgumentFormatting(F formatter, String ... args) {
            super(formatter);
            this.args = args;
        }

        @Override
        public String format(T o) {
            return ((ArgumentFormatter)this.formatter).format(o, this.args);
        }
    }

    public static class TypeBasedFormatting<T>
    extends Formatting<Formatter<T>, T> {
        private final Annotation[] annotations;

        public TypeBasedFormatting(Formatter<T> formatter, Annotation[] annotations) {
            super(formatter);
            this.annotations = annotations;
        }

        @Override
        public String format(T o) {
            return ((Formatter)this.formatter).format(o, this.annotations);
        }
    }

    public static abstract class Formatting<F, T>
    implements ObjectFormatter<T> {
        protected final F formatter;

        Formatting(F formatter) {
            this.formatter = formatter;
        }

        @Override
        public abstract String format(T var1);

        public F getFormatter() {
            return this.formatter;
        }
    }
}

