/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.tngtech.jgiven.impl.params.DefaultCaseAsProvider;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextTableWriter;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class PlainTextScenarioWriter
extends PlainTextWriter {
    protected static final String INDENT = "   ";
    public static final String NESTED_HEADING = "  ";
    public static final String NESTED_INDENT = "  ";
    protected ScenarioModel currentScenarioModel;
    protected ScenarioCaseModel currentCaseModel;
    private int maxFillWordLength;
    private boolean firstStep;

    public PlainTextScenarioWriter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.writer.println("\n " + this.bold(WordUtil.capitalize(scenarioModel.getDescription())) + "\n");
        this.currentScenarioModel = scenarioModel;
        this.firstStep = true;
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.getExecutionStatus() == ExecutionStatus.FAILED) {
            this.writer.println();
            this.writer.print(this.withColor(Ansi.Color.RED, Ansi.Attribute.INTENSITY_BOLD, "FAILED: " + scenarioCase.getErrorMessage()));
        }
        this.writer.println();
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (this.currentScenarioModel.getScenarioCases().size() > 1) {
            this.printCaseLine(scenarioCase);
        }
        this.maxFillWordLength = new MaxFillWordLengthGetter().getLength(scenarioCase);
        this.currentCaseModel = scenarioCase;
    }

    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
        this.writer.print(this.bold("  Case " + scenarioCase.getCaseNr() + ": "));
        this.writer.println(this.bold(this.getDescriptionOrDefault(scenarioCase)));
        this.writer.println();
    }

    public String getDescriptionOrDefault(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.hasDescription()) {
            return scenarioCase.getDescription();
        }
        return DefaultCaseAsProvider.defaultDescription(this.currentScenarioModel.getExplicitParameters(), scenarioCase.getExplicitArguments());
    }

    @Override
    public void visit(StepModel stepModel) {
        if (stepModel.isFailed() && stepModel.getNestedSteps() != null) {
            for (StepModel step : stepModel.getNestedSteps()) {
                step.setParentFailed(true);
            }
        }
        this.printStep(stepModel, false);
        this.firstStep = false;
    }

    private void printStep(StepModel stepModel, boolean showPassed) {
        Word lastWord;
        List<Word> words = stepModel.getWords();
        if (stepModel.isSectionTitle().booleanValue()) {
            this.printSectionTitle(stepModel);
            return;
        }
        String introString = this.getIntroString(words, stepModel.getDepth());
        int restSize = words.size();
        boolean printDataTable = false;
        if (words.size() > 1 && (lastWord = words.get(words.size() - 1)).isArg() && lastWord.getArgumentInfo().isDataTable()) {
            --restSize;
            printDataTable = true;
        }
        int introWordIndex = words.get(0).isIntroWord() ? 1 : 0;
        String line = introString + this.joinWords(words.subList(introWordIndex, restSize));
        if (stepModel.isPending()) {
            line = this.gray(line + " (pending)");
        } else if (stepModel.isSkipped()) {
            line = this.gray(line + " (skipped)");
        } else if (stepModel.isFailed()) {
            line = this.boldRed(line + " (failed)");
        } else if (showPassed || stepModel.getDepth() > 0 && stepModel.isParentFailed()) {
            line = this.green(line + " (passed)");
        }
        if (!Strings.isNullOrEmpty((String)stepModel.getComment())) {
            line = line + this.gray(String.format(" [%s]", stepModel.getComment()));
        }
        this.writer.println(line);
        if (printDataTable) {
            this.writer.println();
            this.printDataTable(words.get(words.size() - 1));
        }
    }

    private void printSectionTitle(StepModel stepModel) {
        if (!this.firstStep) {
            this.writer.println();
        }
        this.writer.println(INDENT + this.bold(this.joinWords(stepModel.getWords())));
        this.writer.println();
    }

    private String getIntroString(List<Word> words, int depth) {
        String intro;
        if (depth > 0) {
            intro = INDENT + String.format("%" + this.maxFillWordLength + "s ", " ") + Strings.repeat((String)"  ", (int)(depth - 1)) + "  ";
            if (words.get(0).isIntroWord()) {
                intro = intro + WordUtil.capitalize(words.get(0).getValue()) + " ";
            }
        } else {
            intro = words.get(0).isIntroWord() ? INDENT + String.format("%" + this.maxFillWordLength + "s ", WordUtil.capitalize(words.get(0).getValue())) : INDENT + String.format("%" + this.maxFillWordLength + "s ", " ");
        }
        return intro;
    }

    private void printDataTable(Word word) {
        PlainTextTableWriter plainTextTableWriter = new PlainTextTableWriter(this.writer, this.withColor);
        plainTextTableWriter.writeDataTable(word.getArgumentInfo().getDataTable(), "     ");
        this.writer.println();
    }

    private String joinWords(List<Word> words) {
        return Joiner.on((String)" ").join(Iterables.transform(words, (Function)new Function<Word, String>(){

            public String apply(Word input) {
                return PlainTextScenarioWriter.this.wordToString(input);
            }
        }));
    }

    protected String wordToString(Word word) {
        if (word.isArg() && !this.isInt(word)) {
            return word.getFormattedValue();
        }
        return word.getValue();
    }

    private boolean isInt(Word word) {
        try {
            Integer.valueOf(word.getFormattedValue());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static class MaxFillWordLengthGetter
    extends ReportModelVisitor {
        private int maxLength = 1;

        MaxFillWordLengthGetter() {
        }

        public int getLength(ScenarioCaseModel scenarioCase) {
            scenarioCase.accept(this);
            return this.maxLength;
        }

        @Override
        public void visit(StepModel stepModel) {
            int length;
            Word word = stepModel.getWords().get(0);
            if (word.isIntroWord() && (length = word.getValue().length()) > this.maxLength) {
                this.maxLength = length;
            }
        }
    }
}

