/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.config;

import com.tngtech.jgiven.report.config.CommandLineOption;
import com.tngtech.jgiven.report.config.ConfigOption;
import com.tngtech.jgiven.report.config.converter.StringConverter;

public class ConfigOptionBuilder {
    private ConfigOption co = new ConfigOption();

    public ConfigOptionBuilder(String longName) {
        this.co.setLongName(longName);
    }

    public ConfigOptionBuilder setShortName(String shortName) {
        this.co.setShortName(shortName);
        return this;
    }

    public ConfigOptionBuilder setCommandLineOptionWithArgument(CommandLineOption commandLineOption, StringConverter converter) {
        this.co.setCommandLineOption(commandLineOption);
        return this.setStringConverter(converter);
    }

    public ConfigOptionBuilder setCommandLineOptionWithoutArgument(CommandLineOption commandLineOption, Object value) {
        this.co.setCommandLineOption(commandLineOption);
        this.co.setValue(value);
        return this;
    }

    public ConfigOptionBuilder setPropertyString(String propertyString, StringConverter converter) {
        this.co.setPropertyString(propertyString);
        this.co.setConverter(converter);
        this.co.setHasArgument(true);
        return this;
    }

    public ConfigOptionBuilder setEnvironmentString(String envString, StringConverter converter) {
        this.co.setEnvString(envString);
        this.co.setConverter(converter);
        this.co.setHasArgument(true);
        return this;
    }

    public ConfigOptionBuilder setDescription(String description) {
        this.co.setDescription(description);
        return this;
    }

    public ConfigOptionBuilder setOptional() {
        this.co.setOptional(true);
        return this;
    }

    public ConfigOptionBuilder setDefaultWith(Object defaultValue) {
        this.co.setHasDefault(true);
        this.co.setValue(defaultValue);
        return this.setOptional();
    }

    public ConfigOptionBuilder setStringConverter(StringConverter converter) {
        this.co.setConverter(converter);
        this.co.setHasArgument(true);
        return this;
    }

    public ConfigOption build() {
        return this.co;
    }
}

