/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tngtech.jgiven.annotation.JGivenConfiguration;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class ConfigurationUtil {
    private static final LoadingCache<Class<?>, AbstractJGivenConfiguration> configurations = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, AbstractJGivenConfiguration>(){

        public AbstractJGivenConfiguration load(Class<?> key) {
            AbstractJGivenConfiguration result = (AbstractJGivenConfiguration)ReflectionUtil.newInstance(key);
            result.configure();
            return result;
        }
    });

    public static <A extends AbstractJGivenConfiguration> AbstractJGivenConfiguration getConfiguration(Class<?> testClass) {
        Class<DefaultConfiguration> configuration = Optional.ofNullable(testClass).map(content -> content.getAnnotation(JGivenConfiguration.class)).map(content -> content.value()).orElse(DefaultConfiguration.class);
        try {
            return (AbstractJGivenConfiguration)configurations.get(configuration);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

