/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.CurrentScenario;
import com.tngtech.jgiven.CurrentStep;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.ScenarioRule;
import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.exception.FailIfPassedException;
import com.tngtech.jgiven.exception.JGivenMissingRequiredScenarioStateException;
import com.tngtech.jgiven.exception.JGivenUserException;
import com.tngtech.jgiven.impl.ByteBuddyStageClassCreator;
import com.tngtech.jgiven.impl.CachingStageClassCreator;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.DefaultStageCreator;
import com.tngtech.jgiven.impl.StageClassCreator;
import com.tngtech.jgiven.impl.StageCreator;
import com.tngtech.jgiven.impl.StageLifecycleManager;
import com.tngtech.jgiven.impl.inject.ValueInjector;
import com.tngtech.jgiven.impl.intercept.NoOpScenarioListener;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StageTransitionHandler;
import com.tngtech.jgiven.impl.intercept.StepInterceptorImpl;
import com.tngtech.jgiven.impl.util.FieldCache;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.InvocationMode;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScenarioExecutor.class);
    private Object currentTopLevelStage;
    private State state = State.INIT;
    private boolean beforeScenarioMethodsExecuted;
    private boolean executeLifeCycleMethods = true;
    protected final Map<Class<?>, StageState> stages = new LinkedHashMap();
    private final List<Object> scenarioRules = new ArrayList<Object>();
    private final ValueInjector injector = new ValueInjector();
    private StageCreator stageCreator = this.createStageCreator(new ByteBuddyStageClassCreator());
    private ScenarioListener listener = new NoOpScenarioListener();
    protected final StageTransitionHandler stageTransitionHandler = new StageTransitionHandlerImpl();
    protected final StepInterceptorImpl methodInterceptor = new StepInterceptorImpl(this, this.listener, this.stageTransitionHandler);
    private Throwable failedException;
    private boolean failIfPass;
    private boolean suppressExceptions;
    private boolean suppressStepExceptions = true;

    public ScenarioExecutor() {
        this.injector.injectValueByType(ScenarioExecutor.class, this);
        this.injector.injectValueByType(CurrentStep.class, new StepAccessImpl());
        this.injector.injectValueByType(CurrentScenario.class, new ScenarioAccessImpl());
    }

    <T> T addStage(Class<T> stageClass) {
        if (this.stages.containsKey(stageClass)) {
            return (T)this.stages.get(stageClass).instance;
        }
        T result = this.stageCreator.createStage(stageClass, this.methodInterceptor);
        this.methodInterceptor.enableMethodInterception(true);
        this.stages.put(stageClass, new StageState(result, this.methodInterceptor));
        this.gatherRules(result);
        this.injectStages(result);
        return result;
    }

    public void addIntroWord(String word) {
        this.listener.introWordAdded(word);
    }

    private void gatherRules(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioRule.class)) {
            log.debug("Found rule in field {} ", (Object)field);
            try {
                this.scenarioRules.add(field.get(stage));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while reading field " + field, e);
            }
        }
    }

    private <T> void updateScenarioState(T t) {
        block2: {
            try {
                this.injector.updateValues(t);
            }
            catch (JGivenMissingRequiredScenarioStateException e) {
                if (this.suppressExceptions) break block2;
                throw e;
            }
        }
    }

    private boolean afterStageMethodsCalled(Object stage) {
        return this.getStageState(stage).allAfterStageMethodsHaveBeenExecuted();
    }

    StageState getStageState(Object stage) {
        Class<?> stageClass;
        StageState stageState = this.stages.get(stageClass);
        for (stageClass = stage.getClass(); stageState == null && stageClass != stageClass.getSuperclass(); stageClass = stageClass.getSuperclass()) {
            stageState = this.stages.get(stageClass);
        }
        return stageState;
    }

    private void ensureBeforeScenarioMethodsAreExecuted() throws Throwable {
        if (this.state != State.INIT) {
            return;
        }
        this.state = State.STARTED;
        this.methodInterceptor.enableMethodInterception(false);
        try {
            for (Object rule : this.scenarioRules) {
                this.invokeRuleMethod(rule, "before");
            }
            this.beforeScenarioMethodsExecuted = true;
            for (StageState stage : this.stages.values()) {
                this.executeBeforeScenarioMethods(stage.instance);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            this.finished();
            throw e;
        }
        this.methodInterceptor.enableMethodInterception(true);
    }

    private void invokeRuleMethod(Object rule, String methodName) throws Throwable {
        if (!this.executeLifeCycleMethods) {
            return;
        }
        Optional<Method> optionalMethod = ReflectionUtil.findMethodTransitively(rule.getClass(), methodName);
        if (!optionalMethod.isPresent()) {
            log.debug("Class {} has no {} method, but was used as ScenarioRule!", rule.getClass(), (Object)methodName);
            return;
        }
        try {
            ReflectionUtil.invokeMethod(rule, optionalMethod.get(), " of rule class " + rule.getClass().getName());
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
    }

    private void executeBeforeScenarioMethods(Object stage) throws Throwable {
        this.getStageState(stage).executeBeforeScenarioMethods(!this.executeLifeCycleMethods);
    }

    private void executeBeforeStageMethods(Object stage) throws Throwable {
        this.getStageState(stage).executeBeforeStageMethods(!this.executeLifeCycleMethods);
    }

    private void executeAfterStageMethods(Object stage) throws Throwable {
        this.getStageState(stage).executeAfterStageMethods(!this.executeLifeCycleMethods);
    }

    private void executeAfterScenarioMethods(Object stage) throws Throwable {
        this.getStageState(stage).executeAfterScenarioMethods(!this.executeLifeCycleMethods);
    }

    public void readScenarioState(Object object) {
        this.injector.readValues(object);
    }

    public void wireSteps(CanWire canWire) {
        for (StageState steps : this.stages.values()) {
            canWire.wire(steps.instance);
        }
    }

    public void finished() throws Throwable {
        if (this.state == State.FINISHED) {
            return;
        }
        State previousState = this.state;
        this.state = State.FINISHED;
        this.methodInterceptor.enableMethodInterception(false);
        try {
            if (previousState == State.STARTED) {
                this.callFinishLifeCycleMethods();
            }
        }
        finally {
            this.listener.scenarioFinished();
        }
    }

    private void callFinishLifeCycleMethods() throws Throwable {
        Throwable firstThrownException = this.failedException;
        if (this.beforeScenarioMethodsExecuted) {
            try {
                if (this.currentTopLevelStage != null) {
                    this.executeAfterStageMethods(this.currentTopLevelStage);
                }
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
            for (StageState stage : Lists.reverse((List)Lists.newArrayList(this.stages.values()))) {
                try {
                    this.executeAfterScenarioMethods(stage.instance);
                }
                catch (Exception e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, e);
                }
            }
        }
        for (Object rule : Lists.reverse(this.scenarioRules)) {
            try {
                this.invokeRuleMethod(rule, "after");
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
        }
        this.failedException = firstThrownException;
        if (!this.suppressExceptions && this.failedException != null) {
            throw this.failedException;
        }
        if (this.failIfPass && this.failedException == null) {
            throw new FailIfPassedException();
        }
    }

    private Throwable logAndGetFirstException(Throwable firstThrownException, Throwable newException) {
        log.error(newException.getMessage(), newException);
        return firstThrownException == null ? newException : firstThrownException;
    }

    public void injectStages(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioStage.class)) {
            Object steps = this.addStage(field.getType());
            ReflectionUtil.setField(field, stage, steps, ", annotated with @ScenarioStage");
        }
    }

    public boolean hasFailed() {
        return this.failedException != null;
    }

    public Throwable getFailedException() {
        return this.failedException;
    }

    public void setFailedException(Exception e) {
        this.failedException = e;
    }

    public void failed(Throwable e) {
        if (this.hasFailed()) {
            log.error(e.getMessage(), e);
        } else {
            if (!this.failIfPass) {
                this.listener.scenarioFailed(e);
            }
            this.methodInterceptor.disableMethodExecution();
            this.failedException = e;
        }
    }

    public void startScenario(String description) {
        this.listener.scenarioStarted(description);
    }

    public void startScenario(Class<?> testClass, Method method, List<NamedArgument> arguments) {
        this.listener.scenarioStarted(testClass, method, arguments);
        if (Config.config().dryRun()) {
            this.methodInterceptor.setDefaultInvocationMode(InvocationMode.PENDING);
            this.methodInterceptor.disableMethodExecution();
            this.executeLifeCycleMethods = false;
            this.suppressExceptions = true;
        } else {
            Pending annotation = this.extractPendingAnnotation(method);
            if (annotation == null) {
                this.methodInterceptor.setSuppressExceptions(this.suppressStepExceptions);
            } else {
                if (annotation.failIfPass()) {
                    this.failIfPass();
                } else {
                    this.methodInterceptor.setDefaultInvocationMode(InvocationMode.PENDING);
                    if (!annotation.executeSteps()) {
                        this.methodInterceptor.disableMethodExecution();
                        this.executeLifeCycleMethods = false;
                    }
                }
                this.suppressExceptions = true;
            }
        }
    }

    private Pending extractPendingAnnotation(Method method) {
        if (method.isAnnotationPresent(Pending.class)) {
            return method.getAnnotation(Pending.class);
        }
        if (method.getDeclaringClass().isAnnotationPresent(Pending.class)) {
            return method.getDeclaringClass().getAnnotation(Pending.class);
        }
        return null;
    }

    public void setListener(ScenarioListener listener) {
        this.listener = listener;
        this.methodInterceptor.setScenarioListener(listener);
    }

    public void failIfPass() {
        this.failIfPass = true;
    }

    public void setSuppressStepExceptions(boolean suppressStepExceptions) {
        this.suppressStepExceptions = suppressStepExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public void addSection(String sectionTitle) {
        this.listener.sectionAdded(sectionTitle);
    }

    public void setStageCreator(StageCreator stageCreator) {
        this.stageCreator = stageCreator;
    }

    public void setStageClassCreator(StageClassCreator stageClassCreator) {
        this.stageCreator = this.createStageCreator(stageClassCreator);
    }

    private StageCreator createStageCreator(StageClassCreator stageClassCreator) {
        return new DefaultStageCreator(new CachingStageClassCreator(stageClassCreator));
    }

    private static class StageState
    extends StageLifecycleManager {
        final Object instance;
        Object currentChildStage;

        private StageState(Object instance, StepInterceptorImpl methodInterceptor) {
            super(instance, methodInterceptor);
            this.instance = instance;
        }
    }

    class StageTransitionHandlerImpl
    implements StageTransitionHandler {
        StageTransitionHandlerImpl() {
        }

        @Override
        public void enterStage(Object parentStage, Object childStage) throws Throwable {
            if (parentStage == childStage || ScenarioExecutor.this.currentTopLevelStage == childStage) {
                return;
            }
            if (ScenarioExecutor.this.currentTopLevelStage == null) {
                ScenarioExecutor.this.ensureBeforeScenarioMethodsAreExecuted();
            } else if (parentStage == null) {
                ScenarioExecutor.this.executeAfterStageMethods(ScenarioExecutor.this.currentTopLevelStage);
                ScenarioExecutor.this.readScenarioState(ScenarioExecutor.this.currentTopLevelStage);
            } else {
                ScenarioExecutor.this.readScenarioState(parentStage);
                StageState stageState = ScenarioExecutor.this.getStageState(parentStage);
                if (stageState.currentChildStage != null && stageState.currentChildStage != childStage && !ScenarioExecutor.this.afterStageMethodsCalled(stageState.currentChildStage)) {
                    ScenarioExecutor.this.updateScenarioState(stageState.currentChildStage);
                    ScenarioExecutor.this.executeAfterStageMethods(stageState.currentChildStage);
                    ScenarioExecutor.this.readScenarioState(stageState.currentChildStage);
                }
                stageState.currentChildStage = childStage;
            }
            ScenarioExecutor.this.updateScenarioState(childStage);
            ScenarioExecutor.this.executeBeforeStageMethods(childStage);
            if (parentStage == null) {
                ScenarioExecutor.this.currentTopLevelStage = childStage;
            }
        }

        @Override
        public void leaveStage(Object parentStage, Object childStage) throws Throwable {
            if (parentStage == childStage || parentStage == null) {
                return;
            }
            ScenarioExecutor.this.readScenarioState(childStage);
            StageState childState = ScenarioExecutor.this.getStageState(childStage);
            if (childState.currentChildStage != null) {
                ScenarioExecutor.this.updateScenarioState(childState.currentChildStage);
                if (!ScenarioExecutor.this.getStageState(childState.currentChildStage).allAfterStageMethodsHaveBeenExecuted()) {
                    ScenarioExecutor.this.executeAfterStageMethods(childState.currentChildStage);
                    ScenarioExecutor.this.readScenarioState(childState.currentChildStage);
                    ScenarioExecutor.this.updateScenarioState(childStage);
                }
                childState.currentChildStage = null;
            }
            ScenarioExecutor.this.updateScenarioState(parentStage);
        }
    }

    class ScenarioAccessImpl
    implements CurrentScenario {
        ScenarioAccessImpl() {
        }

        @Override
        public void addTag(Class<? extends Annotation> annotationClass, String ... values) {
            ScenarioExecutor.this.listener.tagAdded(annotationClass, values);
        }
    }

    class StepAccessImpl
    implements CurrentStep {
        StepAccessImpl() {
        }

        @Override
        public void addAttachment(Attachment attachment) {
            ScenarioExecutor.this.listener.attachmentAdded(attachment);
        }

        @Override
        public void setExtendedDescription(String extendedDescription) {
            ScenarioExecutor.this.listener.extendedDescriptionUpdated(extendedDescription);
        }

        @Override
        public void setName(String name) {
            ScenarioExecutor.this.listener.stepNameUpdated(name);
        }

        @Override
        public void setComment(String comment) {
            ScenarioExecutor.this.listener.stepCommentUpdated(comment);
        }
    }

    static enum State {
        INIT,
        STARTED,
        FINISHED;

    }
}

