/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.AsProvider;
import com.tngtech.jgiven.annotation.CaseAs;
import com.tngtech.jgiven.annotation.CaseAsProvider;
import com.tngtech.jgiven.annotation.Description;
import com.tngtech.jgiven.annotation.ExtendedDescription;
import com.tngtech.jgiven.annotation.FillerWord;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.IntroWord;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.StepComment;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.SentenceBuilder;
import com.tngtech.jgiven.impl.format.ParameterFormattingUtil;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.params.DefaultAsProvider;
import com.tngtech.jgiven.impl.tag.ResolvedTags;
import com.tngtech.jgiven.impl.tag.TagCreator;
import com.tngtech.jgiven.impl.util.AnnotationUtil;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.InvocationMode;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepFormatter;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ScenarioModelBuilder
implements ScenarioListener {
    private static final Set<String> STACK_TRACE_FILTER = ImmutableSet.of((Object)"sun.reflect", (Object)"com.tngtech.jgiven.impl.intercept", (Object)"com.tngtech.jgiven.impl.intercept", (Object)"$$EnhancerByCGLIB$$", (Object)"java.lang.reflect", (Object)"net.sf.cglib.proxy", (Object[])new String[]{"com.sun.proxy"});
    private static final boolean FILTER_STACK_TRACE = Config.config().filterStackTrace();
    private ScenarioModel scenarioModel;
    private ScenarioCaseModel scenarioCaseModel;
    private StepModel currentStep;
    private final Stack<StepModel> parentSteps = new Stack();
    private final SentenceBuilder sentenceBuilder = new SentenceBuilder();
    private long scenarioStartedNanos;
    private AbstractJGivenConfiguration configuration = new DefaultConfiguration();
    private ReportModel reportModel;
    private TagCreator tagCreator;
    private Stack<Integer> discrepancyOnLayer = new Stack();

    public void setReportModel(ReportModel reportModel) {
        this.reportModel = reportModel;
    }

    @Override
    public void scenarioStarted(String description) {
        this.scenarioStartedNanos = System.nanoTime();
        String readableDescription = description;
        if (description.contains("_")) {
            readableDescription = description.replace('_', ' ');
        } else if (!description.contains(" ")) {
            readableDescription = WordUtil.camelCaseToCapitalizedReadableText(description);
        }
        this.scenarioCaseModel = new ScenarioCaseModel();
        this.scenarioModel = new ScenarioModel();
        this.scenarioModel.addCase(this.scenarioCaseModel);
        this.scenarioModel.setDescription(readableDescription);
        this.tagCreator = new TagCreator(this.configuration);
        this.discrepancyOnLayer.push(0);
    }

    @Override
    public void scenarioStarted(Class<?> testClass, Method method, List<NamedArgument> namedArguments) {
        this.readConfiguration(testClass);
        this.readAnnotations(testClass, method);
        this.scenarioModel.setClassName(testClass.getName());
        this.setParameterNames(this.getNames(namedArguments));
        this.setMethodName(method.getName());
        ParameterFormattingUtil parameterFormattingUtil = new ParameterFormattingUtil(this.configuration);
        List<ObjectFormatter<?>> formatter = parameterFormattingUtil.getFormatter(method.getParameterTypes(), this.getNames(namedArguments), method.getParameterAnnotations());
        this.setArguments(parameterFormattingUtil.toStringList(formatter, this.getValues(namedArguments)));
        this.setCaseDescription(testClass, method, namedArguments);
    }

    private void addStepMethod(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode, boolean hasNestedSteps) {
        StepModel stepModel = this.createStepModel(paramMethod, arguments, mode);
        if (this.parentSteps.empty()) {
            this.getCurrentScenarioCase().addStep(stepModel);
        } else {
            this.parentSteps.peek().addNestedStep(stepModel);
        }
        if (hasNestedSteps) {
            this.parentSteps.push(stepModel);
            this.discrepancyOnLayer.push(0);
        }
        this.currentStep = stepModel;
    }

    StepModel createStepModel(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        StepModel stepModel = new StepModel();
        stepModel.setName(this.getDescription(paramMethod));
        ExtendedDescription extendedDescriptionAnnotation = paramMethod.getAnnotation(ExtendedDescription.class);
        if (extendedDescriptionAnnotation != null) {
            stepModel.setExtendedDescription(extendedDescriptionAnnotation.value());
        }
        List<NamedArgument> nonHiddenArguments = this.filterHiddenArguments(arguments, paramMethod.getParameterAnnotations());
        ParameterFormattingUtil parameterFormattingUtil = new ParameterFormattingUtil(this.configuration);
        List<ObjectFormatter<?>> formatters = parameterFormattingUtil.getFormatter(paramMethod.getParameterTypes(), this.getNames(arguments), paramMethod.getParameterAnnotations());
        new StepFormatter(stepModel.getName(), nonHiddenArguments, formatters).buildFormattedWords().forEach(this.sentenceBuilder::addWord);
        stepModel.setWords(this.sentenceBuilder.getWords());
        this.sentenceBuilder.clear();
        stepModel.setStatus(mode.toStepStatus());
        return stepModel;
    }

    private List<NamedArgument> filterHiddenArguments(List<NamedArgument> arguments, Annotation[][] parameterAnnotations) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (AnnotationUtil.isHidden(parameterAnnotations[i])) continue;
            result.add(arguments.get(i));
        }
        return result;
    }

    @Override
    public void introWordAdded(String value) {
        this.sentenceBuilder.addIntroWord(value);
    }

    private void addToSentence(String value, boolean joinToPreviousWord, boolean joinToNextWord) {
        if (!this.sentenceBuilder.hasWords() && this.currentStep != null && joinToPreviousWord) {
            this.currentStep.getLastWord().addSuffix(value);
        } else {
            this.sentenceBuilder.addWord(value, joinToPreviousWord, joinToNextWord);
        }
    }

    private void addStepComment(List<NamedArgument> arguments) {
        if (arguments == null || arguments.size() != 1) {
            throw new JGivenWrongUsageException("A step comment method must have exactly one parameter.");
        }
        if (!(arguments.get(0).getValue() instanceof String)) {
            throw new JGivenWrongUsageException("The step comment method parameter must be a string.");
        }
        if (this.currentStep == null) {
            throw new JGivenWrongUsageException("A step comment must be added after the corresponding step, but no step has been executed yet.");
        }
        this.stepCommentUpdated((String)arguments.get(0).getValue());
    }

    @Override
    public void stepCommentUpdated(String comment) {
        this.currentStep.setComment(comment);
    }

    private ScenarioCaseModel getCurrentScenarioCase() {
        if (this.scenarioCaseModel == null) {
            this.scenarioStarted("A Scenario");
        }
        return this.scenarioCaseModel;
    }

    private void incrementDiscrepancy() {
        int discrepancyOnCurrentLayer = this.discrepancyOnLayer.pop();
        this.discrepancyOnLayer.push(++discrepancyOnCurrentLayer);
    }

    private void decrementDiscrepancy() {
        if (this.discrepancyOnLayer.peek() > 0) {
            int discrepancyOnCurrentLayer = this.discrepancyOnLayer.pop();
            this.discrepancyOnLayer.push(--discrepancyOnCurrentLayer);
        }
    }

    @Override
    public void stepMethodInvoked(Method method, List<NamedArgument> arguments, InvocationMode mode, boolean hasNestedSteps) {
        if (method.isAnnotationPresent(IntroWord.class)) {
            this.introWordAdded(this.getDescription(method));
            this.incrementDiscrepancy();
        } else if (method.isAnnotationPresent(FillerWord.class)) {
            FillerWord fillerWord = method.getAnnotation(FillerWord.class);
            this.addToSentence(this.getDescription(method), fillerWord.joinToPreviousWord(), fillerWord.joinToNextWord());
            this.incrementDiscrepancy();
        } else if (method.isAnnotationPresent(StepComment.class)) {
            this.addStepComment(arguments);
            this.incrementDiscrepancy();
        } else {
            this.addTags(method.getAnnotations());
            this.addTags(method.getDeclaringClass().getAnnotations());
            this.addStepMethod(method, arguments, mode, hasNestedSteps);
        }
    }

    public void setMethodName(String methodName) {
        this.scenarioModel.setTestMethodName(methodName);
    }

    public void setArguments(List<String> arguments) {
        this.scenarioCaseModel.setExplicitArguments(arguments);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.scenarioModel.setExplicitParameters(ScenarioModelBuilder.removeUnderlines(parameterNames));
    }

    private static List<String> removeUnderlines(List<String> parameterNames) {
        ArrayList result = Lists.newArrayListWithCapacity((int)parameterNames.size());
        for (String paramName : parameterNames) {
            result.add(WordUtil.fromSnakeCase(paramName));
        }
        return result;
    }

    private String getDescription(Method paramMethod) {
        if (paramMethod.isAnnotationPresent(Hidden.class)) {
            return "";
        }
        Description description = paramMethod.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        As as = paramMethod.getAnnotation(As.class);
        AsProvider provider = as != null ? ReflectionUtil.newInstance(as.provider()) : new DefaultAsProvider();
        return provider.as(as, paramMethod);
    }

    public void setStatus(ExecutionStatus status) {
        this.scenarioCaseModel.setStatus(status);
    }

    private void setException(Throwable throwable) {
        this.scenarioCaseModel.setErrorMessage(throwable.getClass().getName() + ": " + throwable.getMessage());
        this.scenarioCaseModel.setStackTrace(this.getStackTrace(throwable, FILTER_STACK_TRACE));
    }

    private List<String> getStackTrace(Throwable exception, boolean filterStackTrace) {
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        ArrayList<String> stackTrace = new ArrayList<String>(stackTraceElements.length);
        block0: for (StackTraceElement element : stackTraceElements) {
            if (filterStackTrace) {
                for (String filter : STACK_TRACE_FILTER) {
                    if (!element.getClassName().contains(filter)) continue;
                    continue block0;
                }
            }
            stackTrace.add(element.toString());
        }
        return stackTrace;
    }

    @Override
    public void stepMethodFailed(Throwable t) {
        if (this.currentStep != null) {
            this.currentStep.setStatus(StepStatus.FAILED);
        }
    }

    @Override
    public void stepMethodFinished(long durationInNanos, boolean hasNestedSteps) {
        if (hasNestedSteps && !this.parentSteps.isEmpty()) {
            this.currentStep = this.parentSteps.peek();
        }
        if (this.currentStep != null) {
            if (this.discrepancyOnLayer.empty() || this.discrepancyOnLayer.peek() == 0) {
                this.currentStep.setDurationInNanos(durationInNanos);
            }
            if (hasNestedSteps) {
                if (this.currentStep.getStatus() != StepStatus.FAILED) {
                    this.currentStep.setStatus(this.getStatusFromNestedSteps(this.currentStep.getNestedSteps()));
                }
                this.parentSteps.pop();
                this.discrepancyOnLayer.pop();
            }
        }
        if (!hasNestedSteps && !this.parentSteps.isEmpty()) {
            this.currentStep = this.parentSteps.peek();
        }
        this.decrementDiscrepancy();
    }

    private StepStatus getStatusFromNestedSteps(List<StepModel> nestedSteps) {
        StepStatus status = StepStatus.PASSED;
        for (StepModel nestedModel : nestedSteps) {
            StepStatus nestedStatus = nestedModel.getStatus();
            switch (nestedStatus) {
                case FAILED: {
                    return StepStatus.FAILED;
                }
                case PENDING: {
                    status = StepStatus.PENDING;
                    break;
                }
            }
        }
        return status;
    }

    @Override
    public void scenarioFailed(Throwable e) {
        this.setStatus(ExecutionStatus.FAILED);
        this.setException(e);
    }

    private void setCaseDescription(Class<?> testClass, Method method, List<NamedArgument> namedArguments) {
        CaseAs annotation = null;
        if (method.isAnnotationPresent(CaseAs.class)) {
            annotation = method.getAnnotation(CaseAs.class);
        } else if (testClass.isAnnotationPresent(CaseAs.class)) {
            annotation = testClass.getAnnotation(CaseAs.class);
        }
        if (annotation != null) {
            CaseAsProvider caseDescriptionProvider = ReflectionUtil.newInstance(annotation.provider());
            String value = annotation.value();
            List<Object> values = annotation.formatValues() ? this.scenarioCaseModel.getExplicitArguments() : this.getValues(namedArguments);
            String caseDescription = caseDescriptionProvider.as(value, this.scenarioModel.getExplicitParameters(), values);
            this.scenarioCaseModel.setDescription(caseDescription);
        }
    }

    private List<Object> getValues(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.value);
        }
        return result;
    }

    private List<String> getNames(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.name);
        }
        return result;
    }

    private void readConfiguration(Class<?> testClass) {
        this.configuration = ConfigurationUtil.getConfiguration(testClass);
    }

    private void readAnnotations(Class<?> testClass, Method method) {
        String scenarioDescription = method.getName();
        if (method.isAnnotationPresent(Description.class)) {
            scenarioDescription = method.getAnnotation(Description.class).value();
        } else if (method.isAnnotationPresent(As.class)) {
            As as = method.getAnnotation(As.class);
            AsProvider provider = ReflectionUtil.newInstance(as.provider());
            scenarioDescription = provider.as(as, method);
        }
        this.scenarioStarted(scenarioDescription);
        if (method.isAnnotationPresent(ExtendedDescription.class)) {
            this.scenarioModel.setExtendedDescription(method.getAnnotation(ExtendedDescription.class).value());
        }
        if (method.isAnnotationPresent(Pending.class) || method.getDeclaringClass().isAnnotationPresent(Pending.class)) {
            this.scenarioCaseModel.setStatus(ExecutionStatus.SCENARIO_PENDING);
        }
        if (this.scenarioCaseModel.getCaseNr() == 1) {
            this.addTags(testClass.getAnnotations());
            this.addTags(method.getAnnotations());
        }
    }

    @Override
    public void scenarioFinished() {
        AssertionUtil.assertTrue(this.scenarioStartedNanos > 0L, "Scenario has no start time");
        long durationInNanos = System.nanoTime() - this.scenarioStartedNanos;
        this.scenarioCaseModel.setDurationInNanos(durationInNanos);
        this.scenarioModel.addDurationInNanos(durationInNanos);
        this.reportModel.addScenarioModelOrMergeWithExistingOne(this.scenarioModel);
    }

    @Override
    public void attachmentAdded(Attachment attachment) {
        this.currentStep.addAttachment(attachment);
    }

    @Override
    public void extendedDescriptionUpdated(String extendedDescription) {
        this.currentStep.setExtendedDescription(extendedDescription);
    }

    @Override
    public void stepNameUpdated(String newStepName) {
        ArrayList newWords = Lists.newArrayList();
        for (Word word : this.currentStep.getWords()) {
            if (!word.isIntroWord()) continue;
            newWords.add(word);
        }
        newWords.add(new Word(newStepName));
        this.currentStep.setWords(newWords);
        this.currentStep.setName(newStepName);
    }

    @Override
    public void sectionAdded(String sectionTitle) {
        StepModel stepModel = new StepModel();
        stepModel.setName(sectionTitle);
        stepModel.addWords(new Word(sectionTitle));
        stepModel.setIsSectionTitle(true);
        this.getCurrentScenarioCase().addStep(stepModel);
    }

    @Override
    public void tagAdded(Class<? extends Annotation> annotationClass, String ... values) {
        this.addTags(this.tagCreator.toTags(annotationClass, values));
    }

    private void addTags(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            this.addTags(this.tagCreator.toTags(annotation));
        }
    }

    private void addTags(ResolvedTags tags) {
        if (tags.isEmpty()) {
            return;
        }
        if (this.reportModel != null) {
            this.reportModel.addTags(tags.getDeclaredTags());
            this.reportModel.addTags(tags.getAncestors());
        }
        if (this.scenarioModel != null) {
            this.scenarioModel.addTags(tags.getDeclaredTags());
        }
    }

    public ReportModel getReportModel() {
        return this.reportModel;
    }

    public ScenarioModel getScenarioModel() {
        return this.scenarioModel;
    }

    public ScenarioCaseModel getScenarioCaseModel() {
        return this.scenarioCaseModel;
    }
}

