/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.collect.ImmutableList;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

class SentenceBuilder {
    private final Deque<Word> words = new ArrayDeque<Word>();
    private boolean joinNextWord;

    SentenceBuilder() {
    }

    boolean hasWords() {
        return !this.words.isEmpty();
    }

    void clear() {
        this.words.clear();
    }

    List<Word> getWords() {
        return ImmutableList.copyOf(this.words);
    }

    void addIntroWord(String value) {
        this.words.removeIf(Word::isIntroWord);
        this.words.addFirst(new Word(value, true));
    }

    void addWord(Word word) {
        this.addWord(word, false, false);
    }

    void addWord(String value, boolean joinToPreviousWord, boolean joinToNextWord) {
        this.addWord(new Word(value), joinToPreviousWord, joinToNextWord);
    }

    void addWord(Word word, boolean joinToPreviousWord, boolean joinToNextWord) {
        if (this.hasWords() && this.joinNextWord) {
            word.addPrefix(this.words.removeLast().getFormattedValue());
            this.words.add(word);
        } else if (this.hasWords() && joinToPreviousWord) {
            this.words.getLast().addSuffix(word.getFormattedValue());
        } else {
            this.words.add(word);
        }
        this.joinNextWord = joinToNextWord;
    }
}

