/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.tag;

import com.tngtech.jgiven.report.model.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ResolvedTags {
    List<ResolvedTag> resolvedTags = new ArrayList<ResolvedTag>();

    public List<Tag> getDeclaredTags() {
        return this.resolvedTags.stream().map(resolvedTag -> resolvedTag.tag).collect(Collectors.toList());
    }

    public Set<Tag> getAncestors() {
        return this.resolvedTags.stream().flatMap(resolvedTag -> resolvedTag.ancestors.stream()).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.resolvedTags.isEmpty();
    }

    static ResolvedTags from(ResolvedTag resolvedTag) {
        ResolvedTags wrapper = new ResolvedTags();
        wrapper.resolvedTags.add(resolvedTag);
        return wrapper;
    }

    public static class ResolvedTag {
        public final Tag tag;
        public final List<Tag> ancestors;

        ResolvedTag(Tag tag, List<Tag> ancestors) {
            this.tag = tag;
            this.ancestors = ancestors;
        }
    }
}

