/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.tag;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.IsTag;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.TagConfiguration;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.impl.tag.ResolvedTags;
import com.tngtech.jgiven.impl.tag.TagCollector;
import com.tngtech.jgiven.report.model.Tag;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagCreator {
    private static final Logger log = LoggerFactory.getLogger(TagCreator.class);
    private final AbstractJGivenConfiguration configuration;

    public TagCreator(AbstractJGivenConfiguration configuration) {
        this.configuration = configuration;
    }

    public ResolvedTags toTags(Class<? extends Annotation> annotationClass, String ... values) {
        TagConfiguration tagConfig = this.toTagConfiguration(annotationClass);
        if (tagConfig == null) {
            return new ResolvedTags();
        }
        List<Tag> tags = this.processConfiguredAnnotation(tagConfig);
        if (tags.isEmpty()) {
            return new ResolvedTags();
        }
        List<Tag> ancestors = this.getAllAncestorTags(annotationClass);
        if (values.length > 0) {
            List<Tag> explodedTags = this.getExplodedTags((Tag)Iterables.getOnlyElement(tags), values, null, tagConfig);
            return explodedTags.stream().map(tag -> new ResolvedTags.ResolvedTag((Tag)tag, ancestors)).collect(new TagCollector());
        }
        return ResolvedTags.from(new ResolvedTags.ResolvedTag((Tag)Iterables.getOnlyElement(tags), ancestors));
    }

    public ResolvedTags toTags(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        TagConfiguration tagConfig = this.toTagConfiguration(annotationType);
        if (tagConfig == null) {
            return new ResolvedTags();
        }
        List<Tag> tags = this.processConfiguredAnnotation(tagConfig, annotation);
        List<Tag> parents = this.getAllAncestorTags(annotationType);
        return tags.stream().map(tag -> new ResolvedTags.ResolvedTag((Tag)tag, parents)).collect(new TagCollector());
    }

    private List<Tag> processConfiguredAnnotation(TagConfiguration tagConfig, Annotation annotation) {
        if (tagConfig.isIgnoreValue()) {
            return this.processConfiguredAnnotation(tagConfig);
        }
        Tag tag = this.createStyledTag(tagConfig);
        tag.setTags(tagConfig.getTags());
        Optional<Object> valueOptional = this.getValuesFromAnnotation(annotation);
        if (valueOptional.isPresent()) {
            Object value = valueOptional.get();
            if (value.getClass().isArray()) {
                if (tagConfig.isExplodeArray()) {
                    return this.getExplodedTags(tag, (Object[])value, annotation, tagConfig);
                }
                tag.setValue(this.toStringList((Object[])value));
            } else {
                tag.setValue(String.valueOf(value));
            }
        } else {
            this.setIfNotNullOrEmpty(tagConfig.getDefaultValue(), tag::setValue);
        }
        tag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, valueOptional.orElse(null)));
        tag.setHref(this.getHref(tagConfig, annotation, valueOptional.orElse(null)));
        return Collections.singletonList(tag);
    }

    private List<Tag> processConfiguredAnnotation(TagConfiguration tagConfig) {
        if (!tagConfig.isIgnoreValue()) {
            log.warn("Tag configuration 'ignoreValue', set to 'false' is ignored, because no annotation that could be respected was given.");
        }
        Tag tag = this.createStyledTag(tagConfig);
        tag.setTags(tagConfig.getTags());
        String value = tagConfig.getDefaultValue();
        this.setIfNotNullOrEmpty(value, tag::setValue);
        tag.setDescription(this.getDescriptionFromGenerator(tagConfig, null, value));
        tag.setHref(this.getHref(tagConfig, null, value));
        return Collections.singletonList(tag);
    }

    private Tag createStyledTag(TagConfiguration tagConfig) {
        Tag tag = new Tag(tagConfig.getAnnotationFullType());
        tag.setType(tagConfig.getAnnotationType());
        tag.setPrependType(tagConfig.isPrependType());
        tag.setShowInNavigation(tagConfig.showInNavigation());
        this.setIfNotNullOrEmpty(tagConfig.getName(), tag::setName);
        this.setIfNotNullOrEmpty(tagConfig.getCssClass(), tag::setCssClass);
        this.setIfNotNullOrEmpty(tagConfig.getColor(), tag::setColor);
        this.setIfNotNullOrEmpty(tagConfig.getStyle(), tag::setStyle);
        return tag;
    }

    private void setIfNotNullOrEmpty(String value, Consumer<String> setter) {
        if (!Strings.isNullOrEmpty((String)value)) {
            setter.accept(value);
        }
    }

    private Optional<Object> getValuesFromAnnotation(Annotation annotation) {
        try {
            Method method = annotation.annotationType().getMethod("value", new Class[0]);
            return Optional.ofNullable(method.invoke((Object)annotation, new Object[0]));
        }
        catch (NoSuchMethodException ignoreAnnotationsThatAreNotTags) {
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("Error while getting 'value' method of annotation " + annotation, (Throwable)e);
            return Optional.empty();
        }
    }

    TagConfiguration toTagConfiguration(Class<? extends Annotation> annotationType) {
        IsTag isTag = annotationType.getAnnotation(IsTag.class);
        if (isTag != null) {
            return this.fromIsTag(isTag, annotationType);
        }
        return this.configuration.getTagConfiguration(annotationType);
    }

    private TagConfiguration fromIsTag(IsTag isTag, Class<? extends Annotation> annotationType) {
        String name = isTag.name();
        return TagConfiguration.builder(annotationType).defaultValue(isTag.value()).description(isTag.description()).explodeArray(isTag.explodeArray()).ignoreValue(isTag.ignoreValue()).prependType(isTag.prependType()).name(name).descriptionGenerator(isTag.descriptionGenerator()).cssClass(isTag.cssClass()).color(isTag.color()).style(isTag.style()).tags(this.getNamesOfParentTags(annotationType)).href(isTag.href()).hrefGenerator(isTag.hrefGenerator()).showInNavigation(isTag.showInNavigation()).build();
    }

    private List<String> getNamesOfParentTags(Class<? extends Annotation> annotationType) {
        return this.getTagAnnotationsOn(annotationType).flatMap(resolvedTags -> resolvedTags.getDeclaredTags().stream()).map(Tag::toIdString).collect(Collectors.toList());
    }

    private List<Tag> getAllAncestorTags(Class<? extends Annotation> annotationType) {
        return this.getTagAnnotationsOn(annotationType).flatMap(resolvedTags -> resolvedTags.resolvedTags.stream()).flatMap(tag -> {
            Stream<Tag> tagStream = Stream.of(tag.tag);
            return Stream.concat(tagStream, tag.ancestors.stream());
        }).collect(Collectors.toList());
    }

    private Stream<ResolvedTags> getTagAnnotationsOn(Class<? extends Annotation> annotationType) {
        return Arrays.stream(annotationType.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(IsTag.class)).map(this::toTags);
    }

    private List<String> toStringList(Object[] value) {
        ArrayList values = Lists.newArrayList();
        for (Object v : value) {
            values.add(String.valueOf(v));
        }
        return values;
    }

    private String getDescriptionFromGenerator(TagConfiguration tagConfiguration, Annotation annotation, Object value) {
        try {
            return tagConfiguration.getDescriptionGenerator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).generateDescription(tagConfiguration, annotation, value);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Error while trying to generate the description for annotation " + annotation + " using DescriptionGenerator class " + tagConfiguration.getDescriptionGenerator() + ": " + e.getMessage(), e);
        }
    }

    private String getHref(TagConfiguration tagConfiguration, Annotation annotation, Object value) {
        try {
            return tagConfiguration.getHrefGenerator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).generateHref(tagConfiguration, annotation, value);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Error while trying to generate the href for annotation " + annotation + " using HrefGenerator class " + tagConfiguration.getHrefGenerator() + ": " + e.getMessage(), e);
        }
    }

    private List<Tag> getExplodedTags(Tag originalTag, Object[] values, Annotation annotation, TagConfiguration tagConfig) {
        ArrayList result = Lists.newArrayList();
        for (Object singleValue : values) {
            Tag newTag = originalTag.copy();
            newTag.setValue(String.valueOf(singleValue));
            newTag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, singleValue));
            newTag.setHref(this.getHref(tagConfig, annotation, singleValue));
            result.add(newTag);
        }
        return result;
    }
}

