/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.CLibrary;

public class AnsiUtil {
    public static OutputStream wrapOutputStream(OutputStream stream, boolean ttyDetection) {
        String os = System.getProperty("os.name");
        String vendor = System.getProperty("java.vendor");
        if (os.startsWith("Windows")) {
            try {
                return new WindowsAnsiOutputStream(stream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream);
            }
        }
        if (vendor.toLowerCase().contains("android")) {
            return new FilterOutputStream(stream){

                @Override
                public void close() throws IOException {
                    this.write(AnsiOutputStream.REST_CODE);
                    this.flush();
                    super.close();
                }
            };
        }
        if (!vendor.toLowerCase().contains("android") && ttyDetection) {
            try {
                int rc = CLibrary.isatty((int)CLibrary.STDOUT_FILENO);
                if (rc == 0) {
                    return new AnsiOutputStream(stream);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return new FilterOutputStream(stream){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.REST_CODE);
                this.flush();
                super.close();
            }
        };
    }
}

