/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.tngtech.jgiven.report.config.CommandLineOptionBuilder;
import com.tngtech.jgiven.report.config.ConfigOption;
import com.tngtech.jgiven.report.config.ConfigOptionBuilder;
import com.tngtech.jgiven.report.config.ConfigOptionParser;
import com.tngtech.jgiven.report.config.converter.ToBoolean;
import com.tngtech.jgiven.report.config.converter.ToFile;
import com.tngtech.jgiven.report.config.converter.ToString;
import com.tngtech.jgiven.report.json.ReportModelReader;
import com.tngtech.jgiven.report.model.CompleteReportModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractReportConfig.class);
    private List<ConfigOption> configOptions = this.createConfigOptions();
    private String title;
    private File sourceDir;
    private File targetDir;
    private Boolean excludeEmptyScenarios;

    public AbstractReportConfig(String ... args) {
        Map<String, Object> configMap = new ConfigOptionParser().generate(this.configOptions, args);
        this.setTitle((String)configMap.get("title"));
        this.setSourceDir((File)configMap.get("sourceDir"));
        this.setTargetDir((File)configMap.get("targetDir"));
        this.setExcludeEmptyScenarios((Boolean)configMap.get("excludeEmptyScenarios"));
        this.useConfigMap(configMap);
    }

    public AbstractReportConfig() {
        this.setTitle("JGiven Report");
        this.setSourceDir(new File("."));
        this.setTargetDir(new File("."));
        this.setExcludeEmptyScenarios(false);
    }

    private List<ConfigOption> createConfigOptions() {
        ArrayList<ConfigOption> configOptions = new ArrayList<ConfigOption>();
        ConfigOption sourceDir = new ConfigOptionBuilder("sourceDir").setCommandLineOptionWithArgument(new CommandLineOptionBuilder("--sourceDir").setArgumentDelimiter("=").setShortPrefix("--dir").setVisualPlaceholder("path").build(), new ToFile()).setDescription("the source directory where the JGiven JSON files are located (default: .)").setDefaultWith(new File(".")).build();
        ConfigOption targetDir = new ConfigOptionBuilder("targetDir").setCommandLineOptionWithArgument(new CommandLineOptionBuilder("--targetDir").setArgumentDelimiter("=").setShortPrefix("--todir").setVisualPlaceholder("path").build(), new ToFile()).setDescription("the directory to generate the report to (default: .)").setDefaultWith(new File(".")).build();
        ConfigOption title = new ConfigOptionBuilder("title").setCommandLineOptionWithArgument(new CommandLineOptionBuilder("--title").setArgumentDelimiter("=").setVisualPlaceholder("string").build(), new ToString()).setDescription("the title of the report (default: JGiven Report)").setDefaultWith("JGiven Report").build();
        ConfigOption excludeEmptyScenarios = new ConfigOptionBuilder("excludeEmptyScenarios").setCommandLineOptionWithArgument(new CommandLineOptionBuilder("--exclude-empty-scenarios").setArgumentDelimiter("=").setVisualPlaceholder("boolean").build(), new ToBoolean()).setDescription("(default: false)").setDefaultWith(false).build();
        configOptions.addAll(Arrays.asList(sourceDir, targetDir, title, excludeEmptyScenarios));
        this.additionalConfigOptions(configOptions);
        return configOptions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public Boolean getExcludeEmptyScenarios() {
        return this.excludeEmptyScenarios;
    }

    public void setExcludeEmptyScenarios(Boolean excludeEmptyScenarios) {
        this.excludeEmptyScenarios = excludeEmptyScenarios;
    }

    public CompleteReportModel getReportModel() {
        return new ReportModelReader(this).readDirectory();
    }

    public void printUsageAndExit() {
        new ConfigOptionParser().printUsageAndExit(this.configOptions);
    }

    public abstract void useConfigMap(Map<String, Object> var1);

    public abstract void additionalConfigOptions(List<ConfigOption> var1);
}

