/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.exception.JGivenInternalDefectException;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportGenerator;
import com.tngtech.jgiven.report.config.ConfigOptionParser;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);

    public void generate(String ... args) {
        Format format = ConfigOptionParser.getFormat(args);
        switch (format) {
            case ASCIIDOC: {
                new AsciiDocReportGenerator().generateFromCommandLine(args);
                break;
            }
            case TEXT: {
                new PlainTextReportGenerator().generateFromCommandLine(args);
                break;
            }
            default: {
                ReportGenerator.generateHtml5Report().generateFromCommandLine(args);
            }
        }
    }

    public static AbstractReportGenerator generateHtml5Report() {
        AbstractReportGenerator report;
        try {
            Class<?> aClass = ReportGenerator.class.getClassLoader().loadClass("com.tngtech.jgiven.report.html5.Html5ReportGenerator");
            report = (AbstractReportGenerator)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JGivenInstallationException("The JGiven HTML5 Report Generator seems not to be on the classpath.\nEnsure that you have a dependency to jgiven-html5-report.");
        }
        catch (Exception e) {
            throw new JGivenInternalDefectException("The HTML5 Report Generator could not be instantiated.", e);
        }
        return report;
    }

    public static void main(String ... args) {
        new ReportGenerator().generate(args);
    }

    public static enum Format {
        HTML("html"),
        TEXT("text"),
        ASCIIDOC("asciidoc"),
        HTML5("html5");

        private final String text;

        private Format(String text) {
            this.text = text;
        }

        public static Format fromStringOrNull(String value) {
            return Arrays.stream(Format.values()).filter(format -> format.text.equalsIgnoreCase(value)).findFirst().orElse(null);
        }
    }
}

