/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.report.model.AttachmentModel;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseArgumentAnalyser {
    private static final Logger log = LoggerFactory.getLogger(CaseArgumentAnalyser.class);

    public void analyze(ReportModel model) {
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            this.analyze(scenarioModel);
        }
    }

    public void analyze(ScenarioModel scenarioModel) {
        if (scenarioModel.getScenarioCases().size() == 1) {
            return;
        }
        if (!this.isStructuralIdentical(scenarioModel)) {
            log.debug("Cases are structurally different, cannot create data table");
            return;
        }
        scenarioModel.setCasesAsTable(true);
        List<List<Word>> argumentWords = this.collectArguments(scenarioModel);
        AssertionUtil.assertFalse(this.argumentCountDiffer(argumentWords), "Argument count differs");
        List<List<Word>> differentArguments = this.getDifferentArguments(argumentWords);
        List<List<JoinedArgs>> joinedArgs = this.joinEqualArguments(differentArguments);
        List<List<String>> explicitParameterValues = this.getExplicitParameterValues(scenarioModel.getScenarioCases());
        List<String> argumentNames = this.findArgumentNames(joinedArgs, explicitParameterValues, scenarioModel.getExplicitParameters());
        List<List<Word>> arguments = this.getFirstWords(joinedArgs);
        this.setParameterNames(joinedArgs, argumentNames);
        scenarioModel.setDerivedParameters(argumentNames);
        for (int caseCounter = 0; caseCounter < arguments.size(); ++caseCounter) {
            scenarioModel.getCase(caseCounter).setDerivedArguments(this.getFormattedValues(arguments.get(caseCounter)));
        }
    }

    private List<List<String>> getExplicitParameterValues(List<ScenarioCaseModel> scenarioCases) {
        ArrayList explicitParameterValues = Lists.newArrayListWithExpectedSize((int)scenarioCases.size());
        for (ScenarioCaseModel caseModel : scenarioCases) {
            explicitParameterValues.add(caseModel.getExplicitArguments());
        }
        return explicitParameterValues;
    }

    private List<String> findArgumentNames(List<List<JoinedArgs>> joinedArgs, List<List<String>> explicitParameterValues, List<String> explicitParameterNames) {
        ArrayList argumentNames = Lists.newArrayListWithExpectedSize((int)joinedArgs.get(0).size());
        TreeMultiset paramNames = TreeMultiset.create();
        block0: for (int argumentCounter = 0; argumentCounter < joinedArgs.get(0).size(); ++argumentCounter) {
            block1: for (int paramCounter = 0; paramCounter < explicitParameterNames.size(); ++paramCounter) {
                String paramName = explicitParameterNames.get(paramCounter);
                boolean formattedValueMatches = true;
                boolean valueMatches = true;
                for (int caseCounter = 0; caseCounter < joinedArgs.size(); ++caseCounter) {
                    String value;
                    JoinedArgs args = joinedArgs.get(caseCounter).get(argumentCounter);
                    String parameterValue = explicitParameterValues.get(caseCounter).get(paramCounter);
                    String formattedValue = args.words.get(0).getFormattedValue();
                    if (!formattedValue.equals(parameterValue)) {
                        formattedValueMatches = false;
                    }
                    if (!(value = args.words.get(0).getValue()).equals(parameterValue)) {
                        valueMatches = false;
                    }
                    if (!formattedValueMatches && !valueMatches) continue block1;
                }
                argumentNames.add(paramName);
                paramNames.add((Object)paramName);
                continue block0;
            }
            argumentNames.add(null);
        }
        HashSet usedNames = Sets.newHashSet();
        for (int argumentCounter = 0; argumentCounter < joinedArgs.get(0).size(); ++argumentCounter) {
            String name = (String)argumentNames.get(argumentCounter);
            if (name == null || paramNames.count((Object)name) > 1) {
                String origName = this.getArgumentName(joinedArgs, argumentCounter);
                name = this.findFreeName(usedNames, origName);
                argumentNames.set(argumentCounter, name);
            }
            usedNames.add(name);
        }
        return argumentNames;
    }

    private String getArgumentName(List<List<JoinedArgs>> joinedArgs, int argumentCounter) {
        return joinedArgs.get((int)0).get((int)argumentCounter).words.get(0).getArgumentInfo().getArgumentName();
    }

    private String findFreeName(Set<String> usedNames, String origName) {
        String name = origName;
        int counter = 2;
        while (usedNames.contains(name)) {
            name = origName + counter;
            ++counter;
        }
        usedNames.add(name);
        return name;
    }

    private List<List<Word>> getFirstWords(List<List<JoinedArgs>> joinedArgs) {
        int i;
        ArrayList result = Lists.newArrayList();
        for (i = 0; i < joinedArgs.size(); ++i) {
            result.add(Lists.newArrayList());
        }
        for (i = 0; i < joinedArgs.size(); ++i) {
            for (int j = 0; j < joinedArgs.get(i).size(); ++j) {
                ((List)result.get(i)).add(joinedArgs.get((int)i).get((int)j).words.get(0));
            }
        }
        return result;
    }

    List<List<JoinedArgs>> joinEqualArguments(List<List<Word>> differentArguments) {
        ArrayList joined = Lists.newArrayList();
        for (int i = 0; i < differentArguments.size(); ++i) {
            joined.add(Lists.newArrayList());
        }
        if (differentArguments.get(0).isEmpty()) {
            return joined;
        }
        for (int caseCounter = 0; caseCounter < differentArguments.size(); ++caseCounter) {
            ((List)joined.get(caseCounter)).add(new JoinedArgs(differentArguments.get(caseCounter).get(0)));
        }
        int numberOfArgs = differentArguments.get(0).size();
        block2: for (int i = 1; i < numberOfArgs; ++i) {
            block3: for (int j = 0; j < ((List)joined.get(0)).size(); ++j) {
                int caseCounter;
                for (caseCounter = 0; caseCounter < differentArguments.size(); ++caseCounter) {
                    Word newWord = differentArguments.get(caseCounter).get(i);
                    Word joinedWord = ((JoinedArgs)((List)joined.get((int)caseCounter)).get((int)j)).words.get(0);
                    if (!newWord.getFormattedValue().equals(joinedWord.getFormattedValue())) continue block3;
                }
                for (caseCounter = 0; caseCounter < differentArguments.size(); ++caseCounter) {
                    ((JoinedArgs)((List)joined.get((int)caseCounter)).get((int)j)).words.add(differentArguments.get(caseCounter).get(i));
                }
                continue block2;
            }
            for (int caseCounter = 0; caseCounter < differentArguments.size(); ++caseCounter) {
                ((List)joined.get(caseCounter)).add(new JoinedArgs(differentArguments.get(caseCounter).get(i)));
            }
        }
        return joined;
    }

    private boolean isStructuralIdentical(ScenarioModel scenarioModel) {
        ScenarioCaseModel firstCase = scenarioModel.getScenarioCases().get(0);
        for (int caseCounter = 1; caseCounter < scenarioModel.getScenarioCases().size(); ++caseCounter) {
            ScenarioCaseModel caseModel = scenarioModel.getScenarioCases().get(caseCounter);
            if (!this.stepsAreDifferent(firstCase, caseModel)) continue;
            return false;
        }
        return true;
    }

    boolean stepsAreDifferent(ScenarioCaseModel firstCase, ScenarioCaseModel secondCase) {
        return this.stepsAreDifferent(firstCase.getSteps(), secondCase.getSteps());
    }

    boolean stepsAreDifferent(List<StepModel> firstSteps, List<StepModel> secondSteps) {
        if (firstSteps.size() != secondSteps.size()) {
            return true;
        }
        for (int stepCounter = 0; stepCounter < firstSteps.size(); ++stepCounter) {
            StepModel firstStep = firstSteps.get(stepCounter);
            StepModel secondStep = secondSteps.get(stepCounter);
            if (firstStep.getWords().size() != secondStep.getWords().size()) {
                return true;
            }
            if (this.attachmentsAreStructurallyDifferent(firstStep.getAttachments(), secondStep.getAttachments())) {
                return true;
            }
            if (this.wordsAreDifferent(firstStep, secondStep)) {
                return true;
            }
            if (!this.stepsAreDifferent(firstStep.getNestedSteps(), secondStep.getNestedSteps())) continue;
            return true;
        }
        return false;
    }

    boolean attachmentsAreStructurallyDifferent(List<AttachmentModel> firstAttachments, List<AttachmentModel> otherAttachments) {
        if (firstAttachments.size() != otherAttachments.size()) {
            return true;
        }
        for (int i = 0; i < firstAttachments.size(); ++i) {
            if (!this.attachmentIsStructurallyDifferent(firstAttachments.get(i), otherAttachments.get(i))) continue;
            return true;
        }
        return false;
    }

    boolean attachmentIsStructurallyDifferent(AttachmentModel firstAttachment, AttachmentModel otherAttachment) {
        if (this.isInlineAttachment(firstAttachment) != this.isInlineAttachment(otherAttachment)) {
            return true;
        }
        if (this.isInlineAttachment(firstAttachment)) {
            return !firstAttachment.getValue().equals(otherAttachment.getValue());
        }
        return false;
    }

    private boolean isInlineAttachment(AttachmentModel attachmentModel) {
        return attachmentModel != null && attachmentModel.isShowDirectly();
    }

    private boolean wordsAreDifferent(StepModel firstStep, StepModel stepModel) {
        for (int wordCounter = 0; wordCounter < firstStep.getWords().size(); ++wordCounter) {
            Word firstWord = firstStep.getWord(wordCounter);
            Word word = stepModel.getWord(wordCounter);
            if (firstWord.isArg() != word.isArg()) {
                return true;
            }
            if (!firstWord.isArg() && !firstWord.getValue().equals(word.getValue())) {
                return true;
            }
            if (!firstWord.isArg() || !firstWord.isDataTable() || firstWord.getArgumentInfo().getDataTable().equals(word.getArgumentInfo().getDataTable())) continue;
            return true;
        }
        return false;
    }

    private void setParameterNames(List<List<JoinedArgs>> differentArguments, List<String> argumentNames) {
        AssertionUtil.assertTrue(argumentNames.size() == differentArguments.get(0).size(), "Number of argument names is wrong");
        for (int argumentCounter = 0; argumentCounter < argumentNames.size(); ++argumentCounter) {
            for (List<JoinedArgs> differentArgument : differentArguments) {
                for (Word word : differentArgument.get((int)argumentCounter).words) {
                    word.getArgumentInfo().setParameterName(argumentNames.get(argumentCounter));
                }
            }
        }
    }

    private List<String> getFormattedValues(List<Word> words) {
        ArrayList formattedValues = Lists.newArrayListWithExpectedSize((int)words.size());
        for (Word word : words) {
            formattedValues.add(word.getFormattedValue());
        }
        return formattedValues;
    }

    List<List<Word>> getDifferentArguments(List<List<Word>> argumentWords) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < argumentWords.size(); ++i) {
            result.add(Lists.newArrayList());
        }
        int numberOfWords = argumentWords.get(0).size();
        for (int wordCounter = 0; wordCounter < numberOfWords; ++wordCounter) {
            int caseCounter;
            Word wordOfFirstCase = argumentWords.get(0).get(wordCounter);
            if (wordOfFirstCase.isDataTable()) continue;
            boolean different = false;
            for (caseCounter = 1; caseCounter < argumentWords.size(); ++caseCounter) {
                Word wordOfCase = argumentWords.get(caseCounter).get(wordCounter);
                if (wordOfCase.getFormattedValue().equals(wordOfFirstCase.getFormattedValue())) continue;
                different = true;
                break;
            }
            if (!different) continue;
            for (caseCounter = 0; caseCounter < argumentWords.size(); ++caseCounter) {
                ((List)result.get(caseCounter)).add(argumentWords.get(caseCounter).get(wordCounter));
            }
        }
        return result;
    }

    List<List<Word>> collectArguments(ScenarioModel scenarioModel) {
        ArrayList argumentWords = Lists.newArrayList();
        for (ScenarioCaseModel scenarioCaseModel : scenarioModel.getScenarioCases()) {
            argumentWords.add(this.findArgumentWords(scenarioCaseModel));
        }
        return argumentWords;
    }

    private boolean argumentCountDiffer(List<List<Word>> argumentWords) {
        int numberOfArguments = argumentWords.get(0).size();
        for (int i = 1; i < argumentWords.size(); ++i) {
            if (argumentWords.get(i).size() == numberOfArguments) continue;
            return true;
        }
        return false;
    }

    private List<Word> findArgumentWords(ScenarioCaseModel scenarioCaseModel) {
        ArrayList arguments = Lists.newArrayList();
        List<StepModel> steps = scenarioCaseModel.getSteps();
        this.findArgumentWords(steps, arguments);
        return arguments;
    }

    private void findArgumentWords(List<StepModel> steps, List<Word> arguments) {
        for (StepModel step : steps) {
            for (Word word : step.getWords()) {
                if (!word.isArg()) continue;
                arguments.add(word);
            }
            this.findArgumentWords(step.getNestedSteps(), arguments);
        }
    }

    static class JoinedArgs {
        final List<Word> words;

        public JoinedArgs(Word word) {
            this.words = Lists.newArrayList((Object[])new Word[]{word});
        }
    }
}

