/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.config;

import com.tngtech.jgiven.report.ReportGenerator;
import com.tngtech.jgiven.report.config.CommandLineOptionBuilder;
import com.tngtech.jgiven.report.config.ConfigOption;
import com.tngtech.jgiven.report.config.ConfigOptionBuilder;
import com.tngtech.jgiven.report.config.converter.ToFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOptionParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigOptionParser.class);
    private static ConfigOption format = new ConfigOptionBuilder("format").setCommandLineOptionWithArgument(new CommandLineOptionBuilder("--format").setArgumentDelimiter("=").setVisualPlaceholder("format").build(), new ToFormat()).setDescription("the format of the report. Either html5, asciidoc or text (default: html5)").setDefaultWith((Object)ReportGenerator.Format.HTML5).build();
    private static ConfigOption help = new ConfigOptionBuilder("help").setCommandLineOptionWithoutArgument(new CommandLineOptionBuilder("--help").setShortPrefix("-h").build(), true).setDescription("print this help message which changes depending on the --format flag").setOptional().build();
    private Map<String, Object> parsedOptions = new HashMap<String, Object>();

    public Object getValue(ConfigOption co) {
        return this.parsedOptions.get(co.getLongName());
    }

    private boolean hasValue(ConfigOption co) {
        return this.parsedOptions.containsKey(co.getLongName());
    }

    public Map<String, Object> generate(List<ConfigOption> configList, String ... args) {
        configList.add(0, format);
        configList.add(1, help);
        for (ConfigOption co : configList) {
            if (!co.hasDefault()) continue;
            this.parsedOptions.put(co.getLongName(), co.getValue());
        }
        for (String arg : args) {
            boolean found = false;
            for (ConfigOption co : configList) {
                found |= this.commandLineLookup(arg, co, configList);
            }
            if (found) continue;
            this.printSuggestion(arg, configList);
        }
        for (ConfigOption co : configList) {
            if (co.isOptional() || this.parsedOptions.containsKey(co.getLongName())) continue;
            System.err.println("Anticipating value for non-optional flag " + co.getCommandLineOption().showFlagInfo());
            this.printUsageAndExit(configList);
        }
        if (this.hasValue(help)) {
            this.printUsageAndExit(configList);
        }
        return this.parsedOptions;
    }

    private boolean commandLineLookup(String arg, ConfigOption co, List<ConfigOption> configList) {
        if (arg.startsWith(co.getCommandLineOption().getLongFlag()) || co.getCommandLineOption().hasShortFlag() && arg.startsWith(co.getCommandLineOption().getShortFlag())) {
            if (co.getCommandLineOption().hasArgument()) {
                Object value;
                String[] formatArgs = arg.split(co.getCommandLineOption().getDelimiter());
                if (formatArgs.length < 2) {
                    System.err.println("Anticipated argument after " + co.getCommandLineOption().showFlagInfo() + ", terminating.");
                    this.printUsageAndExit(configList);
                }
                if ((value = co.toObject(formatArgs[1])) == null) {
                    System.err.println("Parse error for flag " + co.getCommandLineOption().showFlagInfo() + " got " + formatArgs[1]);
                    this.printUsageAndExit(configList);
                }
                log.debug("setting the argument value: " + co.getLongName() + " to " + value);
                this.parsedOptions.put(co.getLongName(), value);
            } else {
                log.debug("setting the default value of " + co.getLongName() + " to " + co.getValue());
                this.parsedOptions.put(co.getLongName(), co.getValue());
            }
            return true;
        }
        return false;
    }

    private void printSuggestion(String arg, List<ConfigOption> co) {
        ArrayList<ConfigOption> sortedList = new ArrayList<ConfigOption>(co);
        Collections.sort(sortedList, new ConfigOptionLevenshteinDistance(arg));
        System.err.println("Parse error for argument \"" + arg + "\", did you mean " + ((ConfigOption)sortedList.get(0)).getCommandLineOption().showFlagInfo() + "? Ignoring for now.");
    }

    public static ReportGenerator.Format getFormat(String ... args) {
        ConfigOptionParser configParser = new ConfigOptionParser();
        List<ConfigOption> configOptions = Arrays.asList(format, help);
        for (ConfigOption co : configOptions) {
            if (!co.hasDefault()) continue;
            configParser.parsedOptions.put(co.getLongName(), co.getValue());
        }
        for (String arg : args) {
            configParser.commandLineLookup(arg, format, configOptions);
        }
        if (!configParser.hasValue(format)) {
            configParser.printUsageAndExit(configOptions);
        }
        return (ReportGenerator.Format)((Object)configParser.getValue(format));
    }

    public void printUsageAndExit(List<ConfigOption> configOptions) {
        System.err.println("Options: ");
        for (ConfigOption co : configOptions) {
            System.err.printf("  %-40s %s\n", co.getCommandLineOption().showFlagInfo(), co.getEnhancedDescription());
        }
        System.exit(1);
    }

    private class ConfigOptionLevenshteinDistance
    implements Comparator<ConfigOption> {
        private String arg;

        ConfigOptionLevenshteinDistance(String arg) {
            this.arg = arg;
        }

        @Override
        public int compare(ConfigOption a, ConfigOption b) {
            double distLongB;
            String[] formatArgsA = this.arg.split(a.getCommandLineOption().getDelimiter());
            String[] formatArgsB = this.arg.split(b.getCommandLineOption().getDelimiter());
            double distLongA = this.distance(a.getCommandLineOption().getLongFlag(), formatArgsA[0]);
            return distLongA < (distLongB = (double)this.distance(b.getCommandLineOption().getLongFlag(), formatArgsB[0])) ? -1 : 1;
        }

        private int distance(String a, String b) {
            int i;
            if (a.equals(b)) {
                return 0;
            }
            if (a.length() == 0) {
                return b.length();
            }
            if (b.length() == 0) {
                return a.length();
            }
            int[] v0 = new int[b.length() + 1];
            int[] v1 = new int[b.length() + 1];
            for (i = 0; i < v0.length; ++i) {
                v0[i] = i;
            }
            for (i = 0; i < a.length(); ++i) {
                v1[0] = i + 1;
                for (int j = 0; j < b.length(); ++j) {
                    int cost = a.charAt(i) == b.charAt(j) ? 0 : 1;
                    v1[j + 1] = Math.min(Math.min(v1[j] + 1, v0[j + 1] + 1), v0[j] + cost);
                }
                System.arraycopy(v1, 0, v0, 0, v0.length);
            }
            return v1[b.length()];
        }
    }
}

