/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.PrintWriterUtil;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.text.PlainTextReportConfig;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import java.io.File;
import java.io.PrintWriter;

public class PlainTextReportGenerator
extends AbstractReportGenerator {
    @Override
    public AbstractReportConfig createReportConfig(String ... args) {
        return new PlainTextReportConfig(args);
    }

    @Override
    public void generate() {
        for (ReportModelFile reportModelFile : this.completeReportModel.getAllReportModels()) {
            this.handleReportModel(reportModelFile.model, reportModelFile.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReportModel(ReportModel model, File file) {
        String targetFileName = Files.getNameWithoutExtension((String)file.getName()) + ".feature";
        PrintWriter printWriter = PrintWriterUtil.getPrintWriter(new File(this.config.getTargetDir(), targetFileName));
        try {
            model.accept(new PlainTextScenarioWriter(printWriter, false));
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }
}

