/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache;

import com.trivago.triava.logging.TriavaLogger;
import com.trivago.triava.logging.TriavaNullLogger;
import com.trivago.triava.tcache.AccessTimeObjectHolder;
import com.trivago.triava.tcache.CacheWriteMode;
import com.trivago.triava.tcache.JamPolicy;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.TCacheHolder;
import com.trivago.triava.tcache.TCacheJSR107;
import com.trivago.triava.tcache.action.ActionContext;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.core.CacheWriterWrapper;
import com.trivago.triava.tcache.core.Holders;
import com.trivago.triava.tcache.core.NopCacheWriter;
import com.trivago.triava.tcache.core.StorageBackend;
import com.trivago.triava.tcache.core.TCacheHolderIterator;
import com.trivago.triava.tcache.core.TriavaCacheConfiguration;
import com.trivago.triava.tcache.event.ListenerCollection;
import com.trivago.triava.tcache.expiry.TCacheExpiryPolicy;
import com.trivago.triava.tcache.expiry.TouchedExpiryPolicy;
import com.trivago.triava.tcache.expiry.UntouchedExpiryPolicy;
import com.trivago.triava.tcache.statistics.HitAndMissDifference;
import com.trivago.triava.tcache.statistics.LongAdderStatisticsCalculator;
import com.trivago.triava.tcache.statistics.NullStatisticsCalculator;
import com.trivago.triava.tcache.statistics.StatisticsCalculator;
import com.trivago.triava.tcache.statistics.TCacheStatistics;
import com.trivago.triava.tcache.statistics.TCacheStatisticsInterface;
import com.trivago.triava.tcache.statistics.TCacheStatisticsMBean;
import com.trivago.triava.tcache.storage.ConcurrentKeyDeserMap;
import com.trivago.triava.tcache.util.CacheSizeInfo;
import com.trivago.triava.tcache.util.ChangeStatus;
import com.trivago.triava.tcache.util.KeyValueUtil;
import com.trivago.triava.tcache.util.ObjectSizeCalculatorInterface;
import com.trivago.triava.tcache.util.TCacheConfigurationMBean;
import com.trivago.triava.time.EstimatorTimeSource;
import com.trivago.triava.time.SystemTimeSource;
import com.trivago.triava.time.TimeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;

public class Cache<K, V>
implements Thread.UncaughtExceptionHandler,
ActionContext<K, V> {
    static long CLEANUP_LOG_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
    static TriavaLogger logger = new TriavaNullLogger();
    private final TCacheFactory factory;
    private final String id;
    final Builder<K, V> builder;
    private final boolean strictJSR107;
    static final long baseTimeMillis = System.currentTimeMillis();
    final TCacheExpiryPolicy expiryPolicy;
    private final long maxCacheTime;
    private final int maxCacheTimeSpread;
    protected final ConcurrentMap<K, AccessTimeObjectHolder<V>> objects;
    final Random random = new Random(System.currentTimeMillis());
    private volatile transient CleanupThread cleaner = null;
    private volatile long cleanUpIntervalMillis;
    StatisticsCalculator statisticsCalculator = null;
    private final float[] hitrateLastMeasurements = new float[5];
    int hitrateLastMeasurementsCurrentIndex = 0;
    private volatile boolean shuttingDown = false;
    protected final JamPolicy jamPolicy;
    protected final CacheLoader<K, V> loader;
    final ListenerCollection<K, V> listeners;
    final TCacheJSR107<K, V> tCacheJSR107;
    final CacheWriter<K, V> cacheWriter;
    final KeyValueUtil<K, V> kvUtil;
    static final long MAX_SHUTDOWN_WAIT_MILLIS = 100L;
    Random randomCacheTime = new Random(System.currentTimeMillis());
    final Object hitRateLock = new Object();
    static final long CACHE_HITRATE_MAX_VALIDITY_MILLIS = 60000L;
    private long cacheHitRatePreviousTimeMillis = System.currentTimeMillis();
    private boolean managementEnabled = false;
    static TimeSource millisEstimator = null;
    static final Object millisEstimatorLock = new Object();

    public Cache(TCacheFactory factory, Builder<K, V> builder) {
        int spreadSeconds;
        this.factory = factory;
        this.id = builder.getId();
        this.strictJSR107 = builder.isStrictJSR107();
        this.kvUtil = new KeyValueUtil(this.id);
        this.builder = builder;
        this.tCacheJSR107 = new TCacheJSR107(this);
        this.maxCacheTime = builder.getMaxCacheTime();
        this.maxCacheTimeSpread = spreadSeconds = (int)Math.min(Integer.MAX_VALUE, builder.getMaxCacheTimeSpread() / 1000L);
        long expiryIdleMillis = builder.getCleanUpIntervalMillis();
        ExpiryPolicy epFromFactory = (ExpiryPolicy)builder.getExpiryPolicyFactory().create();
        if (this.strictJSR107) {
            this.expiryPolicy = new TouchedExpiryPolicy(epFromFactory);
            if (expiryIdleMillis == 0L) {
                expiryIdleMillis = 600000L;
            }
        } else {
            this.expiryPolicy = new UntouchedExpiryPolicy(epFromFactory);
            if (expiryIdleMillis == 0L) {
                Duration expiryDuration = epFromFactory.getExpiryForAccess();
                if (expiryDuration == null) {
                    expiryDuration = epFromFactory.getExpiryForCreation();
                }
                expiryIdleMillis = expiryDuration.getAdjustedTime(0L);
            }
        }
        if (expiryIdleMillis <= 0L) {
            expiryIdleMillis = 600000L;
        }
        this.cleanUpIntervalMillis = expiryIdleMillis > 10L ? Math.min(300000L, expiryIdleMillis / 10L) : 1L;
        this.jamPolicy = builder.getJamPolicy();
        Factory<CacheLoader<K, V>> lf = builder.getCacheLoaderFactory();
        this.loader = lf != null ? (CacheLoader)lf.create() : builder.getLoader();
        if (this.loader == null && builder.isReadThrough()) {
            throw new IllegalArgumentException("Builder has isReadThrough, but has no loader for cache: " + this.id);
        }
        Factory<CacheWriter<K, V>> cwFactory = builder.getCacheWriterFactory();
        if (cwFactory == null) {
            this.cacheWriter = new NopCacheWriter();
        } else {
            CacheWriter cw = (CacheWriter)cwFactory.create();
            CacheWriterWrapper cwWrapper = new CacheWriterWrapper(cw, false);
            this.cacheWriter = cwWrapper;
        }
        this.objects = this.createBackingMap(builder);
        this.enableStatistics(builder.getStatistics());
        this.enableManagement(builder.isManagementEnabled());
        this.activateTimeSource();
        this.listeners = new ListenerCollection<K, V>(this, builder);
        this.tCacheJSR107.refreshActionRunners();
        factory.registerCache(this);
        logger.info(this.toString());
    }

    private ConcurrentMap<K, AccessTimeObjectHolder<V>> createBackingMap(Builder<K, V> builder) {
        StorageBackend<K, V> storageFactory = builder.storageFactory();
        ConcurrentMap<K, TCacheHolder<V>> map = storageFactory.createMap(builder, this.evictionExtraSpace(builder));
        CacheWriteMode cacheWriteMode = builder.getCacheWriteMode();
        if (cacheWriteMode.isStoreByValue()) {
            ConcurrentMap<K, TCacheHolder<V>> castedMap = map;
            return new ConcurrentKeyDeserMap(castedMap, cacheWriteMode);
        }
        ConcurrentMap<K, TCacheHolder<V>> castedMap = map;
        return castedMap;
    }

    protected int evictionExtraSpace(Builder<K, V> builder) {
        return 0;
    }

    public String id() {
        return this.id;
    }

    public TriavaCacheConfiguration<K, V, ? extends Builder<K, V>> configuration() {
        return this.builder;
    }

    public final void close() {
        this.close0(true);
    }

    final void close0(boolean destroyCache) {
        this.shuttingDown = true;
        this.shutdownCustomImpl();
        this.shutdownPrivate();
        if (destroyCache) {
            this.getFactory().destroyCache(this.id);
        }
    }

    void shutdownCustomImpl() {
    }

    public boolean isClosed() {
        return this.shuttingDown;
    }

    private void shutdownPrivate() {
        this.enableStatistics(false);
        this.enableManagement(false);
        this.listeners.shutdown();
        String errorMsg = this.stopAndClear(100L);
        if (errorMsg != null) {
            logger.error("Shutting down Cache " + this.id + " FAILED. Reason: " + errorMsg);
        } else {
            logger.info("Shutting down Cache " + this.id + " OK");
        }
    }

    public boolean joinSimple(Thread thread, long millis, int nanos) {
        long waitUntil = System.currentTimeMillis() + millis;
        boolean interrupted = false;
        while (true) {
            long remainingMillis;
            boolean timeout;
            boolean bl = timeout = (remainingMillis = waitUntil - System.currentTimeMillis()) < 0L || remainingMillis == 0L && nanos == 0;
            if (timeout) break;
            try {
                thread.join(remainingMillis, nanos);
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        boolean stopped = !thread.isAlive();
        return stopped;
    }

    public void put(K key, V value) {
        this.putToMap(key, value, -1L, this.cacheTimeSpread(), false, false);
    }

    public V getAndPut(K key, V value) {
        Holders<V> holders = this.putToMapI(key, value, this.cacheTimeSpread(), false);
        AccessTimeObjectHolder oldHolder = holders != null ? holders.oldHolder : null;
        return oldHolder != null ? (V)oldHolder.peek() : null;
    }

    long cacheTimeSpread() {
        long spread = this.maxCacheTimeSpread == 0 ? this.maxCacheTime : this.maxCacheTime + (long)(1000 * this.randomCacheTime.nextInt(this.maxCacheTimeSpread));
        return spread;
    }

    public void put(K key, V value, int idleTime, int cacheTime, TimeUnit timeUnit) {
        this.putToMap(key, value, timeUnit.toMillis(idleTime), timeUnit.toMillis(cacheTime), false, false);
    }

    public V putIfAbsent(K key, V value, int idleTime, int cacheTime, TimeUnit timeUnit) {
        AccessTimeObjectHolder<V> holder = this.putToMap(key, value, timeUnit.toMillis(idleTime), timeUnit.toMillis(cacheTime), true, false);
        return this.gatedPeek(holder);
    }

    public V putIfAbsent(K key, V value) {
        AccessTimeObjectHolder<V> holder = this.putToMap(key, value, Long.MAX_VALUE, this.cacheTimeSpread(), true, false);
        return this.gatedPeek(holder);
    }

    Holders<V> putIfAbsentH(K key, V value) {
        Holders<V> holders = this.putToMapI(key, value, this.cacheTimeSpread(), true);
        return holders;
    }

    private V gatedPeek(AccessTimeObjectHolder<V> holder) {
        if (holder == null) {
            return null;
        }
        if (holder.isInvalid()) {
            return null;
        }
        return holder.peek();
    }

    protected AccessTimeObjectHolder<V> putToMap(K key, V data, long idleTime, long cacheTime, boolean putIfAbsent, boolean returnEffectiveHolder) {
        Holders<V> holders = this.putToMapI(key, data, cacheTime, putIfAbsent);
        if (holders == null) {
            return null;
        }
        if (holders.effectiveHolder != null) {
            holders.effectiveHolder.updateMaxIdleTime(idleTime);
        }
        AccessTimeObjectHolder holderToReturn = returnEffectiveHolder ? holders.effectiveHolder : holders.oldHolder;
        return this.gatedHolder(holderToReturn);
    }

    protected AccessTimeObjectHolder<V> gatedHolder(AccessTimeObjectHolder<V> holder) {
        if (holder == null) {
            return null;
        }
        return holder.isInvalid() ? null : holder;
    }

    Holders<V> putToMapI(K key, V data, long cacheTime, boolean putIfAbsent) {
        AccessTimeObjectHolder<V> effectiveHolder;
        AccessTimeObjectHolder<V> oldHolder;
        AccessTimeObjectHolder<V> newHolder;
        if (this.isClosed()) {
            if (this.strictJSR107) {
                throw new IllegalStateException("Cache is closed:" + this.id);
            }
            return null;
        }
        this.kvUtil.verifyKeyAndValueNotNull(key, data);
        boolean hasCapacity = this.ensureFreeCapacity();
        if (!hasCapacity) {
            this.statisticsCalculator.incrementDropCount();
            return null;
        }
        if (cacheTime <= 0L) {
            cacheTime = this.maxCacheTime;
        }
        boolean hasPut = false;
        if (putIfAbsent) {
            newHolder = new AccessTimeObjectHolder<V>(data, this.builder.getCacheWriteMode());
            oldHolder = this.objects.putIfAbsent(key, newHolder);
            if (oldHolder != null && oldHolder.isInvalid()) {
                this.expireEntry(key, oldHolder);
                this.objects.put(key, newHolder);
                oldHolder = null;
            }
            if (oldHolder == null) {
                newHolder.complete(this.expiryPolicy.getExpiryForCreation(), cacheTime);
                hasPut = true;
                if (!this.strictJSR107) {
                    this.statisticsCalculator.incrementMissCount();
                }
                effectiveHolder = newHolder;
            } else {
                if (!this.strictJSR107) {
                    this.statisticsCalculator.incrementHitCount();
                }
                oldHolder.incrementUseCount();
                effectiveHolder = oldHolder;
            }
        } else {
            newHolder = new AccessTimeObjectHolder<V>(data, this.builder.getCacheWriteMode());
            oldHolder = this.objects.put(key, newHolder);
            if (oldHolder != null && oldHolder.isInvalid()) {
                this.expireEntry(key, oldHolder);
                oldHolder = null;
            }
            long calculatedIdleTime = newHolder.calculateMaxIdleTimeFromUpdateOrCreation(oldHolder != null, this.expiryPolicy, oldHolder);
            effectiveHolder = newHolder;
            hasPut = true;
            newHolder.complete(calculatedIdleTime, cacheTime);
        }
        AccessTimeObjectHolder<V> gatedEffectiveHolder = this.gatedHolder(effectiveHolder);
        if (gatedEffectiveHolder != null && hasPut) {
            this.statisticsCalculator.incrementPutCount();
        }
        this.ensureCleanerIsRunning();
        return new Holders<V>(this.gatedHolder(newHolder), this.gatedHolder(oldHolder), gatedEffectiveHolder);
    }

    public V getAndReplace(K key, V value) {
        this.kvUtil.verifyKeyAndValueNotNull(key, value);
        AccessTimeObjectHolder<V> newHolder = new AccessTimeObjectHolder<V>(value, Long.MAX_VALUE, this.cacheTimeSpread(), this.builder.getCacheWriteMode());
        AccessTimeObjectHolder<V> oldHolder = this.gatedHolder(this.objects.replace(key, newHolder));
        if (oldHolder != null) {
            V oldValue = oldHolder.peek();
            if (oldValue != null) {
                newHolder.updateMaxIdleTime(this.expiryPolicy.getExpiryForUpdate());
            }
            return oldValue;
        }
        return null;
    }

    public ChangeStatus replace(K key, V oldValue, V newValue) {
        AccessTimeObjectHolder oldHolder = (AccessTimeObjectHolder)this.objects.get(key);
        if (oldHolder == null) {
            return ChangeStatus.UNCHANGED;
        }
        if (!oldValue.equals(oldHolder.peek())) {
            oldHolder.updateMaxIdleTime(this.expiryPolicy.getExpiryForAccess());
            return ChangeStatus.CAS_FAILED_EQUALS;
        }
        AccessTimeObjectHolder<V> newHolder = new AccessTimeObjectHolder<V>(newValue, Long.MAX_VALUE, this.cacheTimeSpread(), this.builder.getCacheWriteMode());
        boolean replaced = this.objects.replace(key, oldHolder, newHolder);
        if (replaced) {
            newHolder.updateMaxIdleTime(this.expiryPolicy.getExpiryForUpdate());
        } else {
            oldHolder.updateMaxIdleTime(this.expiryPolicy.getExpiryForAccess());
        }
        return replaced ? ChangeStatus.CHANGED : ChangeStatus.UNCHANGED;
    }

    protected boolean ensureFreeCapacity() {
        return true;
    }

    private CleanupThread ensureCleanerIsRunning() {
        return this.startCleaner();
    }

    public V get(K key) throws RuntimeException {
        AccessTimeObjectHolder<V> holder = this.getFromMap(key, true);
        return holder == null ? null : (V)holder.get();
    }

    AccessTimeObjectHolder<V> getFromMap(K key) throws RuntimeException {
        return this.getFromMap(key, true);
    }

    AccessTimeObjectHolder<V> getFromMap(K key, boolean touch) throws RuntimeException {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyNotNull(key);
        AccessTimeObjectHolder<Object> holder = (AccessTimeObjectHolder<Object>)this.objects.get(key);
        boolean loaded = false;
        boolean holderWasValidBeforeApplyingExpiryPolicy = AccessTimeObjectHolder.isValid(holder);
        if (holderWasValidBeforeApplyingExpiryPolicy && touch) {
            holder.updateMaxIdleTime(this.expiryPolicy.getExpiryForAccess());
        }
        if (!holderWasValidBeforeApplyingExpiryPolicy && this.builder.isReadThrough()) {
            try {
                Object loadedValue = this.loader.load(key);
                if (loadedValue == null) {
                    return null;
                }
                holder = this.putToMap(key, loadedValue, this.expiryPolicy.getExpiryForCreation(), this.cacheTimeSpread(), false, true);
                loaded = true;
                this.statisticsCalculator.incrementMissCount();
            }
            catch (Exception exc) {
                String message = "CacheLoader " + this.id + " failed to load key=" + key;
                throw new CacheLoaderException(message + " This is a wrapped exception. See https://github.com/jsr107/jsr107tck/issues/99", (Throwable)exc);
            }
        }
        if (holder == null) {
            if (!loaded) {
                this.statisticsCalculator.incrementMissCount();
            }
            return null;
        }
        if (!holderWasValidBeforeApplyingExpiryPolicy && holder.isInvalid()) {
            this.statisticsCalculator.incrementMissCount();
            return null;
        }
        holder.incrementUseCount();
        this.statisticsCalculator.incrementHitCount();
        return holder;
    }

    protected TCacheStatisticsInterface fillCacheStatistics(TCacheStatisticsInterface cacheStatistic) {
        cacheStatistic.setHitCount(this.statisticsCalculator.getHitCount());
        cacheStatistic.setMissCount(this.statisticsCalculator.getMissCount());
        cacheStatistic.setHitRatio(this.getCacheHitrate());
        cacheStatistic.setElementCount(this.objects.size());
        cacheStatistic.setPutCount(this.statisticsCalculator.getPutCount());
        cacheStatistic.setRemoveCount(this.statisticsCalculator.getRemoveCount());
        cacheStatistic.setDropCount(this.statisticsCalculator.getDropCount());
        return cacheStatistic;
    }

    public TCacheStatistics statistics() {
        TCacheStatistics stats = new TCacheStatistics(this.id());
        this.fillCacheStatistics(stats);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCacheHitrate() {
        long now = System.currentTimeMillis();
        Object object = this.hitRateLock;
        synchronized (object) {
            if (now > this.cacheHitRatePreviousTimeMillis + 60000L) {
                float hitRate;
                this.cacheHitRatePreviousTimeMillis = now;
                HitAndMissDifference stats = this.statisticsCalculator.tick();
                long cacheGets = stats.getHits() + stats.getMisses();
                this.hitrateLastMeasurements[this.hitrateLastMeasurementsCurrentIndex] = hitRate = cacheGets == 0L ? 0.0f : (float)stats.getHits() / (float)cacheGets * 100.0f;
                this.hitrateLastMeasurementsCurrentIndex = (this.hitrateLastMeasurementsCurrentIndex + 1) % this.hitrateLastMeasurements.length;
            }
        }
        return this.calculateAverageHitrate();
    }

    private float calculateAverageHitrate() {
        float averageHitrate = 0.0f;
        for (int i = 0; i < this.hitrateLastMeasurements.length; ++i) {
            averageHitrate += this.hitrateLastMeasurements[i];
        }
        return averageHitrate /= (float)this.hitrateLastMeasurements.length;
    }

    public void clear() {
        this.stopAndClear(0L);
    }

    protected String stopAndClear(long millis) {
        String errorMsg = this.stopCleaner(millis);
        this.objects.clear();
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CleanupThread startCleaner() {
        CleanupThread cleanerRef = this.cleaner;
        if (cleanerRef != null) {
            return cleanerRef;
        }
        Cache cache = this;
        synchronized (cache) {
            if (this.cleaner == null) {
                cleanerRef = new CleanupThread(this.id);
                cleanerRef.setPriority(10);
                cleanerRef.setDaemon(true);
                cleanerRef.setUncaughtExceptionHandler(this);
                this.cleaner = cleanerRef;
                cleanerRef.start();
            }
        }
        logger.info(this.id + " expiration started, cleanupInterval=" + this.cleanUpIntervalMillis + "ms");
        return cleanerRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeSource activateTimeSource() {
        Object object = millisEstimatorLock;
        synchronized (object) {
            if (millisEstimator == null) {
                millisEstimator = new EstimatorTimeSource(new SystemTimeSource(), 10, logger);
            }
        }
        return millisEstimator;
    }

    private void stopCleaner() {
        this.stopCleaner(0L);
    }

    private synchronized String stopCleaner(long millis) {
        String errorMsg = null;
        CleanupThread cleanerRef = this.cleaner;
        if (cleanerRef != null) {
            cleanerRef.cancel();
            if (millis > 0L && !this.joinSimple(cleanerRef, millis, 0)) {
                errorMsg = "Shutting down Cleaner Thread FAILED";
            }
        }
        this.cleaner = null;
        return errorMsg;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.error("CleanupThread Thread " + thread + " died because uncatched Exception", throwable);
        this.cleaner = null;
    }

    private int cleanUp() {
        boolean expiryNotification = this.listeners.hasListenerFor(EventType.EXPIRED);
        HashMap evictedElements = expiryNotification ? new HashMap() : null;
        int removedEntries = 0;
        Iterator iter = this.objects.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            AccessTimeObjectHolder holder = (AccessTimeObjectHolder)entry.getValue();
            if (!holder.isInvalid()) continue;
            iter.remove();
            Object value = holder.peek();
            boolean removed = holder.release();
            if (!removed) continue;
            ++removedEntries;
            if (evictedElements == null) continue;
            evictedElements.put(entry.getKey(), value);
        }
        if (evictedElements != null) {
            this.listeners.dispatchEvents(evictedElements, EventType.EXPIRED, true);
        }
        if (this.objects.isEmpty()) {
            this.stopCleaner();
        }
        return removedEntries;
    }

    public int size() {
        return this.objects.size();
    }

    public boolean remove(K key, V value) {
        this.kvUtil.verifyKeyAndValueNotNull(key, value);
        AccessTimeObjectHolder holder = (AccessTimeObjectHolder)this.objects.get(key);
        if (holder == null) {
            return false;
        }
        Object holderValue = holder.peek();
        if (!holderValue.equals(value)) {
            return false;
        }
        AccessTimeObjectHolder<V> gh = this.gatedHolder(holder);
        boolean validBeforeInvalidate = gh != null;
        boolean removed = this.objects.remove(key, holder);
        this.releaseHolder(holder);
        return validBeforeInvalidate ? removed : false;
    }

    public V remove(K key) {
        this.kvUtil.verifyKeyNotNull(key);
        AccessTimeObjectHolder oldHolder = (AccessTimeObjectHolder)this.objects.remove(key);
        AccessTimeObjectHolder<V> gh = this.gatedHolder(oldHolder);
        boolean validBeforeInvalidate = gh != null;
        V releasedValue = this.releaseHolder(oldHolder);
        return (V)(validBeforeInvalidate ? releasedValue : null);
    }

    protected V removeAndRelease(K key) {
        AccessTimeObjectHolder oldHolder = (AccessTimeObjectHolder)this.objects.remove(key);
        return this.releaseHolder(oldHolder);
    }

    public void expireUntil(K key, int maxDelay, TimeUnit timeUnit) {
        AccessTimeObjectHolder holder = (AccessTimeObjectHolder)this.objects.get(key);
        if (holder == null) {
            return;
        }
        if (maxDelay < 0) {
            throw new IllegalArgumentException(String.format("maxDelay value must be >= 0. Passed in value was: [%d]", maxDelay));
        }
        holder.setExpireUntil(maxDelay, timeUnit, this.random);
    }

    V releaseHolder(AccessTimeObjectHolder<V> holder) {
        if (holder == null) {
            return null;
        }
        V oldData = holder.peek();
        boolean released = holder.release();
        if (released) {
            return oldData;
        }
        return null;
    }

    public TCacheHolderIterator<K, V> iterator() {
        this.throwISEwhenClosed();
        return new TCacheHolderIterator<K, V>(this, this.objects, this.expiryPolicy, false);
    }

    public TCacheHolderIterator<K, V> iteratorWithTouch() {
        this.throwISEwhenClosed();
        return new TCacheHolderIterator<K, V>(this, this.objects, this.expiryPolicy, true);
    }

    public Collection<K> keySet() {
        return Collections.unmodifiableCollection(this.objects.keySet());
    }

    public boolean containsKey(K key) {
        this.kvUtil.verifyKeyNotNull(key);
        return this.gatedHolder((AccessTimeObjectHolder)this.objects.get(key)) != null;
    }

    V peek(K key) {
        this.kvUtil.verifyKeyNotNull(key);
        AccessTimeObjectHolder<V> holder = this.gatedHolder((AccessTimeObjectHolder)this.objects.get(key));
        return holder == null ? null : (V)holder.peek();
    }

    AccessTimeObjectHolder<V> peekHolder(K key) {
        this.kvUtil.verifyKeyNotNull(key);
        return this.gatedHolder((AccessTimeObjectHolder)this.objects.get(key));
    }

    public static void setLogger(TriavaLogger logger) {
        Cache.logger = logger;
    }

    public CacheSizeInfo reportSize(ObjectSizeCalculatorInterface objectSizeCalculator) {
        int elemsBefore = this.objects.size();
        long sizeInByte = objectSizeCalculator.calculateObjectSizeDeep(this.objects);
        int elemsAfter = this.objects.size();
        CacheSizeInfo cacheSizeInfo = new CacheSizeInfo(this.id, elemsBefore, sizeInByte, elemsAfter);
        logger.info(cacheSizeInfo.toString());
        return cacheSizeInfo;
    }

    public TCacheJSR107<K, V> jsr107cache() {
        return this.tCacheJSR107;
    }

    public void enableStatistics(boolean enable) {
        boolean currentlyEnabled = this.isStatisticsEnabled();
        if (enable) {
            if (currentlyEnabled) {
                return;
            }
            this.statisticsCalculator = new LongAdderStatisticsCalculator();
            TCacheStatisticsMBean.instance().register(this);
            this.jsr107cache().refreshActionRunners();
        } else {
            this.statisticsCalculator = new NullStatisticsCalculator();
            TCacheStatisticsMBean.instance().unregister(this);
            this.jsr107cache().refreshActionRunners();
        }
    }

    public void enableManagement(boolean enable) {
        if (enable) {
            TCacheConfigurationMBean.instance().register(this);
        } else {
            TCacheConfigurationMBean.instance().unregister(this);
        }
        this.managementEnabled = enable;
    }

    public boolean isStatisticsEnabled() {
        boolean currentlyEnabled = this.statisticsCalculator != null && !(this.statisticsCalculator instanceof NullStatisticsCalculator);
        return currentlyEnabled;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    private void throwISEwhenClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache already closed: " + this.id());
        }
    }

    @Override
    public CacheWriter<K, V> cacheWriter() {
        return this.cacheWriter;
    }

    @Override
    public ListenerCollection<K, V> listeners() {
        return this.listeners;
    }

    @Override
    public StatisticsCalculator statisticsCalculator() {
        return this.statisticsCalculator;
    }

    boolean expireEntry(K key, AccessTimeObjectHolder<V> holder) {
        V value = holder.peek();
        boolean removed = holder.release();
        if (removed) {
            this.listeners.dispatchEvent(EventType.EXPIRED, key, value);
        }
        return removed;
    }

    public String toString() {
        return "TriavaCache [" + this.configToString() + "]";
    }

    protected String configToString() {
        return "id=" + this.id + ", storeClass=" + this.objects.getClass().getName() + ", storeMode=" + (Object)((Object)this.builder.getCacheWriteMode()) + ", maxCacheTime=" + this.maxCacheTime + "ms, maxCacheTimeSpread=" + this.maxCacheTimeSpread * 1000 + "ms, expiryPolicyType=" + this.expiryPolicy.getClass().getName() + ", expirationInterval=" + this.cleanUpIntervalMillis + "ms, jamPolicy=" + (Object)((Object)this.jamPolicy) + ", hasLoader=" + (this.loader != null) + ", hasWriter=" + !(this.cacheWriter instanceof NopCacheWriter) + ", listeners=" + this.listeners.size() + ", managementEnabled=" + this.isManagementEnabled() + ", statisticsEnabled=" + this.isStatisticsEnabled();
    }

    TCacheFactory getFactory() {
        return this.factory;
    }

    public class CleanupThread
    extends Thread {
        private volatile boolean running;
        private int removedEntries;
        private long nextLogTimeMillis;

        CleanupThread(String cacheName) {
            super("CacheCleanupThread-" + cacheName);
            this.removedEntries = 0;
            this.nextLogTimeMillis = System.currentTimeMillis() + CLEANUP_LOG_INTERVAL;
        }

        @Override
        public void run() {
            logger.info("CleanupThread " + this.getName() + " has entered run()");
            this.running = true;
            while (this.running) {
                try {
                    long now;
                    CleanupThread.sleep(Cache.this.cleanUpIntervalMillis);
                    this.removedEntries += Cache.this.cleanUp();
                    if (this.removedEntries != 0 && (now = millisEstimator.millis()) > this.nextLogTimeMillis) {
                        logger.info(Cache.this.id() + " Cache has expired objects from Cache, count=" + this.removedEntries);
                        this.removedEntries = 0;
                        this.nextLogTimeMillis = now + CLEANUP_LOG_INTERVAL;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                catch (InterruptedException ex) {
                    logger.info("CleanupThread interrupted, keep running =" + this.running);
                }
            }
            logger.info("CleanupThread " + this.getName() + " is leaving run()");
        }

        public void cancel() {
            this.running = false;
            this.interrupt();
        }
    }
}

