/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache;

import com.trivago.triava.tcache.AccessTimeObjectHolder;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.action.ActionRunner;
import com.trivago.triava.tcache.action.DeleteAction;
import com.trivago.triava.tcache.action.DeleteOnValueAction;
import com.trivago.triava.tcache.action.GetAndPutAction;
import com.trivago.triava.tcache.action.GetAndRemoveAction;
import com.trivago.triava.tcache.action.PutAction;
import com.trivago.triava.tcache.action.ReplaceAction;
import com.trivago.triava.tcache.action.WriteBehindActionRunner;
import com.trivago.triava.tcache.action.WriteThroughActionRunner;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.core.Holders;
import com.trivago.triava.tcache.core.NopCacheWriter;
import com.trivago.triava.tcache.core.TCacheConfigurationBean;
import com.trivago.triava.tcache.core.TCacheEntryIterator;
import com.trivago.triava.tcache.core.TCacheJSR107Entry;
import com.trivago.triava.tcache.core.TCacheJSR107MutableEntry;
import com.trivago.triava.tcache.event.ListenerCollection;
import com.trivago.triava.tcache.statistics.TCacheStatisticsBean;
import com.trivago.triava.tcache.util.ChangeStatus;
import com.trivago.triava.tcache.util.KeyValueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.event.EventType;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class TCacheJSR107<K, V>
implements javax.cache.Cache<K, V> {
    final Cache<K, V> tcache;
    final TCacheConfigurationBean<K, V> configurationBean;
    final KeyValueUtil<K, V> kvUtil;
    volatile ActionRunner<K, V> actionRunner;
    volatile ActionRunner<K, V> actionRunnerWriteBehind;

    TCacheJSR107(Cache<K, V> tcache) {
        this.tcache = tcache;
        this.configurationBean = new TCacheConfigurationBean<K, V>(tcache);
        this.kvUtil = new KeyValueUtil(tcache.id());
        this.refreshActionRunners();
    }

    void refreshActionRunners() {
        this.actionRunner = new WriteThroughActionRunner<K, V>(this.tcache);
        this.actionRunnerWriteBehind = new WriteBehindActionRunner<K, V>(this.tcache);
    }

    public void clear() {
        this.throwISEwhenClosed();
        this.tcache.clear();
    }

    public void close() {
        this.tcache.close();
    }

    public boolean containsKey(K key) {
        this.throwISEwhenClosed();
        return this.tcache.containsKey(key);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.throwISEwhenClosed();
        this.tcache.listeners.deregisterCacheEntryListener(listenerConfiguration);
        this.refreshActionRunners();
    }

    public V get(K key) {
        this.throwISEwhenClosed();
        return this.tcache.get(key);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.throwISEwhenClosed();
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.tcache.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public V getAndPut(K key, V value) {
        this.throwISEwhenClosed();
        GetAndPutAction action = new GetAndPutAction(key, value, null);
        V result = null;
        if (this.actionRunnerWriteBehind.preMutate(action)) {
            Holders<V> holders = this.tcache.putToMapI(key, value, this.tcache.cacheTimeSpread(), false);
            ChangeStatus changeStatus = null;
            if (holders != null) {
                if (holders.oldHolder != null) {
                    action.setEventType(EventType.UPDATED);
                    result = holders.oldHolder.peek();
                    changeStatus = ChangeStatus.CHANGED;
                } else if (holders.newHolder != null) {
                    changeStatus = ChangeStatus.CREATED;
                    action.setEventType(EventType.CREATED);
                }
            }
            this.actionRunnerWriteBehind.postMutate(action, (Object)changeStatus);
        }
        action.close();
        return result;
    }

    public V getAndRemove(K key) {
        this.throwISEwhenClosed();
        GetAndRemoveAction action = new GetAndRemoveAction(key);
        if (this.actionRunner.preMutate(action)) {
            V oldValue = this.tcache.remove(key);
            action.setRemoved(oldValue != null);
            this.actionRunner.postMutate(action, oldValue);
            return oldValue;
        }
        return null;
    }

    public V getAndReplace(K key, V value) {
        this.throwISEwhenClosed();
        ReplaceAction action = new ReplaceAction(key, value, EventType.UPDATED);
        V oldValue = null;
        if (this.actionRunnerWriteBehind.preMutate(action)) {
            oldValue = this.tcache.getAndReplace(key, value);
            boolean replaced = oldValue != null;
            ChangeStatus changeStatus = replaced ? ChangeStatus.CHANGED : ChangeStatus.UNCHANGED;
            this.actionRunnerWriteBehind.postMutate(action, (Object)changeStatus);
        }
        action.close();
        return oldValue;
    }

    public CacheManager getCacheManager() {
        return this.tcache.getFactory();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        Builder builder = this.tcache.builder;
        if (clazz.isAssignableFrom(Configuration.class)) {
            return (C)builder;
        }
        if (clazz.isAssignableFrom(CompleteConfiguration.class)) {
            return (C)builder;
        }
        throw new IllegalArgumentException("Unsupported configuration class: " + clazz.toString());
    }

    public String getName() {
        return this.tcache.id();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        this.throwISEwhenClosed();
        if (entryProcessor == null) {
            throw new NullPointerException("entryProcessor is null");
        }
        TCacheJSR107MutableEntry<K, V> me = this.invokeBuildMutableEntry(key);
        try {
            T result = this.processEntryProcessor(entryProcessor, me, args);
            return result;
        }
        catch (EntryProcessorException epe) {
            throw epe;
        }
        catch (Exception exc) {
            throw new EntryProcessorException((Throwable)exc);
        }
    }

    private TCacheJSR107MutableEntry<K, V> invokeBuildMutableEntry(K key) {
        Object value;
        AccessTimeObjectHolder<V> holder = this.tcache.peekHolder(key);
        Object v = value = holder != null ? (Object)holder.peek() : null;
        if (value != null) {
            this.tcache.statisticsCalculator.incrementHitCount();
        } else {
            this.tcache.statisticsCalculator.incrementMissCount();
        }
        CacheLoader loader = this.tcache.builder.isReadThrough() ? this.tcache.loader : null;
        TCacheJSR107MutableEntry<K, Object> me = new TCacheJSR107MutableEntry<K, Object>(key, value, loader);
        return me;
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        this.throwISEwhenClosed();
        if (entryProcessor == null) {
            throw new NullPointerException("entryProcessor is null");
        }
        HashMap resultMap = new HashMap();
        for (K key : keys) {
            try {
                TCacheJSR107MutableEntry<K, V> me = this.invokeBuildMutableEntry(key);
                T result = this.processEntryProcessor(entryProcessor, me, args);
                if (result == null) continue;
                resultMap.put(key, new EntryProcessorResultTCache<T>(result));
            }
            catch (Exception exc) {
                resultMap.put(key, new EntryProcessorResultTCache(exc));
            }
        }
        return resultMap;
    }

    private <T> T processEntryProcessor(EntryProcessor<K, V, T> entryProcessor, TCacheJSR107MutableEntry<K, V> me, Object ... args) {
        Object result = entryProcessor.process(me, args);
        switch (me.operation()) {
            case REMOVE: {
                Object key = me.getKey();
                this.remove(key);
                break;
            }
            case SET: {
                Object key = me.getKey();
                V value = me.getValue();
                this.put(key, value);
                break;
            }
            case LOAD: {
                Object key = me.getKey();
                V value = me.getValue();
                this.putNoWriteThrough(key, value);
                break;
            }
            case REMOVE_WRITE_THROUGH: {
                Object key = me.getKey();
                this.remove(key, (V)false);
                break;
            }
            case GET: {
                Object key = me.getKey();
                AccessTimeObjectHolder<V> holder = this.tcache.peekHolder(key);
                if (holder == null) break;
                holder.updateMaxIdleTime(this.tcache.expiryPolicy.getExpiryForAccess());
                break;
            }
        }
        return (T)result;
    }

    public boolean isClosed() {
        return this.tcache.isClosed();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.throwISEwhenClosed();
        TCacheEntryIterator<K, V> it = new TCacheEntryIterator<K, V>(this.tcache, this.tcache.objects, this.tcache.expiryPolicy);
        return it;
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        block13: {
            this.throwISEwhenClosed();
            for (K key : keys) {
                this.kvUtil.verifyKeyNotNull(key);
            }
            CacheLoader loader = this.tcache.loader;
            if (loader == null) {
                if (listener != null) {
                    listener.onException((Exception)new CacheException("Cache does not support loadAll as no CacheLoader is defined: " + this.getName()));
                }
                return;
            }
            try {
                Map loadedEntries = null;
                try {
                    if (replaceExistingValues) {
                        loadedEntries = loader.loadAll(keys);
                    } else {
                        HashSet<K> finalKeys = new HashSet<K>();
                        for (K k : keys) {
                            if (this.containsKey(k)) continue;
                            finalKeys.add(k);
                        }
                        loadedEntries = loader.loadAll(finalKeys);
                    }
                }
                catch (Exception exc) {
                    String message = "CacheLoader " + this.tcache.id() + " failed to load keys";
                    throw new CacheLoaderException(message + " This is a wrapped exception. See https://github.com/jsr107/jsr107tck/issues/99", (Throwable)exc);
                }
                if (loadedEntries != null) {
                    HashMap cleanedEntries = new HashMap(2 * loadedEntries.size());
                    for (Map.Entry entry : loadedEntries.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key == null || value == null) continue;
                        cleanedEntries.put(key, value);
                    }
                    this.putAll(cleanedEntries, false);
                }
                if (listener != null) {
                    listener.onCompletion();
                }
            }
            catch (Exception exc) {
                if (listener == null) break block13;
                listener.onException(exc);
            }
        }
    }

    void putNoWriteThrough(K key, V value) {
        this.put0(key, value, false);
    }

    public void put(K key, V value) {
        this.put0(key, value, true);
    }

    void put0(K key, V value, boolean writeThrough) {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyAndValueNotNull(key, value);
        PutAction action = new PutAction(key, value, EventType.CREATED, false, writeThrough);
        if (this.actionRunner.preMutate(action)) {
            Holders<V> holders = this.tcache.putToMapI(key, value, this.tcache.cacheTimeSpread(), false);
            EventType eventType = holders == null ? null : (holders.newHolder == null || holders.newHolder.isInvalid() ? null : (holders.oldHolder == null ? EventType.CREATED : EventType.UPDATED));
            action.setEventType(eventType);
            this.actionRunner.postMutate(action);
        }
        action.close();
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.putAll(entries, true);
    }

    private void putAll(Map<? extends K, ? extends V> entries, boolean callWriter) {
        Object key;
        Map<K, V> finalEntries;
        boolean anyListenerInterested;
        ListenerCollection listeners;
        this.throwISEwhenClosed();
        if (entries.isEmpty()) {
            return;
        }
        this.verifyEntriesNotNull(entries);
        CacheWriterException cacheWriterException = null;
        ArrayList<TCacheJSR107Entry<K, V>> writerEntries = null;
        CacheWriter writer = this.tcache.cacheWriter;
        if (writer == null || writer instanceof NopCacheWriter) {
            callWriter = false;
        }
        if (callWriter) {
            try {
                writerEntries = new ArrayList<TCacheJSR107Entry<K, V>>(entries.size());
                for (Map.Entry<K, V> entry : entries.entrySet()) {
                    K key2 = entry.getKey();
                    V value = entry.getValue();
                    writerEntries.add(new TCacheJSR107Entry<K, V>(key2, value));
                }
                writer.writeAll(writerEntries);
            }
            catch (Exception exc) {
                cacheWriterException = new CacheWriterException((Throwable)exc);
            }
        }
        HashMap<K, V> createdEntries = (listeners = this.tcache.listeners).hasListenerFor(EventType.CREATED) ? new HashMap<K, V>() : null;
        HashMap updatedEntries = listeners.hasListenerFor(EventType.UPDATED) ? new HashMap() : null;
        boolean bl = anyListenerInterested = createdEntries != null || updatedEntries != null;
        if (writerEntries != null) {
            finalEntries = new HashMap<K, V>(entries);
            for (Cache.Entry entry : writerEntries) {
                key = entry.getKey();
                if (!finalEntries.containsKey(key)) continue;
                finalEntries.remove(key);
            }
        } else {
            finalEntries = entries;
        }
        for (Map.Entry<K, V> entry : finalEntries.entrySet()) {
            HashMap<K, V> mapToAdd;
            boolean added;
            key = entry.getKey();
            V value = entry.getValue();
            Holders<V> holders = this.tcache.putToMapI(key, value, this.tcache.cacheTimeSpread(), false);
            if (!anyListenerInterested || !(added = holders.newHolder != null) || (mapToAdd = holders.oldHolder == null ? createdEntries : updatedEntries) == null) continue;
            mapToAdd.put(key, value);
        }
        if (createdEntries != null) {
            this.tcache.listeners.dispatchEvents(createdEntries, EventType.CREATED, false);
        }
        if (updatedEntries != null) {
            this.tcache.listeners.dispatchEvents(updatedEntries, EventType.UPDATED, false);
        }
        if (cacheWriterException != null) {
            throw cacheWriterException;
        }
    }

    private void verifyEntriesNotNull(Map<? extends K, ? extends V> entries) {
        for (Map.Entry<K, V> entry : entries.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.kvUtil.verifyKeyAndValueNotNull(key, value);
        }
    }

    private void verifyKeysNotNull(Set<? extends K> keys) {
        for (K key : keys) {
            this.kvUtil.verifyKeyNotNull(key);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        this.throwISEwhenClosed();
        PutAction action = new PutAction(key, value, EventType.CREATED, false);
        boolean added = false;
        if (this.actionRunnerWriteBehind.preMutate(action)) {
            Holders<V> holders = this.tcache.putIfAbsentH(key, value);
            boolean bl = added = holders.oldHolder == null && holders.newHolder != null;
            if (added) {
                this.actionRunnerWriteBehind.postMutate(action);
            }
        }
        return added;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.throwISEwhenClosed();
        this.tcache.listeners.registerCacheEntryListener(listenerConfiguration);
        this.refreshActionRunners();
    }

    private void throwISEwhenClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache already closed: " + this.tcache.id());
        }
    }

    public boolean remove(K key) {
        return this.remove(key, (V)true);
    }

    boolean remove(K key, boolean mutateLocal) {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyNotNull(key);
        return this.removeInternal(key, null, mutateLocal);
    }

    public boolean remove(K key, V value) {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyAndValueNotNull(key, value);
        return this.removeInternal(key, value, true);
    }

    boolean removeInternal(K key, V value, boolean mutateLocal) {
        DeleteAction action;
        boolean twoArgRemove;
        boolean bl = twoArgRemove = value != null;
        if (twoArgRemove) {
            AccessTimeObjectHolder<V> holder = this.tcache.peekHolder(key);
            Object valueInCache = holder != null ? holder.peek() : null;
            boolean mustWriteThrough = value.equals(valueInCache);
            action = new DeleteOnValueAction(key, mustWriteThrough);
            if (valueInCache != null && !mustWriteThrough) {
                holder.updateMaxIdleTime(this.tcache.expiryPolicy.getExpiryForAccess());
            }
        } else {
            action = new DeleteAction(key);
        }
        boolean removed = false;
        if (this.actionRunner.preMutate(action)) {
            if (mutateLocal) {
                if (value == null) {
                    V oldValue = this.tcache.remove(key);
                    removed = oldValue != null;
                    action.setRemoved(removed);
                    this.actionRunner.postMutate(action, oldValue);
                } else {
                    removed = this.tcache.remove(key, value);
                    action.setRemoved(removed);
                    this.actionRunner.postMutate(action, value);
                }
            } else if (this.actionRunner instanceof WriteBehindActionRunner) {
                action.setRemoved(removed);
                action.writeThrough(this.actionRunner, null);
            }
        }
        action.close();
        return removed;
    }

    public void removeAll() {
        this.throwISEwhenClosed();
        this.removeAll(this.tcache.objects.keySet());
    }

    public void removeAll(Set<? extends K> keys) {
        this.throwISEwhenClosed();
        if (keys.isEmpty()) {
            return;
        }
        this.verifyKeysNotNull(keys);
        CacheWriterException cacheWriterException = null;
        HashSet<K> keysFromCacheWriter = null;
        CacheWriter writer = this.tcache.cacheWriter;
        boolean callWriter = !(writer instanceof NopCacheWriter);
        try {
            if (callWriter) {
                keysFromCacheWriter = new HashSet<K>(keys);
                writer.deleteAll(keysFromCacheWriter);
            }
        }
        catch (Exception exc) {
            cacheWriterException = new CacheWriterException((Throwable)exc);
        }
        for (K key : keys) {
            V oldValue;
            boolean removed;
            if (keysFromCacheWriter != null && keysFromCacheWriter.contains(key) || !(removed = (oldValue = this.tcache.remove(key)) != null)) continue;
            this.tcache.statisticsCalculator.incrementRemoveCount();
            this.tcache.listeners.dispatchEvent(EventType.REMOVED, key, null, oldValue);
        }
        if (cacheWriterException != null) {
            throw cacheWriterException;
        }
    }

    public boolean replace(K key, V value) {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyAndValueNotNull(key, value);
        V oldHolder = this.getAndReplace(key, value);
        boolean replaced = oldHolder != null;
        return replaced;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.throwISEwhenClosed();
        this.kvUtil.verifyKeyAndValueNotNull(key, newValue);
        this.kvUtil.verifyValueNotNull(oldValue);
        boolean replaced = false;
        ReplaceAction action = new ReplaceAction(key, newValue, EventType.UPDATED);
        if (this.actionRunnerWriteBehind.preMutate(action)) {
            ChangeStatus changeStatus = this.tcache.replace(key, oldValue, newValue);
            this.actionRunnerWriteBehind.postMutate(action, (Object)changeStatus);
            replaced = changeStatus == ChangeStatus.CHANGED;
        }
        return replaced;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isAssignableFrom(Cache.class) && !clazz.isAssignableFrom(TCacheJSR107.class)) {
            throw new IllegalArgumentException("Cannot unwrap Cache to unsupported Class " + clazz);
        }
        Cache<K, V> cacheCasted = this.tcache;
        return (T)cacheCasted;
    }

    public Object getCacheConfigMBean() {
        return this.configurationBean;
    }

    public Object getCacheStatisticsMBean() {
        return new TCacheStatisticsBean(this.tcache, this.tcache.statisticsCalculator, TCacheStatisticsBean.StatisticsAveragingMode.JSR107);
    }

    private static class EntryProcessorResultTCache<T>
    implements EntryProcessorResult<T> {
        Object result;

        EntryProcessorResultTCache(T result) {
            this.result = result;
        }

        EntryProcessorResultTCache(Exception exc) {
            this.result = exc instanceof EntryProcessorException ? exc : new EntryProcessorException((Throwable)exc);
        }

        public T get() throws EntryProcessorException {
            if (this.result instanceof EntryProcessorException) {
                throw (EntryProcessorException)this.result;
            }
            Object ret = this.result;
            return (T)ret;
        }
    }
}

