/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.action;

import com.trivago.triava.tcache.action.ActionRunner;
import com.trivago.triava.tcache.action.PutAction;
import com.trivago.triava.tcache.statistics.StatisticsCalculator;
import com.trivago.triava.tcache.util.ChangeStatus;
import javax.cache.event.EventType;

public class ReplaceAction<K, V, W>
extends PutAction<K, V, W> {
    public ReplaceAction(K key, V value, EventType eventType) {
        super(key, value, eventType, true);
    }

    @Override
    W writeThroughImpl(ActionRunner<K, V> actionRunner, Object arg) {
        ChangeStatus changeStatus = (ChangeStatus)((Object)arg);
        if (changeStatus == ChangeStatus.CHANGED) {
            return super.writeThroughImpl(actionRunner, arg);
        }
        return null;
    }

    @Override
    void statisticsImpl(ActionRunner<K, V> actionRunner, Object arg) {
        StatisticsCalculator stats = actionRunner.stats;
        ChangeStatus changeStatus = (ChangeStatus)((Object)arg);
        switch (changeStatus) {
            case CHANGED: {
                stats.incrementHitCount();
                stats.incrementPutCount();
                break;
            }
            case UNCHANGED: {
                stats.incrementMissCount();
                break;
            }
            case CREATED: {
                stats.incrementMissCount();
                break;
            }
            case CAS_FAILED_EQUALS: {
                stats.incrementHitCount();
            }
        }
    }
}

