/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.core;

import com.trivago.triava.tcache.AccessTimeObjectHolder;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.core.TCacheJSR107Entry;
import com.trivago.triava.tcache.expiry.TCacheExpiryPolicy;
import com.trivago.triava.tcache.statistics.StatisticsCalculator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;

public class TCacheEntryIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private final Iterator<Map.Entry<K, AccessTimeObjectHolder<V>>> mapIterator;
    Cache.Entry<K, V> currentElement = null;
    Map.Entry<K, AccessTimeObjectHolder<V>> nextElement = null;
    final javax.cache.Cache<K, V> cache;
    final StatisticsCalculator statisticsCalculator;
    final TCacheExpiryPolicy expiryPolicy;

    public TCacheEntryIterator(Cache<K, V> tcache, ConcurrentMap<K, AccessTimeObjectHolder<V>> objects, TCacheExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
        this.mapIterator = objects.entrySet().iterator();
        this.statisticsCalculator = tcache.statisticsCalculator();
        this.cache = tcache.jsr107cache();
    }

    @Override
    public boolean hasNext() {
        Map.Entry<K, AccessTimeObjectHolder<V>> entry = this.peekNext();
        if (entry == null) {
            return false;
        }
        return !entry.getValue().isInvalid();
    }

    @Override
    public Cache.Entry<K, V> next() {
        try {
            Map.Entry<K, AccessTimeObjectHolder<V>> entry = this.peekNext();
            this.nextElement = null;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            AccessTimeObjectHolder<V> holder = entry.getValue();
            holder.updateMaxIdleTime(this.expiryPolicy.getExpiryForAccess());
            V value = holder.get();
            this.currentElement = new TCacheJSR107Entry<K, V>(entry.getKey(), value);
            if (this.statisticsCalculator != null) {
                this.statisticsCalculator.incrementHitCount();
            }
            return this.currentElement;
        }
        catch (NoSuchElementException nsee) {
            this.currentElement = null;
            throw nsee;
        }
    }

    private Map.Entry<K, AccessTimeObjectHolder<V>> peekNext() {
        Map.Entry<K, AccessTimeObjectHolder<AccessTimeObjectHolder<V>>> entry;
        AccessTimeObjectHolder<V> holder;
        if (this.nextElement != null) {
            return this.nextElement;
        }
        do {
            if (this.mapIterator.hasNext()) continue;
            return null;
        } while ((holder = (entry = this.mapIterator.next()).getValue()).isInvalid());
        this.nextElement = entry;
        return this.nextElement;
    }

    @Override
    public void remove() {
        if (this.currentElement == null) {
            throw new IllegalStateException("No element to remove");
        }
        this.cache.remove(this.currentElement.getKey());
    }
}

