/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.eviction;

import com.trivago.triava.tcache.TCacheHolder;
import com.trivago.triava.tcache.eviction.FreezingEvictor;
import com.trivago.triava.time.TimeSource;

public class ClockEviction<K, V>
extends FreezingEvictor<K, V> {
    private static final long serialVersionUID = 6871216638625966432L;
    long lastTimestamp;
    TimeSource timeSource;

    ClockEviction(TimeSource timeSource) {
        this.timeSource = timeSource;
        this.lastTimestamp = timeSource.millis();
    }

    @Override
    public void afterEviction() {
        this.lastTimestamp = this.timeSource.millis();
    }

    @Override
    public long getFreezeValue(K key, TCacheHolder<V> holder) {
        long lastAccess = holder.getLastAccessTime();
        if (lastAccess >= this.lastTimestamp) {
            return 1L;
        }
        return -1L;
    }
}

