/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.eviction;

import com.trivago.triava.tcache.TCacheHolder;
import com.trivago.triava.tcache.eviction.EvictionInterface;
import com.trivago.triava.tcache.eviction.HolderFreezer;
import java.io.Serializable;
import java.util.Comparator;

public abstract class FreezingEvictor<K, V>
implements EvictionInterface<K, V> {
    private static final long serialVersionUID = 4837286647549752950L;
    private StandardComparator comparator = new StandardComparator();

    @Override
    public Comparator<HolderFreezer<K, V>> evictionComparator() {
        return this.comparator;
    }

    @Override
    public void beforeEviction() {
    }

    @Override
    public void afterEviction() {
    }

    @Override
    public abstract long getFreezeValue(K var1, TCacheHolder<V> var2);

    public int compareByFreezer(HolderFreezer<K, V> o1, HolderFreezer<K, V> o2, boolean includeTiebreaker) {
        long frozenValueDiff = o1.getFrozenValue() - o2.getFrozenValue();
        if (frozenValueDiff != 0L) {
            return Long.signum(frozenValueDiff);
        }
        if (!includeTiebreaker) {
            return 0;
        }
        int tiebreaker = o1.getTiebreaker() - o2.getTiebreaker();
        return tiebreaker;
    }

    private class StandardComparator
    implements Comparator<HolderFreezer<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1207262209989301593L;

        private StandardComparator() {
        }

        @Override
        public int compare(HolderFreezer<K, V> o1, HolderFreezer<K, V> o2) {
            return FreezingEvictor.this.compareByFreezer(o1, o2, true);
        }
    }
}

