/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.statistics;

import com.trivago.triava.tcache.statistics.HitAndMissDifference;
import com.trivago.triava.tcache.statistics.StatisticsCalculator;
import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;

public class LongAdderStatisticsCalculator
implements StatisticsCalculator,
Serializable {
    private static final long serialVersionUID = 2529491687236918155L;
    private final LongAdder cacheHitCount = new LongAdder();
    private final LongAdder cacheMissCount = new LongAdder();
    private final LongAdder cachePutCount = new LongAdder();
    private final LongAdder cacheRemoveCount = new LongAdder();
    private final LongAdder cacheDropCount = new LongAdder();
    private volatile long cacheHitCountPrevious = 0L;
    private volatile long cacheMissCountPrevious = 0L;

    @Override
    public HitAndMissDifference tick() {
        long hitDifference = 0L;
        long missDifference = 0L;
        long cacheHitsPrevious = this.cacheHitCountPrevious;
        long cacheMissesPrevious = this.cacheMissCountPrevious;
        long cacheHitsCurrent = this.cacheHitCount.sum();
        long cacheMissesCurrent = this.cacheMissCount.sum();
        hitDifference = cacheHitsCurrent - cacheHitsPrevious;
        missDifference = cacheMissesCurrent - cacheMissesPrevious;
        this.cacheHitCountPrevious = cacheHitsCurrent;
        this.cacheMissCountPrevious = cacheMissesCurrent;
        return new HitAndMissDifference(hitDifference, missDifference);
    }

    @Override
    public void clear() {
        this.cacheHitCount.reset();
        this.cacheMissCount.reset();
        this.cachePutCount.reset();
        this.cacheRemoveCount.reset();
        this.cacheDropCount.reset();
        this.cacheHitCountPrevious = 0L;
        this.cacheMissCountPrevious = 0L;
    }

    @Override
    public long getHitCount() {
        return this.cacheHitCount.sum();
    }

    @Override
    public long getMissCount() {
        return this.cacheMissCount.sum();
    }

    @Override
    public long getPutCount() {
        return this.cachePutCount.sum();
    }

    @Override
    public void incrementHitCount() {
        this.cacheHitCount.increment();
    }

    @Override
    public void incrementMissCount() {
        this.cacheMissCount.increment();
    }

    @Override
    public void incrementPutCount() {
        this.cachePutCount.increment();
    }

    @Override
    public void incrementDropCount() {
        this.cacheDropCount.increment();
    }

    @Override
    public long getDropCount() {
        return this.cacheDropCount.sum();
    }

    @Override
    public void incrementRemoveCount() {
        this.cacheRemoveCount.increment();
    }

    @Override
    public void incrementRemoveCount(int removedCount) {
        this.cacheRemoveCount.add(removedCount);
    }

    @Override
    public long getRemoveCount() {
        return this.cacheRemoveCount.sum();
    }

    public String toString() {
        return "StandardStatisticsCalculator [cacheHitCount=" + this.cacheHitCount + ", cacheMissCount=" + this.cacheMissCount + ", cachePutCount=" + this.cachePutCount + ", cacheRemoveCount=" + this.cacheRemoveCount + ", cacheDropCount=" + this.cacheDropCount + "]";
    }
}

