/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.time;

import com.trivago.triava.logging.TriavaLogger;
import com.trivago.triava.logging.TriavaNullLogger;
import com.trivago.triava.time.SystemTimeSource;
import com.trivago.triava.time.TimeSource;
import java.util.concurrent.TimeUnit;

public class EstimatorTimeSource
extends Thread
implements TimeSource {
    private final int UPDATE_INTERVAL_MS;
    private volatile long millisEstimate;
    private volatile long secondsEstimate;
    private volatile boolean running;
    private final TriavaLogger logger;
    private final TimeSource timeSource;

    public EstimatorTimeSource(int updateIntervalMillis) {
        this(new SystemTimeSource(), updateIntervalMillis, new TriavaNullLogger());
    }

    public EstimatorTimeSource(TimeSource parentTimeSource, int updateIntervalMillis, TriavaLogger logger) {
        this.logger = logger;
        this.timeSource = parentTimeSource;
        this.setTimeFields();
        this.UPDATE_INTERVAL_MS = updateIntervalMillis;
        this.setName("EstimatorTimeSource-" + this.UPDATE_INTERVAL_MS + "ms");
        this.setPriority(10);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        this.logger.info("MillisEstimatorThread " + this.getName() + " has entered run()");
        this.running = true;
        while (this.running) {
            try {
                EstimatorTimeSource.sleep(this.UPDATE_INTERVAL_MS);
                this.setTimeFields();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.info("MillisEstimatorThread " + this.getName() + " is leaving run()");
    }

    private void setTimeFields() {
        this.millisEstimate = this.timeSource.millis();
        this.secondsEstimate = this.millisEstimate / 1000L;
    }

    private void cancel() {
        this.running = false;
        this.interrupt();
    }

    @Override
    public void shutdown() {
        this.cancel();
    }

    @Override
    public long time(TimeUnit tu) {
        if (tu == TimeUnit.SECONDS) {
            return this.secondsEstimate;
        }
        if (tu == TimeUnit.MILLISECONDS) {
            return this.millisEstimate;
        }
        return tu.convert(this.millisEstimate, TimeUnit.MILLISECONDS);
    }

    @Override
    public long seconds() {
        return this.secondsEstimate;
    }

    @Override
    public long millis() {
        return this.millisEstimate;
    }
}

