/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public abstract class InputStreamAbstractTest
extends ObjectAbstractTest {
    private static final long SEED = 29487982745L;
    static final Random sRandom = new Random(29487982745L);

    protected final Object makeObject() {
        return this.makeInputStream();
    }

    protected InputStream makeInputStream() {
        return this.makeInputStream(16);
    }

    protected InputStream makeInputStream(int n) {
        byte[] byArray = this.makeRandomArray(n);
        return this.makeInputStream(byArray);
    }

    protected abstract InputStream makeInputStream(byte[] var1);

    protected final byte[] makeRandomArray(int n) {
        byte[] byArray = new byte[n];
        sRandom.nextBytes(byArray);
        return byArray;
    }

    protected final byte[] makeOrderedArray(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        return byArray;
    }

    @Test
    public void testRead() throws Exception {
        int n;
        int n2 = 5;
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(n2));
        for (n = 0; n < n2; ++n) {
            Assert.assertTrue((String)("Check Size [" + n + "]"), (n2 - n >= inputStream.available() ? 1 : 0) != 0);
            Assert.assertEquals((String)("Check Value [" + n + "]"), (long)n, (long)inputStream.read());
        }
        Assert.assertEquals((String)"Available after contents all read", (long)0L, (long)inputStream.available());
        try {
            n = inputStream.read();
            Assert.assertEquals((String)"Wrong value read after end of file", (long)-1L, (long)n);
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not have thrown an IOException: " + iOException.getMessage()));
        }
    }

    @Test
    public void testAvailable() throws Exception {
        InputStream inputStream = this.makeInputStream(1);
        Assert.assertFalse((String)"Unexpected EOF", (inputStream.read() < 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Available after contents all read", (long)0L, (long)inputStream.available());
        Assert.assertEquals((String)"End of File", (long)-1L, (long)inputStream.read());
        Assert.assertEquals((String)"Available after End of File", (long)0L, (long)inputStream.available());
    }

    @Test
    public void testReadByteArray() throws Exception {
        int n;
        int n2;
        int n3;
        byte[] byArray = new byte[10];
        byte[] byArray2 = this.makeOrderedArray(15);
        InputStream inputStream = this.makeInputStream(byArray2);
        int n4 = inputStream.read(byArray);
        Assert.assertEquals((String)"Read 1", (long)byArray.length, (long)n4);
        for (n3 = 0; n3 < n4; ++n3) {
            Assert.assertEquals((String)"Check Bytes 1", (long)n3, (long)byArray[n3]);
        }
        n3 = inputStream.read(byArray);
        Assert.assertEquals((String)"Read 2", (long)5L, (long)n3);
        for (n2 = 0; n2 < n3; ++n2) {
            Assert.assertEquals((String)"Check Bytes 2", (long)(n4 + n2), (long)byArray[n2]);
        }
        n2 = inputStream.read(byArray);
        Assert.assertEquals((String)"Read 3 (EOF)", (long)-1L, (long)n2);
        try {
            n = inputStream.read(byArray);
            Assert.assertEquals((String)"Wrong value read after end of file", (long)-1L, (long)n);
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not have thrown an IOException: " + iOException.getMessage()));
        }
        inputStream = this.makeInputStream(byArray2);
        n = 2;
        int n5 = 4;
        int n6 = inputStream.read(byArray, n, n5);
        Assert.assertEquals((String)"Read 5", (long)n5, (long)n6);
        for (int i = n; i < n5; ++i) {
            Assert.assertEquals((String)"Check Bytes 2", (long)(i - n), (long)byArray[i]);
        }
    }

    @Test
    public void testEOF() throws Exception {
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(2));
        Assert.assertEquals((String)"Read 1", (long)0L, (long)inputStream.read());
        Assert.assertEquals((String)"Read 2", (long)1L, (long)inputStream.read());
        Assert.assertEquals((String)"Read 3", (long)-1L, (long)inputStream.read());
        Assert.assertEquals((String)"Read 4", (long)-1L, (long)inputStream.read());
        Assert.assertEquals((String)"Read 5", (long)-1L, (long)inputStream.read());
    }

    @Test
    public void testMarkResetUnsupported() throws IOException {
        InputStream inputStream = this.makeInputStream(10);
        if (inputStream.markSupported()) {
            return;
        }
        inputStream.mark(100);
        int n = inputStream.read();
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        try {
            inputStream.reset();
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
            Assert.assertTrue((String)("Wrong messge: " + iOException.getMessage()), (boolean)iOException.getMessage().contains("reset"));
        }
    }

    @Test
    public void testResetNoMark() throws Exception {
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(10));
        if (!inputStream.markSupported()) {
            return;
        }
        int n = inputStream.read();
        Assert.assertEquals((long)0L, (long)n);
        try {
            inputStream.reset();
            Assert.assertEquals((String)"Re-read of reset data should be same", (long)0L, (long)inputStream.read());
        }
        catch (Exception exception) {
            Assert.assertTrue((String)"Wrong no mark IOException message", (boolean)exception.getMessage().contains("mark"));
        }
    }

    @Test
    public void testMarkReset() throws Exception {
        int n;
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(25));
        if (!inputStream.markSupported()) {
            return;
        }
        int n2 = inputStream.read();
        Assert.assertEquals((long)0L, (long)n2);
        int n3 = 1;
        int n4 = 10;
        inputStream.mark(n4);
        for (n = 0; n < 3; ++n) {
            Assert.assertEquals((String)("Read After Mark [" + n + "]"), (long)(n3 + n), (long)inputStream.read());
        }
        inputStream.reset();
        for (n = 0; n < n4 + 1; ++n) {
            Assert.assertEquals((String)("Read After Reset [" + n + "]"), (long)(n3 + n), (long)inputStream.read());
        }
    }

    @Test
    public void testResetAfterReadLimit() throws Exception {
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(25));
        if (!inputStream.markSupported()) {
            return;
        }
        int n = inputStream.read();
        Assert.assertEquals((long)0L, (long)n);
        int n2 = 1;
        int n3 = 5;
        inputStream.mark(n3);
        for (int i = 0; i < n3 + 1; ++i) {
            Assert.assertEquals((String)("Read After Reset [" + i + "]"), (long)(n2 + i), (long)inputStream.read());
        }
        try {
            inputStream.reset();
            Assert.assertEquals((String)"Re-read of reset data should be same", (long)1L, (long)inputStream.read());
        }
        catch (Exception exception) {
            Assert.assertTrue((String)"Wrong read-limit IOException message", (boolean)exception.getMessage().contains("mark"));
        }
    }

    @Test
    public void testResetAfterReset() throws Exception {
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(25));
        if (!inputStream.markSupported()) {
            return;
        }
        int n = inputStream.read();
        Assert.assertTrue((String)"Expected to read positive value", (n >= 0 ? 1 : 0) != 0);
        int n2 = 5;
        inputStream.mark(n2);
        int n3 = inputStream.read();
        Assert.assertTrue((String)"Expected to read positive value", (n3 >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((inputStream.read() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((inputStream.read() >= 0 ? 1 : 0) != 0);
        inputStream.reset();
        Assert.assertEquals((String)"Expected value read differs from actual", (long)n3, (long)inputStream.read());
        try {
            inputStream.reset();
            int n4 = inputStream.read();
            Assert.assertTrue((String)"Re-read of reset data should be same as initially marked or first", (n4 == n3 || n4 == n ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            Assert.assertTrue((String)"Wrong read-limit IOException message", (boolean)exception.getMessage().contains("mark"));
        }
    }

    @Test
    public void testSkip() throws Exception {
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(10));
        Assert.assertEquals((String)"Unexpected value read", (long)0L, (long)inputStream.read());
        Assert.assertEquals((String)"Unexpected value read", (long)1L, (long)inputStream.read());
        Assert.assertEquals((String)"Unexpected number of bytes skipped", (long)5L, (long)inputStream.skip(5L));
        Assert.assertEquals((String)"Unexpected value read", (long)7L, (long)inputStream.read());
        Assert.assertEquals((String)"Unexpected number of bytes skipped", (long)2L, (long)inputStream.skip(5L));
        Assert.assertEquals((String)"Unexpected value read after EOF", (long)-1L, (long)inputStream.read());
        Assert.assertTrue((String)"Positive value skipped after EOF", (inputStream.skip(5L) <= 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unexpected value read after EOF", (long)-1L, (long)inputStream.read());
    }

    @Test
    public void testSanityOrdered() throws IOException {
        byte[] byArray = this.makeOrderedArray(25);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        for (byte by : byArray) {
            Assert.assertEquals((long)by, (long)((InputStream)byteArrayInputStream).read());
            Assert.assertEquals((long)by, (long)inputStream.read());
        }
    }

    @Test
    public void testSanityOrdered2() throws IOException {
        byte[] byArray = this.makeOrderedArray(25);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[byArray.length];
        Assert.assertEquals((long)byArray2.length, (long)((InputStream)byteArrayInputStream).read(byArray2, 0, byArray2.length));
        Assert.assertEquals((long)byArray3.length, (long)inputStream.read(byArray3, 0, byArray3.length));
        for (int i = 0; i < byArray.length; ++i) {
            Assert.assertEquals((long)byArray[i], (long)byArray2[i]);
            Assert.assertEquals((long)byArray[i], (long)byArray3[i]);
        }
    }

    @Test
    public void testSanityNegative() throws IOException {
        byte[] byArray = new byte[25];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(255 - i);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        for (byte by : byArray) {
            Assert.assertEquals((long)(by & 0xFF), (long)((InputStream)byteArrayInputStream).read());
            Assert.assertEquals((long)(by & 0xFF), (long)inputStream.read());
        }
    }

    @Test
    public void testSanityNegative2() throws IOException {
        byte[] byArray = new byte[25];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(255 - i);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[byArray.length];
        Assert.assertEquals((long)byArray2.length, (long)((InputStream)byteArrayInputStream).read(byArray2, 0, byArray2.length));
        Assert.assertEquals((long)byArray3.length, (long)inputStream.read(byArray3, 0, byArray3.length));
        for (int i = 0; i < byArray.length; ++i) {
            Assert.assertEquals((long)byArray[i], (long)byArray2[i]);
            Assert.assertEquals((long)byArray[i], (long)byArray3[i]);
        }
    }

    @Test
    public void testSanityRandom() throws IOException {
        byte[] byArray = this.makeRandomArray(25);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        for (byte by : byArray) {
            Assert.assertEquals((long)(by & 0xFF), (long)((InputStream)byteArrayInputStream).read());
            Assert.assertEquals((long)(by & 0xFF), (long)inputStream.read());
        }
    }

    @Test
    public void testSanityRandom2() throws IOException {
        byte[] byArray = this.makeRandomArray(25);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.makeInputStream(byArray);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[byArray.length];
        Assert.assertEquals((long)byArray2.length, (long)((InputStream)byteArrayInputStream).read(byArray2, 0, byArray2.length));
        Assert.assertEquals((long)byArray3.length, (long)inputStream.read(byArray3, 0, byArray3.length));
        for (int i = 0; i < byArray.length; ++i) {
            Assert.assertEquals((long)byArray[i], (long)byArray2[i]);
            Assert.assertEquals((long)byArray[i], (long)byArray3[i]);
        }
    }
}

