/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class LittleEndianDataInputStreamTest {
    @Test
    public void testReadBoolean() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 127, -1}));
        Assert.assertFalse((boolean)littleEndianDataInputStream.readBoolean());
        Assert.assertTrue((boolean)littleEndianDataInputStream.readBoolean());
        Assert.assertTrue((boolean)littleEndianDataInputStream.readBoolean());
        Assert.assertTrue((boolean)littleEndianDataInputStream.readBoolean());
    }

    @Test
    public void testReadByte() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 1, 0, -1, -1, 0, -128, -1, 127, 0, 1}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)-128L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)127L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readByte());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readByte());
    }

    @Test
    public void testReadUnsignedByte() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 1, 0, -1, -1, 0, -128, -1, 127, 0, 1}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)255L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)255L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)128L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)255L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)127L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedByte());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readUnsignedByte());
    }

    @Test
    public void testReadShort() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 1, 0, -1, -1, 0, -128, -1, 127, 0, 1}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readShort());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readShort());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readShort());
        Assert.assertEquals((long)-32768L, (long)littleEndianDataInputStream.readShort());
        Assert.assertEquals((long)32767L, (long)littleEndianDataInputStream.readShort());
        Assert.assertEquals((long)256L, (long)littleEndianDataInputStream.readShort());
    }

    @Test
    public void testReadUnsignedShort() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 1, 0, -1, -1, 0, -128, -1, 127, 0, 1}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readUnsignedShort());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readUnsignedShort());
        Assert.assertEquals((long)65535L, (long)littleEndianDataInputStream.readUnsignedShort());
        Assert.assertEquals((long)32768L, (long)littleEndianDataInputStream.readUnsignedShort());
        Assert.assertEquals((long)32767L, (long)littleEndianDataInputStream.readUnsignedShort());
        Assert.assertEquals((long)256L, (long)littleEndianDataInputStream.readUnsignedShort());
    }

    @Test
    public void testReadInt() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, -128, -1, -1, -1, 127, 0, 0, 0, 1, -1, 0, -1, 0, 0, -1, 0, -1, -66, -70, -2, -54, -54, -2, -48, 13}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)0x1000000L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)0xFF00FFL, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)-16711936L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)-889275714L, (long)littleEndianDataInputStream.readInt());
        Assert.assertEquals((long)231800522L, (long)littleEndianDataInputStream.readInt());
    }

    @Test
    public void testReadLong() throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -128, -1, -1, -1, -1, -1, -1, -1, 127, 0, 0, 0, 0, 0, 0, 0, 1, 13, -48, -2, -54, -66, -70, -2, -54}));
        Assert.assertEquals((long)0L, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)1L, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)-1L, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)0x100000000000000L, (long)littleEndianDataInputStream.readLong());
        Assert.assertEquals((long)-3819410105351352307L, (long)littleEndianDataInputStream.readLong());
    }
}

