/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.IOException;
import java.io.Reader;
import org.junit.Assert;
import org.junit.Test;

public abstract class ReaderAbstractTest
extends ObjectAbstractTest {
    protected final String mInput = "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.";

    protected final Object makeObject() {
        return this.makeReader();
    }

    protected Reader makeReader() {
        return this.makeReader("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.");
    }

    protected abstract Reader makeReader(String var1);

    @Test
    public void testRead() throws IOException {
        int n;
        Reader reader = this.makeReader();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length());
        while ((n = reader.read()) > 0) {
            ++n2;
            stringBuilder.append((char)n);
        }
        Assert.assertEquals((long)"Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length(), (long)n2);
        Assert.assertEquals((Object)"Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.", (Object)stringBuilder.toString());
    }

    @Test
    public void testReadBuffer() throws IOException {
        int n;
        Reader reader = this.makeReader();
        char[] cArray = new char["Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length()];
        StringBuilder stringBuilder = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length());
        int n2 = 0;
        int n3 = cArray.length;
        while ((n = reader.read(cArray, n2, n3)) > 0) {
            stringBuilder.append(cArray, n2, n);
            n2 += n;
            n3 -= n;
        }
        Assert.assertEquals((Object)"Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.", (Object)stringBuilder.toString());
        Assert.assertEquals((Object)"Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.", (Object)new String(cArray));
    }

    @Test
    public void testSkipToEnd() throws IOException {
        Reader reader = this.makeReader();
        int n = "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length();
        while (n > 0) {
            long l = reader.skip(n);
            Assert.assertFalse((String)"Skipped < 0", (l < 0L ? 1 : 0) != 0);
            n = (int)((long)n - l);
        }
        Assert.assertEquals((long)0L, (long)n);
    }

    @Test
    public void testSkipToEndAndRead() throws IOException {
        Reader reader = this.makeReader();
        int n = "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length();
        while (n > 0) {
            n = (int)((long)n - reader.skip(n));
        }
        Assert.assertEquals((long)reader.read(), (long)-1L);
    }

    @Test
    public void testResetMarkSupported() throws IOException {
        Reader reader = this.makeReader();
        if (reader.markSupported()) {
            int n;
            reader.mark("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            char c = (char)reader.read();
            reader.reset();
            Assert.assertEquals((long)c, (long)((char)reader.read()));
            reader.reset();
            StringBuilder stringBuilder = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            for (int i = 0; i < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++i) {
                stringBuilder.append((char)reader.read());
            }
            reader.reset();
            StringBuilder stringBuilder2 = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            for (n = 0; n < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++n) {
                stringBuilder2.append((char)reader.read());
            }
            Assert.assertEquals((Object)stringBuilder.toString(), (Object)stringBuilder2.toString());
            reader.mark("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            stringBuilder = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            for (n = 0; n < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++n) {
                stringBuilder.append((char)reader.read());
            }
            reader.reset();
            stringBuilder2 = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            for (n = 0; n < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++n) {
                stringBuilder2.append((char)reader.read());
            }
            Assert.assertEquals((Object)stringBuilder.toString(), (Object)stringBuilder2.toString());
            reader.read();
            try {
                reader.reset();
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
            }
        }
    }

    @Test
    public void testResetMarkNotSupported() throws IOException {
        Reader reader = this.makeReader();
        if (!reader.markSupported()) {
            try {
                reader.mark("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length());
                Assert.fail((String)"Mark set, while markSupprted is false");
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
            }
            char c = (char)reader.read();
            try {
                reader.reset();
                Assert.assertEquals((long)c, (long)((char)reader.read()));
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
            }
            StringBuilder stringBuilder = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
            for (int i = 0; i < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++i) {
                stringBuilder.append((char)reader.read());
            }
            try {
                reader.reset();
                StringBuilder stringBuilder2 = new StringBuilder("Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4);
                for (int i = 0; i < "Cras tincidunt euismod tellus. Aenean a odio. Aenean metus. Sed tristique est non purus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Fusce vulputate dolor non mauris. Nullam nunc massa, pretium quis, ultricies a, varius quis, neque. Nam id nulla eu ante malesuada fermentum. Sed vulputate purus eget magna. Sed mollis. Curabitur enim diam, faucibus ac, hendrerit eu, consequat nec, augue.".length() / 4; ++i) {
                    stringBuilder2.append((char)reader.read());
                }
                Assert.assertEquals((Object)stringBuilder.toString(), (Object)stringBuilder2.toString());
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
            }
        }
    }

    @Test
    public void testReadAfterClose() throws IOException {
        Reader reader = this.makeReader("foo bar");
        reader.close();
        try {
            reader.read();
            Assert.fail((String)"Should not allow read after close");
        }
        catch (IOException iOException) {
            Assert.assertNotNull((Object)iOException.getMessage());
        }
    }
}

