/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Base64Decoder;
import com.twelvemonkeys.io.enc.Base64Encoder;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderAbstractTest;
import com.twelvemonkeys.io.enc.EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class Base64EncoderTest
extends EncoderAbstractTest {
    @Override
    protected Encoder createEncoder() {
        return new Base64Encoder();
    }

    @Override
    protected Decoder createCompatibleDecoder() {
        return new Base64Decoder();
    }

    @Test
    public void testEmptyEncode() throws IOException {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, this.createEncoder(), true);
        encoderStream.write(string.getBytes());
        Assert.assertEquals((String)"Strings does not match", (Object)"", (Object)new String(byteArrayOutputStream.toByteArray()));
    }

    @Test
    public void testShortEncode() throws IOException {
        String string = "test";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, this.createEncoder(), true);
        encoderStream.write(string.getBytes());
        Assert.assertEquals((String)"Strings does not match", (Object)"dGVzdA==", (Object)new String(byteArrayOutputStream.toByteArray()));
    }

    @Test
    public void testLongEncode() throws IOException {
        String string = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Fusce est. Morbi luctus consectetuer justo. Vivamus dapibus laoreet purus. Nunc viverra dictum nisl. Integer ullamcorper, nisi in dictum amet.";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, this.createEncoder(), true);
        encoderStream.write(string.getBytes());
        Assert.assertEquals((String)"Strings does not match", (Object)"TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVlciBhZGlwaXNjaW5nIGVsaXQuIEZ1c2NlIGVzdC4gTW9yYmkgbHVjdHVzIGNvbnNlY3RldHVlciBqdXN0by4gVml2YW11cyBkYXBpYnVzIGxhb3JlZXQgcHVydXMuIE51bmMgdml2ZXJyYSBkaWN0dW0gbmlzbC4gSW50ZWdlciB1bGxhbWNvcnBlciwgbmlzaSBpbiBkaWN0dW0gYW1ldC4=", (Object)new String(byteArrayOutputStream.toByteArray()));
    }
}

