/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderAbstractTest;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public abstract class DecoderAbstractTest
extends ObjectAbstractTest {
    public abstract Decoder createDecoder();

    public abstract Encoder createCompatibleEncoder();

    protected Object makeObject() {
        return this.createDecoder();
    }

    @Test(expected=NullPointerException.class)
    public final void testNullDecode() throws IOException {
        Decoder decoder = this.createDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[20]);
        decoder.decode((InputStream)byteArrayInputStream, null);
        Assert.fail((String)"null should throw NullPointerException");
    }

    @Test
    public final void testEmptyDecode() throws IOException {
        Decoder decoder = this.createDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            int n = decoder.decode((InputStream)byteArrayInputStream, ByteBuffer.allocate(128));
            Assert.assertEquals((String)"Should not be able to read any bytes", (long)0L, (long)n);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private byte[] createData(int n) throws Exception {
        byte[] byArray = new byte[n];
        EncoderAbstractTest.RANDOM.nextBytes(byArray);
        return byArray;
    }

    private void runStreamTest(int n) throws Exception {
        byte[] byArray = this.createData(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, this.createCompatibleEncoder(), true);
        encoderStream.write(byArray);
        encoderStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = FileUtil.read((InputStream)new DecoderStream((InputStream)new ByteArrayInputStream(byArray2), this.createDecoder()));
        Assert.assertArrayEquals((String)String.format("Data %d", n), (byte[])byArray, (byte[])byArray3);
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream(byArray2), this.createDecoder());
        byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        decoderStream.close();
        byArray3 = byteArrayOutputStream.toByteArray();
        Assert.assertArrayEquals((String)String.format("Data %d", n), (byte[])byArray, (byte[])byArray3);
    }

    @Test
    public final void testStreams() throws Exception {
        int n;
        if (this.createCompatibleEncoder() == null) {
            return;
        }
        for (n = 1; n < 100; ++n) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
        for (n = 100; n < 2000; n += 250) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
        for (n = 2000; n < 80000; n += 1000) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
    }
}

