/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.net.HTTPUtil;
import org.junit.Assert;
import org.junit.Test;

public class HTTPUtilTest {
    @Test
    public void testParseHTTPDateRFC1123() {
        long l = HTTPUtil.parseHTTPDate((String)"Sun, 06 Nov 1994 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
        l = HTTPUtil.parseHTTPDate((String)"Sunday, 06 Nov 1994 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
    }

    @Test
    public void testParseHTTPDateRFC850() {
        long l = HTTPUtil.parseHTTPDate((String)"Sunday, 06-Nov-1994 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
        l = HTTPUtil.parseHTTPDate((String)"Sun, 06-Nov-94 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
        l = HTTPUtil.parseHTTPDate((String)"Sunday, 06-Nov-94 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
        l = HTTPUtil.parseHTTPDate((String)"Sun, 06-Nov-94 08:49:37 GMT");
        Assert.assertEquals((long)784111777000L, (long)l);
    }

    @Test
    public void testParseHTTPDateAsctime() {
        long l = HTTPUtil.parseHTTPDate((String)"Sun Nov  6 08:49:37 1994");
        Assert.assertEquals((long)784111777000L, (long)l);
        l = HTTPUtil.parseHTTPDate((String)"Sun Nov  6 08:49:37 94");
        Assert.assertEquals((long)784111777000L, (long)l);
    }

    @Test
    public void testFormatHTTPDateRFC1123() {
        long l = 784111777000L;
        Assert.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)HTTPUtil.formatHTTPDate((long)l));
    }
}

