/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.apt;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgParser;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.Parser;
import com.twitter.common.args.Positional;
import com.twitter.common.args.Verifier;
import com.twitter.common.args.VerifierFor;
import com.twitter.common.args.apt.Configuration;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"com.twitter.common.args.apt.CmdLineProcessor.main", "com.twitter.common.args.apt.CmdLineProcessor.check_linkage"})
public class CmdLineProcessor
extends AbstractProcessor {
    static final String MAIN_OPTION = "com.twitter.common.args.apt.CmdLineProcessor.main";
    static final String CHECK_LINKAGE_OPTION = "com.twitter.common.args.apt.CmdLineProcessor.check_linkage";
    private static final Function<Class<?>, String> GET_NAME = new Function<Class<?>, String>(){

        public String apply(Class<?> type) {
            return type.getName();
        }
    };
    private final Supplier<Configuration> configSupplier = Suppliers.memoize((Supplier)new Supplier<Configuration>(){

        public Configuration get() {
            try {
                Configuration configuration = Configuration.load();
                for (Configuration.ArgInfo argInfo : configuration.positionalInfo()) {
                    CmdLineProcessor.this.configBuilder.addPositionalInfo(argInfo);
                }
                for (Configuration.ArgInfo argInfo : configuration.optionInfo()) {
                    CmdLineProcessor.this.configBuilder.addCmdLineArg(argInfo);
                }
                for (Configuration.ParserInfo parserInfo : configuration.parserInfo()) {
                    CmdLineProcessor.this.configBuilder.addParser(parserInfo);
                }
                for (Configuration.VerifierInfo verifierInfo : configuration.verifierInfo()) {
                    CmdLineProcessor.this.configBuilder.addVerifier(verifierInfo);
                }
                return configuration;
            }
            catch (IOException e) {
                CmdLineProcessor.this.error("Problem loading existing flags on compile time classpath: %s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                return null;
            }
        }
    });
    private final Configuration.Builder configBuilder = new Configuration.Builder();
    private Types typeUtils;
    private Elements elementUtils;
    private boolean isMain;
    private boolean isCheckLinkage;

    private static boolean getBooleanOption(Map<String, String> options, String name, boolean defaultValue) {
        if (!options.containsKey(name)) {
            return defaultValue;
        }
        String isOption = options.get(name);
        return isOption == null || Boolean.parseBoolean(isOption);
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        Map<String, String> options = processingEnv.getOptions();
        this.isMain = CmdLineProcessor.getBooleanOption(options, MAIN_OPTION, false);
        this.isCheckLinkage = CmdLineProcessor.getBooleanOption(options, CHECK_LINKAGE_OPTION, true);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.of(Positional.class, CmdLine.class, ArgParser.class, VerifierFor.class), GET_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block7: {
            try {
                Writer cmdLinePropertiesResource;
                Configuration classpathConfiguration = (Configuration)this.configSupplier.get();
                Set<? extends Element> parsers = this.getAnnotatedElements(roundEnv, ArgParser.class);
                Set<String> parsedTypes = this.getParsedTypes(classpathConfiguration, parsers);
                for (Configuration.ArgInfo cmdLineInfo : this.processAnnotatedArgs(parsedTypes, roundEnv, CmdLine.class)) {
                    this.configBuilder.addCmdLineArg(cmdLineInfo);
                }
                for (Configuration.ArgInfo positionalInfo : this.processAnnotatedArgs(parsedTypes, roundEnv, Positional.class)) {
                    this.configBuilder.addPositionalInfo(positionalInfo);
                }
                this.checkPositionalArgsAreLists(roundEnv);
                this.processParsers(parsers);
                this.processVerifiers(roundEnv.getElementsAnnotatedWith(this.typeElement(VerifierFor.class)));
                if (!roundEnv.processingOver() || classpathConfiguration == null || classpathConfiguration.isEmpty() && this.configBuilder.isEmpty() || (cmdLinePropertiesResource = this.openCmdLinePropertiesResource(classpathConfiguration)) == null) break block7;
                try {
                    this.configBuilder.build(classpathConfiguration).store(cmdLinePropertiesResource, "Generated via apt by " + this.getClass().getName());
                }
                finally {
                    Closeables.closeQuietly((Closeable)cmdLinePropertiesResource);
                }
            }
            catch (RuntimeException e) {
                this.error("Unexpected error completing annotation processing:\n%s", Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        return true;
    }

    private void checkPositionalArgsAreLists(RoundEnvironment roundEnv) {
        for (Element element : this.getAnnotatedElements(roundEnv, Positional.class)) {
            TypeMirror typeArgument = this.getTypeArgument(element.asType(), this.typeElement(Arg.class));
            if (typeArgument != null && this.typeUtils.isSubtype(this.typeElement(List.class).asType(), typeArgument)) continue;
            this.error("Found @Positional %s %s.%s that is not a List", element.asType(), element.getEnclosingElement(), element);
        }
    }

    @Nullable
    private Set<String> getParsedTypes(@Nullable Configuration configuration, Set<? extends Element> parsers) {
        if (!this.isCheckLinkage) {
            return null;
        }
        Iterable parsersFor = Optional.presentInstances((Iterable)Iterables.transform(parsers, (Function)new Function<Element, Optional<String>>(){

            public Optional<String> apply(Element parser) {
                TypeMirror parsedType = CmdLineProcessor.this.getTypeArgument(parser.asType(), CmdLineProcessor.this.typeElement(Parser.class));
                if (parsedType == null) {
                    CmdLineProcessor.this.error("failed to find a type argument for Parser: %s", new Object[]{parser});
                    return Optional.absent();
                }
                return Optional.of((Object)((Object)CmdLineProcessor.this.typeUtils.erasure(parsedType)).toString());
            }
        }));
        if (configuration != null) {
            parsersFor = Iterables.concat((Iterable)parsersFor, (Iterable)Iterables.filter((Iterable)Iterables.transform(configuration.parserInfo(), (Function)new Function<Configuration.ParserInfo, String>(){

                @Nullable
                public String apply(Configuration.ParserInfo parserInfo) {
                    TypeElement typeElement = CmdLineProcessor.this.elementUtils.getTypeElement(parserInfo.parsedType);
                    return typeElement == null ? null : ((Object)CmdLineProcessor.this.typeUtils.erasure(typeElement.asType())).toString();
                }
            }), (Predicate)Predicates.notNull()));
        }
        return ImmutableSet.copyOf((Iterable)parsersFor);
    }

    private Iterable<Configuration.ArgInfo> processAnnotatedArgs(final @Nullable Set<String> parsedTypes, RoundEnvironment roundEnv, final Class<? extends Annotation> argAnnotation) {
        Set<? extends Element> args = this.getAnnotatedElements(roundEnv, argAnnotation);
        return Optional.presentInstances((Iterable)Iterables.transform(args, (Function)new Function<Element, Optional<Configuration.ArgInfo>>(){

            public Optional<Configuration.ArgInfo> apply(Element arg) {
                TypeElement containingType = CmdLineProcessor.this.processArg(parsedTypes, arg, argAnnotation);
                if (containingType == null) {
                    return Optional.absent();
                }
                return Optional.of((Object)new Configuration.ArgInfo(CmdLineProcessor.this.getBinaryName(containingType), arg.getSimpleName().toString()));
            }
        }));
    }

    private Set<? extends Element> getAnnotatedElements(RoundEnvironment roundEnv, Class<? extends Annotation> argAnnotation) {
        return roundEnv.getElementsAnnotatedWith(this.typeElement(argAnnotation));
    }

    @Nullable
    private TypeElement processArg(@Nullable Set<String> parsedTypes, Element annotationElement, Class<? extends Annotation> annotationType) {
        TypeElement parserType = this.typeElement(Parser.class);
        if (annotationElement.getKind() != ElementKind.FIELD) {
            this.error("Found a @%s annotation on a non-field %s", annotationType.getSimpleName(), annotationElement);
            return null;
        }
        TypeElement containingType = (TypeElement)annotationElement.getEnclosingElement();
        if (!this.isAssignable(annotationElement.asType(), Arg.class)) {
            this.error("Found a @%s annotation on a non-Arg %s.%s", annotationType.getSimpleName(), containingType, annotationElement);
            return null;
        }
        if (!annotationElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.error("Found a @%s annotation on a non-static Arg field %s.%s", annotationType.getSimpleName(), containingType, annotationElement);
            return null;
        }
        if (parsedTypes != null) {
            TypeMirror typeArgument = this.getTypeArgument(annotationElement.asType(), this.typeElement(Arg.class));
            AnnotationMirror cmdLine = this.getAnnotationMirror(annotationElement, this.typeElement(annotationType));
            if (cmdLine != null) {
                TypeMirror customParserType = this.getClassType(cmdLine, "parser", parserType).asType();
                if (this.typeUtils.isSameType(parserType.asType(), customParserType)) {
                    if (!this.checkTypePresent(parsedTypes, typeArgument)) {
                        this.error("No parser registered for %s, %s.%s is un-parseable", typeArgument, containingType, annotationElement);
                    }
                } else {
                    TypeMirror customParsedType = this.getTypeArgument(customParserType, parserType);
                    if (!this.isAssignable(typeArgument, customParsedType)) {
                        this.error("Custom parser %s parses %s but registered for %s.%s with Arg type %s", customParserType, customParsedType, containingType, annotationElement, typeArgument);
                    }
                }
            }
        }
        return containingType;
    }

    private boolean checkTypePresent(Set<String> types, TypeMirror type) {
        Iterable<TypeMirror> allTypes = this.getAllTypes(type);
        for (TypeMirror t : allTypes) {
            if (!types.contains(((Object)this.typeUtils.erasure(t)).toString())) continue;
            return true;
        }
        return false;
    }

    private void processParsers(Set<? extends Element> elements) {
        TypeElement parserType = this.typeElement(Parser.class);
        for (Element element : elements) {
            if (element.getKind() != ElementKind.CLASS) {
                this.error("Found an @ArgParser annotation on a non-class %s", element);
                continue;
            }
            TypeElement parser = (TypeElement)element;
            if (!this.isAssignable(parser, Parser.class)) {
                this.error("Found an @ArgParser annotation on a non-Parser %s", element);
                return;
            }
            String parsedType = this.getTypeArgument(parser, parserType);
            if (parsedType == null) continue;
            this.configBuilder.addParser(parsedType, this.getBinaryName(parser));
        }
    }

    private void processVerifiers(Set<? extends Element> elements) {
        TypeElement verifierType = this.typeElement(Verifier.class);
        TypeElement verifierForType = this.typeElement(VerifierFor.class);
        for (Element element : elements) {
            String verifiedType;
            TypeElement verifyAnnotationType;
            if (element.getKind() != ElementKind.CLASS) {
                this.error("Found a @VerifierFor annotation on a non-class %s", element);
                continue;
            }
            TypeElement verifier = (TypeElement)element;
            if (!this.isAssignable(verifier, Verifier.class)) {
                this.error("Found a @Verifier annotation on a non-Verifier %s", element);
                return;
            }
            AnnotationMirror verifierFor = this.getAnnotationMirror(verifier, verifierForType);
            if (verifierFor == null || (verifyAnnotationType = this.getClassType(verifierFor, "value", null)) == null || (verifiedType = this.getTypeArgument(verifier, verifierType)) == null) continue;
            String verifyAnnotationClassName = this.elementUtils.getBinaryName(verifyAnnotationType).toString();
            this.configBuilder.addVerifier(verifiedType, verifyAnnotationClassName, this.getBinaryName(verifier));
        }
    }

    @Nullable
    private String getTypeArgument(TypeElement annotatedType, TypeElement baseType) {
        TypeMirror typeArgument = this.getTypeArgument(annotatedType.asType(), baseType);
        return typeArgument == null ? null : this.getBinaryName((TypeElement)this.typeUtils.asElement(typeArgument));
    }

    private Iterable<TypeMirror> getAllTypes(TypeMirror type) {
        return this.getAllTypes(new HashSet<String>(), Lists.newArrayList(), type);
    }

    private Iterable<TypeMirror> getAllTypes(Set<String> visitedTypes, List<TypeMirror> types, TypeMirror type) {
        String typeName = ((Object)this.typeUtils.erasure(type)).toString();
        if (!visitedTypes.contains(typeName)) {
            types.add(type);
            visitedTypes.add(typeName);
            for (TypeMirror typeMirror : this.typeUtils.directSupertypes(type)) {
                this.getAllTypes(visitedTypes, types, typeMirror);
            }
        }
        return types;
    }

    @Nullable
    private TypeMirror getTypeArgument(TypeMirror annotatedType, final TypeElement baseType) {
        for (TypeMirror type : this.getAllTypes(annotatedType)) {
            TypeMirror typeArgument = type.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

                @Override
                public TypeMirror visitDeclared(DeclaredType t, Void aVoid) {
                    List<? extends TypeMirror> typeArguments;
                    if (CmdLineProcessor.this.isAssignable(t, baseType) && !(typeArguments = t.getTypeArguments()).isEmpty()) {
                        return CmdLineProcessor.this.typeUtils.erasure(typeArguments.get(0));
                    }
                    return null;
                }
            }, null);
            if (typeArgument == null) continue;
            return typeArgument;
        }
        this.error("Failed to find a type argument for %s in %s", baseType, annotatedType);
        return null;
    }

    @Nullable
    private AnnotationMirror getAnnotationMirror(Element element, TypeElement annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), annotationType.asType())) continue;
            return annotationMirror;
        }
        this.error("Failed to find an annotation of type %s on %s", annotationType, element);
        return null;
    }

    private TypeElement getClassType(AnnotationMirror annotationMirror, String methodName, TypeElement defaultClassType) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            TypeElement classType;
            if (!((Object)entry.getKey().getSimpleName()).equals(this.elementUtils.getName(methodName)) || (classType = entry.getValue().accept(new SimpleAnnotationValueVisitor6<TypeElement, Void>(){

                @Override
                public TypeElement visitType(TypeMirror t, Void unused) {
                    return (TypeElement)CmdLineProcessor.this.processingEnv.getTypeUtils().asElement(t);
                }
            }, null)) == null) continue;
            return classType;
        }
        if (defaultClassType == null) {
            this.error("Could not find a class type for %s.%s", annotationMirror, methodName);
        }
        return defaultClassType;
    }

    @Nullable
    private FileObject createCommandLineDb(Configuration configuration) {
        String name = this.isMain ? Configuration.mainResourceName() : configuration.nextResourceName();
        try {
            return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, Configuration.DEFAULT_RESOURCE_PACKAGE, name, new Element[0]);
        }
        catch (IOException e) {
            this.error("Failed to create resource file to store %s/%s: %s", Configuration.DEFAULT_RESOURCE_PACKAGE, name, Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
    }

    @Nullable
    private Writer openCmdLinePropertiesResource(Configuration configuration) {
        FileObject resource = this.createCommandLineDb(configuration);
        if (resource == null) {
            return null;
        }
        try {
            this.log(Diagnostic.Kind.NOTE, "Writing %s", resource.toUri());
            return resource.openWriter();
        }
        catch (IOException e) {
            if (!resource.delete()) {
                this.log(Diagnostic.Kind.WARNING, "Failed to clean up %s after a failing to open it for writing", resource.toUri());
            }
            this.error("Failed to open resource file to store %s: %s", resource.toUri(), Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
    }

    private TypeElement typeElement(Class<?> type) {
        return this.elementUtils.getTypeElement(type.getName());
    }

    private String getBinaryName(TypeElement typeElement) {
        return this.elementUtils.getBinaryName(typeElement).toString();
    }

    private boolean isAssignable(TypeElement subType, Class<?> baseType) {
        return this.isAssignable(subType.asType(), baseType);
    }

    private boolean isAssignable(TypeMirror subType, Class<?> baseType) {
        return this.isAssignable(subType, this.typeElement(baseType));
    }

    private boolean isAssignable(TypeMirror subType, TypeElement baseType) {
        return this.isAssignable(subType, baseType.asType());
    }

    private boolean isAssignable(TypeMirror subType, TypeMirror baseType) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(subType), this.typeUtils.erasure(baseType));
    }

    private void error(String message, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, message, args);
    }

    private void log(Diagnostic.Kind kind, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(kind, String.format(message, args));
    }
}

