/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.StaticLoadBalancingStrategy;
import com.twitter.common.net.pool.ResourceExhaustedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;

public class LeastConnectedStrategy<S>
extends StaticLoadBalancingStrategy<S> {
    private static final Logger LOG = Logger.getLogger(LeastConnectedStrategy.class.getName());
    private final Map<S, ConnectionStats> connections = Maps.newHashMap();
    private final SortedSet<ConnectionStats> connectionStats = Sets.newTreeSet();

    @Override
    protected Collection<S> onBackendsOffered(Set<S> backends) {
        HashMap newConnections = Maps.newHashMapWithExpectedSize((int)backends.size());
        ArrayList newConnectionStats = Lists.newArrayListWithCapacity((int)backends.size());
        int backendId = 0;
        for (S backend : backends) {
            ConnectionStats stats = new ConnectionStats(backend, backendId++);
            ConnectionStats existing = this.connections.get(backend);
            if (existing != null) {
                stats.activeCount = existing.activeCount;
            }
            newConnections.put(backend, stats);
            newConnectionStats.add(stats);
        }
        this.connections.clear();
        this.connections.putAll(newConnections);
        this.connectionStats.clear();
        this.connectionStats.addAll(newConnectionStats);
        return this.connections.keySet();
    }

    @Override
    public S nextBackend() throws ResourceExhaustedException {
        Preconditions.checkState((this.connections.size() == this.connectionStats.size() ? 1 : 0) != 0);
        if (this.connectionStats.isEmpty()) {
            throw new ResourceExhaustedException("No backends.");
        }
        return this.connectionStats.first().connectionKey;
    }

    @Override
    public void addConnectResult(S backendKey, LoadBalancingStrategy.ConnectionResult result, long connectTimeNanos) {
        Preconditions.checkNotNull(backendKey);
        Preconditions.checkState((this.connections.size() == this.connectionStats.size() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)result));
        ConnectionStats stats = this.connections.get(backendKey);
        Preconditions.checkNotNull((Object)stats);
        Preconditions.checkState((boolean)this.connectionStats.remove(stats));
        if (result == LoadBalancingStrategy.ConnectionResult.SUCCESS) {
            ++stats.activeCount;
        }
        ++stats.useCount;
        Preconditions.checkState((boolean)this.connectionStats.add(stats));
    }

    @Override
    public void connectionReturned(S backendKey) {
        Preconditions.checkNotNull(backendKey);
        Preconditions.checkState((this.connections.size() == this.connectionStats.size() ? 1 : 0) != 0);
        ConnectionStats stats = this.connections.get(backendKey);
        Preconditions.checkNotNull((Object)stats);
        if (stats.activeCount > 0) {
            Preconditions.checkState((boolean)this.connectionStats.remove(stats));
            --stats.activeCount;
            Preconditions.checkState((boolean)this.connectionStats.add(stats));
        } else {
            LOG.warning("connection stats dropped below zero, ignoring");
        }
    }

    private class ConnectionStats
    implements Comparable<ConnectionStats> {
        final S connectionKey;
        final int connectionId;
        int activeCount = 0;
        long useCount = 0L;

        ConnectionStats(S connectionKey, int connectionId) {
            this.connectionKey = connectionKey;
            this.connectionId = connectionId;
        }

        @Override
        public int compareTo(ConnectionStats other) {
            int difference = this.activeCount - other.activeCount;
            if (difference != 0) {
                return difference;
            }
            long useDifference = this.useCount - other.useCount;
            if (useDifference != 0L) {
                return Long.signum(useDifference);
            }
            return this.connectionId - other.connectionId;
        }

        public boolean equals(Object o) {
            ConnectionStats other = (ConnectionStats)o;
            return this.compareTo(other) == 0;
        }

        public String toString() {
            return String.format("%d-%d", this.activeCount, this.useCount);
        }
    }
}

