/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.twitter.common.base.Closure;
import com.twitter.common.net.loadbalancing.LoadBalancer;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.pool.ResourceExhaustedException;
import java.util.Collection;
import java.util.Set;

public class LoadBalancerImpl<K>
implements LoadBalancer<K> {
    private final LoadBalancingStrategy<K> strategy;
    private Set<K> offeredBackends = ImmutableSet.of();

    public LoadBalancerImpl(LoadBalancingStrategy<K> strategy) {
        this.strategy = (LoadBalancingStrategy)Preconditions.checkNotNull(strategy);
    }

    @Override
    public synchronized void offerBackends(Set<K> offeredBackends, final Closure<Collection<K>> onBackendsChosen) {
        this.offeredBackends = ImmutableSet.copyOf(offeredBackends);
        this.strategy.offerBackends(offeredBackends, new Closure<Collection<K>>(){

            public void execute(Collection<K> chosenBackends) {
                onBackendsChosen.execute(chosenBackends);
            }
        });
    }

    @Override
    public synchronized K nextBackend() throws ResourceExhaustedException {
        return this.strategy.nextBackend();
    }

    @Override
    public synchronized void connected(K backend, long connectTimeNanos) {
        Preconditions.checkNotNull(backend);
        if (!this.hasBackend(backend)) {
            return;
        }
        this.strategy.addConnectResult(backend, LoadBalancingStrategy.ConnectionResult.SUCCESS, connectTimeNanos);
    }

    private boolean hasBackend(K backend) {
        return this.offeredBackends.contains(backend);
    }

    @Override
    public synchronized void connectFailed(K backend, LoadBalancingStrategy.ConnectionResult result) {
        Preconditions.checkNotNull(backend);
        Preconditions.checkNotNull((Object)((Object)result));
        Preconditions.checkArgument((result != LoadBalancingStrategy.ConnectionResult.SUCCESS ? 1 : 0) != 0);
        if (!this.hasBackend(backend)) {
            return;
        }
        this.strategy.addConnectResult(backend, result, 0L);
    }

    @Override
    public synchronized void released(K backend) {
        Preconditions.checkNotNull(backend);
        if (!this.hasBackend(backend)) {
            return;
        }
        this.strategy.connectionReturned(backend);
    }

    @Override
    public synchronized void requestResult(K backend, RequestTracker.RequestResult result, long requestTimeNanos) {
        Preconditions.checkNotNull(backend);
        Preconditions.checkNotNull((Object)((Object)result));
        if (!this.hasBackend(backend)) {
            return;
        }
        this.strategy.addRequestResult(backend, result, requestTimeNanos);
    }

    public static <K> LoadBalancerImpl<K> create(LoadBalancingStrategy<K> strategy) {
        return new LoadBalancerImpl<K>(strategy);
    }
}

