/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.twitter.common.base.Closure;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.pool.ResourceExhaustedException;
import com.twitter.common.util.BackoffDecider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class MarkDeadStrategy<S>
implements LoadBalancingStrategy<S> {
    private static final Logger LOG = Logger.getLogger(MarkDeadStrategy.class.getName());
    private final LoadBalancingStrategy<S> wrappedStrategy;
    private final Map<S, BackoffDecider> targets = Maps.newHashMap();
    private final Function<S, BackoffDecider> backoffFactory;
    protected final Predicate<S> hostChecker;
    private Set<S> liveBackends = null;
    private Closure<Collection<S>> onBackendsChosen = null;
    private boolean forcedLive = false;
    private final Predicate<S> deadTargetFilter = new Predicate<S>(){

        public boolean apply(S backend) {
            return !((BackoffDecider)MarkDeadStrategy.this.targets.get(backend)).shouldBackOff();
        }
    };

    public MarkDeadStrategy(LoadBalancingStrategy<S> wrappedStrategy, Function<S, BackoffDecider> backoffFactory, Predicate<S> hostChecker) {
        this.wrappedStrategy = (LoadBalancingStrategy)Preconditions.checkNotNull(wrappedStrategy);
        this.backoffFactory = (Function)Preconditions.checkNotNull(backoffFactory);
        this.hostChecker = (Predicate)Preconditions.checkNotNull(hostChecker);
    }

    public MarkDeadStrategy(LoadBalancingStrategy<S> wrappedStrategy, Function<S, BackoffDecider> backoffFactory) {
        this(wrappedStrategy, backoffFactory, Predicates.alwaysTrue());
    }

    @Override
    public void offerBackends(Set<S> offeredBackends, Closure<Collection<S>> onBackendsChosen) {
        this.onBackendsChosen = onBackendsChosen;
        this.targets.keySet().retainAll(offeredBackends);
        for (S backend : offeredBackends) {
            if (this.targets.containsKey(backend)) continue;
            this.targets.put(backend, (BackoffDecider)this.backoffFactory.apply(backend));
        }
        this.adjustBackends();
    }

    @Override
    public void addConnectResult(S backendKey, LoadBalancingStrategy.ConnectionResult result, long connectTimeNanos) {
        Preconditions.checkNotNull(backendKey);
        Preconditions.checkNotNull((Object)((Object)result));
        BackoffDecider decider = this.targets.get(backendKey);
        Preconditions.checkNotNull((Object)decider);
        this.addResult(decider, result);
        if (this.shouldNotifyFor(backendKey)) {
            this.wrappedStrategy.addConnectResult(backendKey, result, connectTimeNanos);
        }
    }

    @Override
    public void connectionReturned(S backendKey) {
        Preconditions.checkNotNull(backendKey);
        if (this.shouldNotifyFor(backendKey)) {
            this.wrappedStrategy.connectionReturned(backendKey);
        }
    }

    @Override
    public void addRequestResult(S requestKey, RequestTracker.RequestResult result, long requestTimeNanos) {
        Preconditions.checkNotNull(requestKey);
        Preconditions.checkNotNull((Object)((Object)result));
        BackoffDecider decider = this.targets.get(requestKey);
        Preconditions.checkNotNull((Object)decider);
        this.addResult(decider, result);
        if (this.shouldNotifyFor(requestKey)) {
            this.wrappedStrategy.addRequestResult(requestKey, result, requestTimeNanos);
        }
    }

    private void addResult(BackoffDecider decider, LoadBalancingStrategy.ConnectionResult result) {
        switch (result) {
            case FAILED: 
            case TIMEOUT: {
                this.addResult(decider, false);
                break;
            }
            case SUCCESS: {
                this.addResult(decider, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled result type " + (Object)((Object)result));
            }
        }
    }

    private void addResult(BackoffDecider decider, RequestTracker.RequestResult result) {
        switch (result) {
            case FAILED: 
            case TIMEOUT: {
                this.addResult(decider, false);
                break;
            }
            case SUCCESS: {
                this.addResult(decider, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled result type " + (Object)((Object)result));
            }
        }
    }

    private void addResult(BackoffDecider decider, boolean success) {
        if (success) {
            decider.addSuccess();
        } else {
            decider.addFailure();
        }
        for (Map.Entry<S, BackoffDecider> entry : this.targets.entrySet()) {
            boolean markedDead;
            boolean dead = entry.getValue().shouldBackOff();
            boolean bl = markedDead = !this.liveBackends.contains(entry.getKey());
            if (markedDead && !dead) {
                boolean alive = this.hostChecker.apply(entry.getKey());
                if (!alive) {
                    entry.getValue().transitionToBackOff(0.0, true);
                }
                boolean bl2 = dead = !alive;
            }
            if (dead && !markedDead && this.forcedLive || dead == markedDead && (dead || !this.forcedLive)) continue;
            this.adjustBackends();
            break;
        }
    }

    private boolean shouldNotifyFor(S backend) {
        return this.liveBackends.contains(backend);
    }

    private void adjustBackends() {
        this.liveBackends = Sets.newHashSet((Iterable)Iterables.filter(this.targets.keySet(), this.deadTargetFilter));
        if (this.liveBackends.isEmpty()) {
            this.liveBackends = this.targets.keySet();
            this.forcedLive = true;
        } else {
            this.forcedLive = false;
        }
        LOG.info("Observed backend state change, changing live backends to " + this.liveBackends);
        this.wrappedStrategy.offerBackends(this.liveBackends, this.onBackendsChosen);
    }

    @Override
    public S nextBackend() throws ResourceExhaustedException {
        return this.wrappedStrategy.nextBackend();
    }
}

