/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.MarkDeadStrategy;
import com.twitter.common.util.BackoffDecider;
import java.util.Map;

public class MarkDeadStrategyWithHostCheck<S>
extends MarkDeadStrategy<S> {
    protected final LiveHostChecker<S> liveHostChecker;

    public MarkDeadStrategyWithHostCheck(LoadBalancingStrategy<S> wrappedStrategy, Function<S, BackoffDecider> backoffFactory) {
        super(wrappedStrategy, backoffFactory, new LiveHostChecker());
        this.liveHostChecker = (LiveHostChecker)this.hostChecker;
    }

    @Override
    public void addConnectResult(S backendKey, LoadBalancingStrategy.ConnectionResult result, long connectTimeNanos) {
        this.liveHostChecker.addConnectResult(backendKey, result);
        super.addConnectResult(backendKey, result, connectTimeNanos);
    }

    protected static class LiveHostChecker<S>
    implements Predicate<S> {
        private final Map<S, LoadBalancingStrategy.ConnectionResult> lastConnectionResult = Maps.newHashMap();

        protected LiveHostChecker() {
        }

        public void addConnectResult(S backend, LoadBalancingStrategy.ConnectionResult result) {
            this.lastConnectionResult.put(backend, result);
        }

        public boolean apply(S backend) {
            LoadBalancingStrategy.ConnectionResult result = this.lastConnectionResult.get(backend);
            return result != null && result == LoadBalancingStrategy.ConnectionResult.SUCCESS;
        }
    }
}

