/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.twitter.common.base.Closure;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.pool.ResourceExhaustedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class SubsetStrategy<S>
implements LoadBalancingStrategy<S> {
    private final LoadBalancingStrategy<S> wrapped;
    private final int maxBackends;
    private Set<S> backendSubset = Sets.newHashSet();

    public SubsetStrategy(int maxBackends, LoadBalancingStrategy<S> wrapped) {
        Preconditions.checkArgument((maxBackends > 0 ? 1 : 0) != 0);
        this.maxBackends = maxBackends;
        this.wrapped = (LoadBalancingStrategy)Preconditions.checkNotNull(wrapped);
    }

    @Override
    public void offerBackends(Set<S> offeredBackends, Closure<Collection<S>> onBackendsChosen) {
        ArrayList allTargets = Lists.newArrayList(offeredBackends);
        Collections.shuffle(allTargets);
        this.backendSubset = ImmutableSet.copyOf(allTargets.subList(0, Math.min(this.maxBackends, allTargets.size())));
        this.wrapped.offerBackends(this.backendSubset, onBackendsChosen);
    }

    @Override
    public void addConnectResult(S backendKey, LoadBalancingStrategy.ConnectionResult result, long connectTimeNanos) {
        if (this.backendSubset.contains(backendKey)) {
            this.wrapped.addConnectResult(backendKey, result, connectTimeNanos);
        }
    }

    @Override
    public void connectionReturned(S backendKey) {
        if (this.backendSubset.contains(backendKey)) {
            this.wrapped.connectionReturned(backendKey);
        }
    }

    @Override
    public void addRequestResult(S requestKey, RequestTracker.RequestResult result, long requestTimeNanos) {
        Preconditions.checkNotNull(requestKey);
        if (this.backendSubset.contains(requestKey)) {
            this.wrapped.addRequestResult(requestKey, result, requestTimeNanos);
        }
    }

    @Override
    public S nextBackend() throws ResourceExhaustedException {
        return this.wrapped.nextBackend();
    }
}

