/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.loadbalancing;

import com.google.common.base.Preconditions;
import com.twitter.common.base.Closure;
import com.twitter.common.net.loadbalancing.LoadBalancingStrategy;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.monitoring.TrafficMonitor;
import com.twitter.common.net.pool.ResourceExhaustedException;
import java.util.Collection;
import java.util.Set;

public class TrafficMonitorAdapter<K>
implements LoadBalancingStrategy<K> {
    private final LoadBalancingStrategy<K> strategy;
    private final TrafficMonitor<K> monitor;

    public TrafficMonitorAdapter(LoadBalancingStrategy<K> strategy, TrafficMonitor<K> monitor) {
        this.strategy = (LoadBalancingStrategy)Preconditions.checkNotNull(strategy);
        this.monitor = (TrafficMonitor)Preconditions.checkNotNull(monitor);
    }

    public static <K> TrafficMonitorAdapter<K> create(LoadBalancingStrategy<K> strategy, TrafficMonitor<K> monitor) {
        return new TrafficMonitorAdapter<K>(strategy, monitor);
    }

    @Override
    public void offerBackends(Set<K> offeredBackends, Closure<Collection<K>> onBackendsChosen) {
        this.strategy.offerBackends(offeredBackends, onBackendsChosen);
    }

    @Override
    public K nextBackend() throws ResourceExhaustedException {
        return this.strategy.nextBackend();
    }

    @Override
    public void addConnectResult(K key, LoadBalancingStrategy.ConnectionResult result, long connectTimeNanos) {
        this.strategy.addConnectResult(key, result, connectTimeNanos);
        if (result == LoadBalancingStrategy.ConnectionResult.SUCCESS) {
            this.monitor.connected(key);
        }
    }

    @Override
    public void connectionReturned(K key) {
        this.strategy.connectionReturned(key);
        this.monitor.released(key);
    }

    @Override
    public void addRequestResult(K key, RequestTracker.RequestResult result, long requestTimeNanos) {
        this.strategy.addRequestResult(key, result, requestTimeNanos);
        this.monitor.requestResult(key, result, requestTimeNanos);
    }
}

