/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net.pool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.twitter.common.base.Closure;
import com.twitter.common.net.loadbalancing.LoadBalancer;
import com.twitter.common.net.pool.Connection;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.net.pool.MetaPool;
import com.twitter.common.net.pool.ObjectPool;
import com.twitter.common.net.pool.ResourceExhaustedException;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class DynamicPool<H, T, E>
implements ObjectPool<Connection<T, E>> {
    private final MetaPool<T, E> pool;

    public DynamicPool(DynamicHostSet<H> hostSet, Function<E, ObjectPool<Connection<T, E>>> endpointPoolFactory, LoadBalancer<E> loadBalancer, Closure<Collection<E>> onBackendsChosen, Amount<Long, Time> restoreInterval, Function<H, E> endpointExtractor, Predicate<H> livenessChecker) throws DynamicHostSet.MonitorException {
        Preconditions.checkNotNull(hostSet);
        Preconditions.checkNotNull(endpointPoolFactory);
        this.pool = new MetaPool(loadBalancer, onBackendsChosen, restoreInterval);
        hostSet.monitor((DynamicHostSet.HostChangeMonitor)new PoolMonitor<H, Connection<T, E>>((Function)endpointPoolFactory, (Function)endpointExtractor, (Predicate)livenessChecker){

            @Override
            protected void onPoolRebuilt(Set<ObjectPool<Connection<T, E>>> deadPools, Map<E, ObjectPool<Connection<T, E>>> livePools) {
                DynamicPool.this.poolRebuilt(deadPools, livePools);
            }
        });
    }

    @VisibleForTesting
    void poolRebuilt(Set<ObjectPool<Connection<T, E>>> deadPools, Map<E, ObjectPool<Connection<T, E>>> livePools) {
        this.pool.setBackends(livePools);
        for (ObjectPool<Connection<T, E>> deadTargetPool : deadPools) {
            deadTargetPool.close();
        }
    }

    @Override
    public Connection<T, E> get() throws ResourceExhaustedException, TimeoutException {
        return this.pool.get();
    }

    @Override
    public Connection<T, E> get(Amount<Long, Time> timeout) throws ResourceExhaustedException, TimeoutException {
        return this.pool.get((Amount)timeout);
    }

    @Override
    public void release(Connection<T, E> connection) {
        this.pool.release(connection);
    }

    @Override
    public void remove(Connection<T, E> connection) {
        this.pool.remove(connection);
    }

    @Override
    public void close() {
        this.pool.close();
    }

    private abstract class PoolMonitor<H, S extends Connection<?, ?>>
    implements DynamicHostSet.HostChangeMonitor<H> {
        private final Function<E, ObjectPool<S>> endpointPoolFactory;
        private final Function<H, E> endpointExtractor;
        private final Predicate<H> livenessTest;
        private final Map<E, ObjectPool<S>> endpointPools = Maps.newHashMap();

        public PoolMonitor(Function<E, ObjectPool<S>> endpointPoolFactory, Function<H, E> endpointExtractor, Predicate<H> livenessTest) {
            this.endpointPoolFactory = endpointPoolFactory;
            this.endpointExtractor = endpointExtractor;
            this.livenessTest = livenessTest;
        }

        public synchronized void onChange(ImmutableSet<H> serverSet) {
            ImmutableMap newEndpoints = Maps.uniqueIndex((Iterable)Iterables.filter(serverSet, this.livenessTest), this.endpointExtractor);
            ImmutableSet deadEndpoints = ImmutableSet.copyOf((Collection)Sets.difference(this.endpointPools.keySet(), newEndpoints.keySet()));
            HashSet deadPools = Sets.newHashSet();
            for (Object endpoint : deadEndpoints) {
                ObjectPool<S> deadPool = this.endpointPools.remove(endpoint);
                deadPools.add(deadPool);
            }
            ImmutableSet addedEndpoints = ImmutableSet.copyOf((Collection)Sets.difference(newEndpoints.keySet(), this.endpointPools.keySet()));
            for (Object endpoint : addedEndpoints) {
                ObjectPool endpointPool = (ObjectPool)this.endpointPoolFactory.apply(endpoint);
                this.endpointPools.put(endpoint, endpointPool);
            }
            this.onPoolRebuilt(deadPools, (Map)ImmutableMap.copyOf(this.endpointPools));
        }

        protected abstract void onPoolRebuilt(Set<ObjectPool<S>> var1, Map<E, ObjectPool<S>> var2);
    }
}

