/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import com.twitter.common.util.Sampler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nullable;

public class Percentile<T extends Number> {
    @VisibleForTesting
    static final int MAX_BUFFER_SIZE = 10001;
    private final Sampler sampler;
    private final Map<Double, SampledStat<Double>> statsByPercentile;
    @VisibleForTesting
    final LinkedList<T> samples = Lists.newLinkedList();
    private final LinkedBlockingDeque<ArrayList<T>> sampleQueue;
    private final ArrayList<T> allSamples = new ArrayList();

    public Percentile(String name, float samplePercent, double ... percentiles) {
        this(name, new Sampler(samplePercent), percentiles);
    }

    public Percentile(String name, Sampler sampler, double ... percentiles) {
        this(name, 1, sampler, percentiles);
    }

    public Percentile(String name, int numSampleWindows, @Nullable Sampler sampler, double ... percentiles) {
        MorePreconditions.checkNotBlank((String)name);
        Preconditions.checkArgument((numSampleWindows >= 1 ? 1 : 0) != 0, (Object)"Must have one or more sample windows.");
        Preconditions.checkNotNull((Object)percentiles);
        Preconditions.checkArgument((percentiles.length > 0 ? 1 : 0) != 0, (Object)"Must specify at least one percentile.");
        this.sampler = sampler;
        this.sampleQueue = new LinkedBlockingDeque(numSampleWindows);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (int i = 0; i < percentiles.length; ++i) {
            boolean sortFirst = i == 0;
            String statName = String.format("%s_%s_percentile", name, percentiles[i]).replace('.', '_');
            PercentileVar stat = new PercentileVar(statName, percentiles[i], sortFirst);
            Stats.export(stat);
            builder.put((Object)percentiles[i], (Object)stat);
        }
        this.statsByPercentile = builder.build();
    }

    public Map<Double, ? extends Stat> getPercentiles() {
        return ImmutableMap.copyOf(this.statsByPercentile);
    }

    @VisibleForTesting
    SampledStat<Double> getPercentile(double percentile) {
        return this.statsByPercentile.get(percentile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(T value) {
        if (this.sampler == null || this.sampler.select()) {
            LinkedList<T> linkedList = this.samples;
            synchronized (linkedList) {
                this.samples.addLast(value);
                while (this.samples.size() > 10001) {
                    this.samples.removeFirst();
                }
            }
        }
    }

    private class PercentileVar
    extends SampledStat<Double> {
        private final double percentile;
        private final boolean sortFirst;

        PercentileVar(String name, double percentile2, boolean sortFirst) {
            super(name, 0.0);
            this.percentile = percentile2;
            this.sortFirst = sortFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Double doSample() {
            LinkedList linkedList = Percentile.this.samples;
            synchronized (linkedList) {
                if (this.sortFirst) {
                    if (Percentile.this.sampleQueue.remainingCapacity() == 0) {
                        Percentile.this.sampleQueue.removeFirst();
                    }
                    Percentile.this.sampleQueue.addLast(new ArrayList(Percentile.this.samples));
                    Percentile.this.samples.clear();
                    Percentile.this.allSamples.clear();
                    for (ArrayList sample : Percentile.this.sampleQueue) {
                        Percentile.this.allSamples.addAll(sample);
                    }
                    Collections.sort(Percentile.this.allSamples, Ordering.natural());
                }
                if (Percentile.this.allSamples.isEmpty()) {
                    return 0.0;
                }
                int maxIndex = Percentile.this.allSamples.size() - 1;
                double selectIndex = (double)maxIndex * this.percentile / 100.0;
                selectIndex = selectIndex < 0.0 ? 0.0 : selectIndex;
                int indexLeft = (int)(selectIndex = selectIndex > (double)maxIndex ? (double)maxIndex : selectIndex);
                if (indexLeft == maxIndex) {
                    return ((Number)Percentile.this.allSamples.get(indexLeft)).doubleValue();
                }
                double residue = selectIndex - (double)indexLeft;
                return ((Number)Percentile.this.allSamples.get(indexLeft)).doubleValue() * (1.0 - residue) + ((Number)Percentile.this.allSamples.get(indexLeft + 1)).doubleValue() * residue;
            }
        }
    }
}

