/*
 * Decompiled with CFR 0.152.
 */
package com.uber.m3.util;

public class Duration
implements Comparable<Duration> {
    public static final Duration ZERO = new Duration(0L);
    public static final Duration MIN_VALUE = new Duration(Long.MIN_VALUE);
    public static final Duration MAX_VALUE = new Duration(Long.MAX_VALUE);
    public static final long NANOS_PER_MICRO = 1000L;
    public static final long NANOS_PER_MILLI = 1000000L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    private static final int STRING_BUILDER_INIT_CAP = 25;
    private final long nanos;

    private Duration(long nanos) {
        this.nanos = nanos;
    }

    public static Duration ofNanos(long nanos) {
        return new Duration(nanos);
    }

    public static Duration ofMillis(double millis) {
        Duration.checkMultiplicationLongOverflow(millis, 1000000.0);
        return new Duration((long)(millis * 1000000.0));
    }

    public static Duration ofSeconds(double seconds) {
        Duration.checkMultiplicationLongOverflow(seconds, 1.0E9);
        return new Duration((long)(seconds * 1.0E9));
    }

    public static Duration ofMinutes(double minutes) {
        Duration.checkMultiplicationLongOverflow(minutes, 6.0E10);
        return new Duration((long)(minutes * 6.0E10));
    }

    public static Duration ofHours(double hours) {
        Duration.checkMultiplicationLongOverflow(hours, 3.6E12);
        return new Duration((long)(hours * 3.6E12));
    }

    public long toMillis() {
        return this.nanos / 1000000L;
    }

    public long getNanos() {
        return this.nanos;
    }

    public double getSeconds() {
        return (double)this.nanos / 1.0E9;
    }

    public static Duration between(long startNanos, long endNanos) {
        return new Duration(endNanos - startNanos);
    }

    @Override
    public int compareTo(Duration other) {
        return Long.compare(this.nanos, other.nanos);
    }

    public String toString() {
        if (this.nanos == 0L) {
            return "0s";
        }
        if (this.nanos == Long.MIN_VALUE) {
            return "-2562047h47m16.854775808s";
        }
        boolean isNegative = this.nanos < 0L;
        long nanosLocal = Math.abs(this.nanos);
        long hours = nanosLocal / 3600000000000L;
        int minutes = (int)(nanosLocal % 3600000000000L / 60000000000L);
        long secondsInNanos = nanosLocal % 60000000000L;
        int nanoOffset = (int)(nanosLocal % 1000000000L);
        StringBuilder buf = new StringBuilder(25);
        if (isNegative) {
            buf.append("-");
        }
        if (hours != 0L) {
            buf.append(hours).append("h");
        }
        if (minutes != 0) {
            buf.append(minutes).append("m");
        }
        if (secondsInNanos / 1000000000L > 0L) {
            Duration.appendDurationSegment(buf, secondsInNanos, 9, "s");
        } else if (nanoOffset > 0) {
            if ((long)nanoOffset / 1000000L > 0L) {
                Duration.appendDurationSegment(buf, nanoOffset, 6, "ms");
            } else if ((long)nanoOffset / 1000L > 0L) {
                Duration.appendDurationSegment(buf, (long)nanoOffset % 1000000L, 3, "\u00b5s");
            } else {
                buf.append(nanoOffset).append("ns");
            }
        }
        return buf.toString();
    }

    private static void appendDurationSegment(StringBuilder buf, long durationPart, int exponent, String suffix) {
        buf.append(durationPart);
        int decimalIdx = buf.length() - exponent;
        while (decimalIdx < buf.length() && buf.charAt(buf.length() - 1) == '0') {
            buf.setLength(buf.length() - 1);
        }
        if (decimalIdx < buf.length()) {
            buf.insert(decimalIdx, '.');
        }
        buf.append(suffix);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        return this.nanos == ((Duration)other).nanos;
    }

    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    public Duration add(Duration otherDuration) {
        Duration.checkAdditionLongOverflow(this.nanos, otherDuration.nanos);
        return new Duration(this.nanos + otherDuration.nanos);
    }

    public Duration multiply(double factor) {
        Duration.checkMultiplicationLongOverflow(this.nanos, factor);
        long newNanos = (long)((double)this.nanos * factor);
        if ((double)newNanos != (double)this.nanos * factor) {
            throw new IllegalArgumentException("Unable to create a precise Duration with the specified factor");
        }
        return new Duration(newNanos);
    }

    private static void checkAdditionLongOverflow(long input1, long input2) {
        long sum = input1 + input2;
        if (((input1 ^ sum) & (input2 ^ sum)) < 0L) {
            throw new ArithmeticException(String.format("Addition of %d and %d will cause long overflow", input1, input2));
        }
    }

    private static void checkMultiplicationLongOverflow(double input, double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("factor cannot be negative");
        }
        if (input > 0.0 && input > 9.223372036854776E18 / factor || input < 0.0 && input < -9.223372036854776E18 / factor) {
            throw new ArithmeticException("Duration of this magnitude not supported");
        }
    }
}

