/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class AuthenticationScheme {
    public static final AttributeValueResolver<AuthenticationScheme> AUTHENTICATION_SCHEME_RESOLVER = new AttributeValueResolver<AuthenticationScheme>(){

        @Override
        public AuthenticationScheme toInstance(SCIMAttributeValue value) {
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            return new AuthenticationScheme((String)value.getSubAttributeValue("name", STRING_RESOLVER), (String)value.getSubAttributeValue("description", STRING_RESOLVER), (String)value.getSubAttributeValue("specUrl", STRING_RESOLVER), (String)value.getSubAttributeValue("documentationUrl", STRING_RESOLVER), (String)value.getSubAttributeValue("type", STRING_RESOLVER), p == null ? false : p);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor addressDescriptor, AuthenticationScheme value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(8);
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.name != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("name"), SCIMAttributeValue.createStringValue(value.name)));
            }
            if (value.description != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("description"), SCIMAttributeValue.createStringValue(value.description)));
            }
            if (value.specUrl != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("specUrl"), SCIMAttributeValue.createStringValue(value.specUrl)));
            }
            if (value.documentationUrl != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("documentationUrl"), SCIMAttributeValue.createStringValue(value.documentationUrl)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private String name;
    private String description;
    private String specUrl;
    private String documentationUrl;
    private String type;
    private boolean primary;

    public AuthenticationScheme(String name, String description, String specUrl, String documentationUrl, String type, boolean primary) {
        this.name = name;
        this.description = description;
        this.specUrl = specUrl;
        this.documentationUrl = documentationUrl;
        this.primary = primary;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSpecUrl() {
        return this.specUrl;
    }

    public void setSpecUrl(String specUrl) {
        this.specUrl = specUrl;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationScheme that = (AuthenticationScheme)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.documentationUrl != null ? !this.documentationUrl.equals(that.documentationUrl) : that.documentationUrl != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.specUrl != null ? !this.specUrl.equals(that.specUrl) : that.specUrl != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.specUrl != null ? this.specUrl.hashCode() : 0);
        result = 31 * result + (this.documentationUrl != null ? this.documentationUrl.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationScheme");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", specUrl='").append(this.specUrl).append('\'');
        sb.append(", documentationUrl='").append(this.documentationUrl).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", primary=").append(this.primary);
        sb.append('}');
        return sb.toString();
    }

    public static AuthenticationScheme createBasic(boolean primary) {
        return new AuthenticationScheme("Http Basic", "The HTTP Basic Access Authentication scheme. This scheme is not considered to be a secure method of user authentication (unless used in conjunction with some external secure system such as SSL), as the user name and password are passed over the network as cleartext.", "http://www.ietf.org/rfc/rfc2617.txt", "http://en.wikipedia.org/wiki/Basic_access_authentication", "httpbasic", primary);
    }

    public static AuthenticationScheme createOAuth2(boolean primary) {
        return new AuthenticationScheme("OAuth 2.0", "The OAuth 2.0 Bearer Token Authentication scheme. OAuth enables clients to access protected resources by obtaining an access token, which is defined in RFC 6750 as \"a string representing an access authorization issued to the client\", rather than using the resource owner's credentials directly.", "http://tools.ietf.org/html/rfc6750", "http://oauth.net/2/", "oauth2", primary);
    }
}

