/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.MultiValuedSCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMFilter;
import com.unboundid.scim.sdk.SCIMFilterType;
import com.unboundid.scim.sdk.SimpleValue;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public final class SCIMAttribute {
    private final AttributeDescriptor attributeDescriptor;
    private final SCIMAttributeValue[] values;

    private SCIMAttribute(AttributeDescriptor descriptor, SCIMAttributeValue ... values) {
        this.attributeDescriptor = descriptor;
        this.values = values;
    }

    public static SCIMAttribute create(AttributeDescriptor descriptor, SCIMAttributeValue ... values) {
        SCIMAttributeValue[] valuesCopy;
        if (values != null) {
            valuesCopy = new SCIMAttributeValue[values.length];
            if (descriptor.isMultiValued()) {
                int i = 0;
                for (SCIMAttributeValue value : values) {
                    if (!(value instanceof MultiValuedSCIMAttributeValue)) {
                        SCIMAttribute valueSubAttribute;
                        if (value.isComplex()) {
                            valuesCopy[i++] = new MultiValuedSCIMAttributeValue(value.getAttributes());
                            continue;
                        }
                        try {
                            valueSubAttribute = new SCIMAttribute(descriptor.getSubAttribute("value"), value);
                        }
                        catch (InvalidResourceException e) {
                            throw new IllegalArgumentException("Values of multi-valued attributes must be complex when the normative value sub-attribute is not defined");
                        }
                        valuesCopy[i++] = new MultiValuedSCIMAttributeValue(Collections.singletonMap("value", valueSubAttribute));
                        continue;
                    }
                    valuesCopy[i++] = value;
                }
            } else {
                System.arraycopy(values, 0, valuesCopy, 0, values.length);
            }
        } else {
            valuesCopy = new SCIMAttributeValue[]{};
        }
        return new SCIMAttribute(descriptor, valuesCopy);
    }

    public String getSchema() {
        return this.attributeDescriptor.getSchema();
    }

    public String getName() {
        return this.attributeDescriptor.getName();
    }

    public SCIMAttributeValue getValue() {
        return this.values[0];
    }

    public SCIMAttributeValue[] getValues() {
        return this.values;
    }

    public AttributeDescriptor getAttributeDescriptor() {
        return this.attributeDescriptor;
    }

    public boolean matchesFilter(SCIMFilter filter) {
        SCIMFilterType type = filter.getFilterType();
        List<SCIMFilter> components = filter.getFilterComponents();
        switch (type) {
            case AND: {
                for (SCIMFilter component : components) {
                    if (this.matchesFilter(component)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (SCIMFilter component : components) {
                    if (!this.matchesFilter(component)) continue;
                    return true;
                }
                return false;
            }
        }
        String schema = filter.getFilterAttribute().getAttributeSchema();
        if (!schema.equalsIgnoreCase(this.getSchema())) {
            return false;
        }
        String attributeName = filter.getFilterAttribute().getAttributeName();
        String subAttributeName = filter.getFilterAttribute().getSubAttributeName();
        if (subAttributeName == null) {
            subAttributeName = "value";
        }
        if (!attributeName.equalsIgnoreCase(this.getName())) {
            return false;
        }
        if (this.attributeDescriptor.isMultiValued()) {
            for (SCIMAttributeValue v : this.getValues()) {
                if (v.isComplex()) {
                    Collection<AttributeDescriptor> descriptors = this.attributeDescriptor.getSubAttributes();
                    for (AttributeDescriptor descriptor : descriptors) {
                        AttributePath childPath;
                        SCIMAttribute a = v.getAttribute(descriptor.getName());
                        if (a == null || !a.matchesFilter(new SCIMFilter(type, childPath = new AttributePath(schema, a.getName(), subAttributeName), filter.getFilterValue(), filter.isQuoteFilterValue(), filter.getFilterComponents()))) continue;
                        return true;
                    }
                    continue;
                }
                AttributeDescriptor singularDescriptor = AttributeDescriptor.createAttribute(this.getName(), this.attributeDescriptor.getDataType(), this.attributeDescriptor.getDescription(), this.getSchema(), this.attributeDescriptor.isReadOnly(), this.attributeDescriptor.isRequired(), this.attributeDescriptor.isCaseExact(), new AttributeDescriptor[0]);
                SCIMAttribute singularAttr = SCIMAttribute.create(singularDescriptor, v);
                if (!singularAttr.matchesFilter(filter)) continue;
                return true;
            }
        } else {
            SCIMAttributeValue v = this.getValue();
            if (v.isComplex()) {
                SCIMAttribute a;
                if (subAttributeName != null && (a = v.getAttribute(subAttributeName)) != null) {
                    AttributePath childPath = new AttributePath(schema, subAttributeName, null);
                    return a.matchesFilter(new SCIMFilter(type, childPath, filter.getFilterValue(), filter.isQuoteFilterValue(), filter.getFilterComponents()));
                }
            } else {
                if (type == SCIMFilterType.PRESENCE) {
                    return true;
                }
                AttributeDescriptor.DataType dataType = this.attributeDescriptor.getDataType();
                String stringValue = null;
                Double doubleValue = null;
                Long longValue = null;
                Date dateValue = null;
                Boolean boolValue = null;
                byte[] binValue = null;
                switch (dataType) {
                    case BINARY: {
                        binValue = v.getBinaryValue();
                        if (binValue != null) break;
                        return false;
                    }
                    case BOOLEAN: {
                        boolValue = v.getBooleanValue();
                        if (boolValue != null) break;
                        return false;
                    }
                    case DATETIME: {
                        dateValue = v.getDateValue();
                        if (dateValue != null) break;
                        return false;
                    }
                    case DECIMAL: {
                        doubleValue = v.getDecimalValue();
                        if (doubleValue != null) break;
                        return false;
                    }
                    case INTEGER: {
                        longValue = v.getIntegerValue();
                        if (longValue != null) break;
                        return false;
                    }
                    case STRING: {
                        stringValue = v.getStringValue();
                        if (stringValue != null) break;
                        return false;
                    }
                    default: {
                        throw new RuntimeException("Invalid attribute data type: " + (Object)((Object)dataType));
                    }
                }
                String filterValue = filter.getFilterValue();
                switch (type) {
                    case EQUALITY: {
                        if (stringValue != null) {
                            return stringValue.equalsIgnoreCase(filterValue);
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue == filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue == filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return boolValue == Boolean.parseBoolean(filterValue);
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.equals(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            try {
                                byte[] filterValueBytes = DatatypeConverter.parseBase64Binary((String)filterValue);
                                return Arrays.equals(binValue, filterValueBytes);
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case CONTAINS: {
                        if (stringValue != null) {
                            return StaticUtils.toLowerCase(stringValue).contains(StaticUtils.toLowerCase(filterValue));
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue == filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue == filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return boolValue == Boolean.parseBoolean(filterValue);
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.equals(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            try {
                                byte[] filterValueBytes = DatatypeConverter.parseBase64Binary((String)filterValue);
                                boolean contains = false;
                                for (int i = 0; i < binValue.length; ++i) {
                                    if (binValue[i] != filterValueBytes[0]) continue;
                                    contains = true;
                                    for (int j = 1; j < filterValueBytes.length; ++j) {
                                        if (i + j < binValue.length && binValue[i + j] == filterValueBytes[j]) continue;
                                        contains = false;
                                        break;
                                    }
                                    if (contains) break;
                                }
                                return contains;
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case STARTS_WITH: {
                        if (stringValue != null) {
                            return StaticUtils.toLowerCase(stringValue).startsWith(StaticUtils.toLowerCase(filterValue));
                        }
                        if (doubleValue != null) {
                            return false;
                        }
                        if (longValue != null) {
                            return false;
                        }
                        if (boolValue != null) {
                            return false;
                        }
                        if (dateValue != null) {
                            return false;
                        }
                        if (binValue != null) {
                            try {
                                byte[] filterValueBytes = DatatypeConverter.parseBase64Binary((String)filterValue);
                                for (int i = 0; i < filterValueBytes.length; ++i) {
                                    if (binValue[i] == filterValueBytes[i]) continue;
                                    return false;
                                }
                                return true;
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case GREATER_THAN: {
                        if (stringValue != null) {
                            return stringValue.compareToIgnoreCase(filterValue) > 0;
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue > filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue > filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return false;
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.after(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            return false;
                        }
                        return false;
                    }
                    case GREATER_OR_EQUAL: {
                        if (stringValue != null) {
                            return stringValue.compareToIgnoreCase(filterValue) >= 0;
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue >= filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue >= filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return false;
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.after(filterValueDate.getDateValue()) || dateValue.equals(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            return false;
                        }
                        return false;
                    }
                    case LESS_THAN: {
                        if (stringValue != null) {
                            return stringValue.compareToIgnoreCase(filterValue) < 0;
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue < filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue < filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return false;
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.before(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            return false;
                        }
                        return false;
                    }
                    case LESS_OR_EQUAL: {
                        if (stringValue != null) {
                            return stringValue.compareToIgnoreCase(filterValue) <= 0;
                        }
                        if (doubleValue != null) {
                            try {
                                double filterValueDouble = Double.parseDouble(filterValue);
                                return doubleValue <= filterValueDouble;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (longValue != null) {
                            try {
                                long filterValueLong = Long.parseLong(filterValue);
                                return longValue <= filterValueLong;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (boolValue != null) {
                            return false;
                        }
                        if (dateValue != null) {
                            try {
                                SimpleValue filterValueDate = new SimpleValue(filterValue);
                                return dateValue.before(filterValueDate.getDateValue()) || dateValue.equals(filterValueDate.getDateValue());
                            }
                            catch (IllegalArgumentException e) {
                                return false;
                            }
                        }
                        if (binValue != null) {
                            return false;
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCIMAttribute that = (SCIMAttribute)o;
        HashSet<SCIMAttributeValue> valueSet1 = new HashSet<SCIMAttributeValue>(Arrays.asList(this.values));
        HashSet<SCIMAttributeValue> valueSet2 = new HashSet<SCIMAttributeValue>(Arrays.asList(that.values));
        return this.attributeDescriptor.equals(that.attributeDescriptor) && valueSet1.equals(valueSet2);
    }

    public int hashCode() {
        int result = this.attributeDescriptor.hashCode();
        result = 31 * result + (this.values != null ? Arrays.hashCode(this.values) : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SCIMAttribute");
        sb.append("{attribute=").append(this.attributeDescriptor.getSchema());
        sb.append(':');
        sb.append(this.attributeDescriptor.getName());
        sb.append(", values=").append(this.values == null ? "null" : Arrays.asList(this.values).toString());
        sb.append('}');
        return sb.toString();
    }
}

