/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.AuthenticationScheme;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.GetResourceRequest;
import com.unboundid.scim.sdk.GetResourcesRequest;
import com.unboundid.scim.sdk.PatchResourceRequest;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMBackendConfig;
import com.unboundid.scim.sdk.SCIMException;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCIMBackend {
    private final SCIMBackendConfig config = new SCIMBackendConfig();

    public abstract void finalizeBackend();

    public SCIMBackendConfig getConfig() {
        return this.config;
    }

    public abstract BaseResource getResource(GetResourceRequest var1) throws SCIMException;

    public abstract Resources getResources(GetResourcesRequest var1) throws SCIMException;

    public abstract BaseResource postResource(PostResourceRequest var1) throws SCIMException;

    public abstract void deleteResource(DeleteResourceRequest var1) throws SCIMException;

    public abstract BaseResource putResource(PutResourceRequest var1) throws SCIMException;

    public abstract BaseResource patchResource(PatchResourceRequest var1) throws SCIMException;

    public boolean supportsSorting() {
        return true;
    }

    public boolean supportsVersioning() {
        return false;
    }

    public Collection<AuthenticationScheme> getSupportedAuthenticationSchemes() {
        return Collections.singleton(AuthenticationScheme.createBasic(true));
    }

    public abstract Collection<ResourceDescriptor> getResourceDescriptors();

    public ResourceDescriptor getResourceDescriptor(String endpoint) {
        for (ResourceDescriptor resourceDescriptor : this.getResourceDescriptors()) {
            if (!resourceDescriptor.getEndpoint().equals(endpoint)) continue;
            return resourceDescriptor;
        }
        return null;
    }
}

