/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMFilter;
import com.unboundid.scim.sdk.SCIMFilterType;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMObject {
    private final HashMap<String, LinkedHashMap<String, SCIMAttribute>> attributes = new HashMap();

    public SCIMObject() {
    }

    public SCIMObject(SCIMObject scimObject) {
        for (Map.Entry<String, LinkedHashMap<String, SCIMAttribute>> entry : scimObject.attributes.entrySet()) {
            this.attributes.put(entry.getKey(), new LinkedHashMap(entry.getValue()));
        }
    }

    public Set<String> getSchemas() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public boolean hasSchema(String schema) {
        return this.attributes.containsKey(StaticUtils.toLowerCase(schema));
    }

    public SCIMAttribute getAttribute(String schema, String name) {
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(StaticUtils.toLowerCase(schema));
        if (attrs == null) {
            return null;
        }
        return attrs.get(StaticUtils.toLowerCase(name));
    }

    public Collection<SCIMAttribute> getAttributes(String schema) {
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(StaticUtils.toLowerCase(schema));
        if (attrs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(attrs.values());
    }

    public boolean hasAttribute(String schema, String name) {
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(StaticUtils.toLowerCase(schema));
        AttributePath path = AttributePath.parse(name, schema);
        String attrName = StaticUtils.toLowerCase(path.getAttributeName());
        String subAttrName = path.getSubAttributeName();
        if (attrs != null && attrs.containsKey(attrName)) {
            if (subAttrName != null) {
                SCIMAttribute attr = attrs.get(attrName);
                for (SCIMAttributeValue value : attr.getValues()) {
                    if (!value.isComplex() || !value.hasAttribute(subAttrName)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean addAttribute(SCIMAttribute attribute) {
        String lowerCaseSchema = StaticUtils.toLowerCase(attribute.getSchema());
        String lowerCaseName = StaticUtils.toLowerCase(attribute.getName());
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(lowerCaseSchema);
        if (attrs == null) {
            attrs = new LinkedHashMap();
            attrs.put(lowerCaseName, attribute);
            this.attributes.put(lowerCaseSchema, attrs);
            return true;
        }
        if (attrs.containsKey(lowerCaseName)) {
            return false;
        }
        attrs.put(lowerCaseName, attribute);
        return true;
    }

    public void setAttribute(SCIMAttribute attribute) {
        String lowerCaseSchema = StaticUtils.toLowerCase(attribute.getSchema());
        String lowerCaseName = StaticUtils.toLowerCase(attribute.getName());
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(lowerCaseSchema);
        if (attrs == null) {
            attrs = new LinkedHashMap();
            attrs.put(lowerCaseName, attribute);
            this.attributes.put(lowerCaseSchema, attrs);
        } else {
            attrs.put(lowerCaseName, attribute);
        }
    }

    public boolean removeAttribute(String schema, String name) {
        String lowerCaseSchema = StaticUtils.toLowerCase(schema);
        LinkedHashMap<String, SCIMAttribute> attrs = this.attributes.get(lowerCaseSchema);
        if (attrs == null) {
            return false;
        }
        AttributePath path = AttributePath.parse(name, schema);
        String attrName = StaticUtils.toLowerCase(path.getAttributeName());
        String subAttrName = path.getSubAttributeName();
        boolean removed = false;
        if (subAttrName != null) {
            if (attrs.containsKey(attrName)) {
                SCIMAttribute attr = attrs.get(attrName);
                ArrayList<SCIMAttributeValue> finalComplexValues = new ArrayList<SCIMAttributeValue>(4);
                for (SCIMAttributeValue value : attr.getValues()) {
                    if (!value.isComplex()) continue;
                    Map<String, SCIMAttribute> subAttrMap = value.getAttributes();
                    ArrayList<SCIMAttribute> attrList = new ArrayList<SCIMAttribute>(10);
                    boolean nonNormativeSubAttributeExists = false;
                    for (String n : subAttrMap.keySet()) {
                        if (!n.equalsIgnoreCase(subAttrName)) {
                            attrList.add(subAttrMap.get(n));
                            if (n.equals("type") || n.equals("primary") || n.equals("operation") || n.equals("display")) continue;
                            nonNormativeSubAttributeExists = true;
                            continue;
                        }
                        removed = true;
                    }
                    if (attrList.isEmpty() || !nonNormativeSubAttributeExists) continue;
                    SCIMAttributeValue newComplexValue = SCIMAttributeValue.createComplexValue(attrList);
                    finalComplexValues.add(newComplexValue);
                }
                if (removed) {
                    if (!finalComplexValues.isEmpty()) {
                        SCIMAttribute finalAttr = SCIMAttribute.create(attr.getAttributeDescriptor(), finalComplexValues.toArray(new SCIMAttributeValue[finalComplexValues.size()]));
                        attrs.put(attrName, finalAttr);
                    } else {
                        attrs.remove(attrName);
                    }
                }
            }
        } else {
            boolean bl = removed = attrs.remove(attrName) != null;
        }
        if (removed && attrs.isEmpty()) {
            this.attributes.remove(lowerCaseSchema);
        }
        return removed;
    }

    public boolean matchesFilter(SCIMFilter filter) {
        SCIMFilterType type = filter.getFilterType();
        List<SCIMFilter> components = filter.getFilterComponents();
        switch (type) {
            case AND: {
                for (SCIMFilter component : components) {
                    if (this.matchesFilter(component)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (SCIMFilter component : components) {
                    if (!this.matchesFilter(component)) continue;
                    return true;
                }
                return false;
            }
        }
        String schema = filter.getFilterAttribute().getAttributeSchema();
        String attributeName = filter.getFilterAttribute().getAttributeName();
        SCIMAttribute attribute = this.getAttribute(schema, attributeName);
        return attribute != null && attribute.matchesFilter(filter);
    }

    public void checkSchema(ResourceDescriptor resourceDescriptor, boolean includeCommonAttributes) throws InvalidResourceException {
        for (String schema : resourceDescriptor.getAttributeSchemas()) {
            for (AttributeDescriptor attributeDescriptor : resourceDescriptor.getAttributes(schema)) {
                if (!includeCommonAttributes && (attributeDescriptor.equals(CoreSchema.ID_DESCRIPTOR) || attributeDescriptor.equals(CoreSchema.META_DESCRIPTOR) || attributeDescriptor.equals(CoreSchema.EXTERNAL_ID_DESCRIPTOR)) || attributeDescriptor.isReadOnly()) continue;
                SCIMAttribute attribute = this.getAttribute(schema, attributeDescriptor.getName());
                if (attributeDescriptor.isRequired() && attribute == null) {
                    throw new InvalidResourceException("Attribute '" + schema + ":" + attributeDescriptor.getName() + "' is required");
                }
                Collection<AttributeDescriptor> subAttributes = attributeDescriptor.getSubAttributes();
                if (subAttributes == null || attribute == null) continue;
                for (AttributeDescriptor subAttribute : subAttributes) {
                    if (!subAttribute.isRequired()) continue;
                    if (attributeDescriptor.isMultiValued()) {
                        for (SCIMAttributeValue value : attribute.getValues()) {
                            if (value.hasAttribute(subAttribute.getName())) continue;
                            throw new InvalidResourceException("Sub-Attribute '" + schema + ":" + attributeDescriptor.getName() + "." + subAttribute.getName() + "' is required for all " + "values of the multi-valued attribute");
                        }
                        continue;
                    }
                    if (attribute.getValue().hasAttribute(subAttribute.getName())) continue;
                    throw new InvalidResourceException("Sub-Attribute '" + schema + ":" + attributeDescriptor.getName() + "." + subAttribute.getName() + "' is required");
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCIMObject that = (SCIMObject)o;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "SCIMObject{attributes=" + this.attributes + '}';
    }
}

